/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ejs.cm.DSMigrationHelper;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DSMigrationHelperImpl
implements DSMigrationHelper {
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$DSMigrationHelper == null ? (class$com$ibm$ejs$cm$DSMigrationHelper = DSMigrationHelperImpl.class$("com.ibm.ejs.cm.DSMigrationHelper")) : class$com$ibm$ejs$cm$DSMigrationHelper));
    static /* synthetic */ Class class$com$ibm$ejs$cm$DSMigrationHelper;

    public Properties migrateDataSourcesXML(String string, Element element) {
        Properties properties = new Properties();
        boolean bl = false;
        StringBuffer stringBuffer = null;
        if (string.equals("com.sybase.jdbc2.jdbc.SybDriver") || string.equals("com.sybase.jdbc.SybDriver")) {
            bl = true;
            stringBuffer = new StringBuffer();
        }
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!node.getNodeName().equals("attribute")) continue;
            Element element2 = (Element)node;
            String string2 = element2.getAttribute("name");
            String string3 = element2.getAttribute("value");
            if (string2 == null || string3 == null) continue;
            if (bl && !string2.equals("disableAutoConnectionCleanup")) {
                if (stringBuffer.length() > 0) {
                    stringBuffer.append(";");
                }
                stringBuffer.append(string2 + "=" + string3);
                continue;
            }
            properties.setProperty(string2, string3);
        }
        if (bl) {
            properties.setProperty("connectionProperties", stringBuffer.toString());
        }
        return properties;
    }

    public Properties migrateDataSource(String string, String string2, String string3, String string4) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"migrateDataSourceDriver", (Object)new Object[]{string, string2, string3, string4});
        }
        boolean bl = Boolean.valueOf(string4);
        Properties properties = null;
        if (string.equals("com.ibm.db2.jdbc.app.DB2Driver") && !System.getProperty("os.name").equals("OS/400")) {
            string = "COM.ibm.db2.jdbc.app.DB2Driver";
        }
        if (string.equals("COM.ibm.db2.jdbc.app.DB2Driver") || string.equals("COM.ibm.db2.jdbc.net.DB2Driver")) {
            properties = DSMigrationHelperImpl.migrateDB2JDBCDriver(string2, string3, bl);
        } else if (string.equals("com.ibm.as400.access.AS400JDBCDriver")) {
            properties = DSMigrationHelperImpl.migrateDB2AS400ToolboxJDBCDriver(string2, string3, bl);
        } else if (string.equals("com.ibm.db2.jdbc.app.DB2Driver")) {
            properties = DSMigrationHelperImpl.migrateDB2AS400NativeJDBCDriver(string2, string3, bl);
        } else if (string.equals("jdbc.idbDriver") || string.equals("org.enhydra.instantdb.jdbc.idbDriver")) {
            properties = DSMigrationHelperImpl.migrateIDBJDBCDriver(string2, string3, bl);
        } else if (string.equals("com.merant.sequelink.jdbc.SequeLinkDriver")) {
            properties = DSMigrationHelperImpl.migrateMerantJDBCDriver(string2, string3, bl);
        } else if (string.equals("oracle.jdbc.driver.OracleDriver")) {
            properties = DSMigrationHelperImpl.migrateOracleJDBCDriver(string2, string3, bl);
        } else if (string.equals("com.sybase.jdbc2.jdbc.SybDriver") || string.equals("com.sybase.jdbc.SybDriver")) {
            properties = DSMigrationHelperImpl.migrateSybaseJDBCDriver(string2, string3, bl);
        } else {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Got unknown driverClass: " + string));
            }
            properties = new Properties();
            properties.setProperty("dataSourceClassName", string);
            properties.setProperty("databaseName", string3);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"migrateDataSourceDriver", (Object)properties);
        }
        return properties;
    }

    public Properties migrateAdminDotConfig(String string, String string2, String string3, String string4, String string5) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"migrateAdminDotConfig", (Object)new Object[]{string, string2, string3, string5});
        }
        Properties properties = new Properties();
        String[] stringArray = this.convertUrlToUrlPrefixAndDatabaseName(string2, string);
        Properties properties2 = this.migrateDataSource(string, stringArray[0], stringArray[1], "false");
        Enumeration<?> enumeration = properties2.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string6 = (String)enumeration.nextElement();
            properties.setProperty("com.ibm.ejs.sm.adminServer.db" + string6, properties2.getProperty(string6));
        }
        if (string3 != null) {
            properties.setProperty("com.ibm.ejs.sm.adminServer.dbuser", string3);
        }
        if (string5 != null) {
            properties.setProperty("com.ibm.ejs.sm.adminServer.dbmaximumPoolSize", string5);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"migrateAdminDotConfig", (Object)properties);
        }
        if (string4 != null) {
            properties.setProperty("com.ibm.ejs.sm.adminServer.dbpassword", string4);
        }
        return properties;
    }

    public String[] convertUrlToUrlPrefixAndDatabaseName(String string, String string2) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertUrlToUrlPrefixAndDatabaseName", (Object)new Object[]{string, string2});
        }
        String[] stringArray = new String[2];
        int n = 0;
        if (string2.equals("com.merant.sequelink.jdbc.SequeLinkDriver")) {
            n = string.indexOf(59);
            if (n == -1) {
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                String string3 = string.substring(n + 1);
                int n2 = string3.indexOf("databaseName");
                stringArray[1] = n2 == -1 ? string3 : (n2 == 0 ? string3.substring(13) : ((n = string3.indexOf(59, n2)) == -1 ? string3.substring(n2 + 13) + ";" + string3.substring(0, n2 - 1) : string3.substring(n2 + 13, n + 1) + string3.substring(0, n2 - 1) + string3.substring(n)));
            }
        } else {
            n = string2.equals("com.sybase.jdbc2.jdbc.SybDriver") || string2.equals("com.sybase.jdbc.SybDriver") ? string.indexOf(47) : string.lastIndexOf(58);
            if (n == -1) {
                stringArray[0] = string;
                stringArray[1] = null;
            } else {
                stringArray[0] = string.substring(0, n);
                stringArray[1] = string.substring(n + 1);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertUrlToUrlPrefixAndDatabaseName", (Object)stringArray);
        }
        return stringArray;
    }

    private static Properties migrateDB2JDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        if (bl) {
            properties.setProperty("dataSourceClassName", "COM.ibm.db2.jdbc.DB2XADataSource");
        } else {
            properties.setProperty("dataSourceClassName", "COM.ibm.db2.jdbc.DB2ConnectionPoolDataSource");
        }
        properties.setProperty("databaseName", string2);
        return properties;
    }

    private static Properties migrateDB2AS400ToolboxJDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        if (bl) {
            properties.setProperty("dataSourceClassName", "com.ibm.as400.access.AS400JDBCXADataSource");
        } else {
            properties.setProperty("dataSourceClassName", "com.ibm.as400.access.AS400JDBCConnectionPoolDataSource");
        }
        DSMigrationHelperImpl.migrateDB2AS400JDBCDriver(string, string2, bl, properties, "serverName");
        return properties;
    }

    private static Properties migrateDB2AS400NativeJDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        if (bl) {
            properties.setProperty("dataSourceClassName", "com.ibm.db2.jdbc.app.DB2StdXADataSource");
        } else {
            properties.setProperty("dataSourceClassName", "com.ibm.db2.jdbc.app.DB2StdConnectionPoolDataSource");
        }
        DSMigrationHelperImpl.migrateDB2AS400JDBCDriver(string, string2, bl, properties, "databaseName");
        return properties;
    }

    private static void migrateDB2AS400JDBCDriver(String string, String string2, boolean bl, Properties properties, String string3) {
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ";");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (string4.charAt(0) == '/') {
                if (string4.charAt(1) == '/') {
                    DSMigrationHelperImpl.parseServerName(string4.substring(2), properties, string3);
                    continue;
                }
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"migrateDB2AS400JDBCDriver", (Object)"Invalid URL - ignoring leading slash.");
                }
                DSMigrationHelperImpl.parseServerName(string4.substring(1), properties, string3);
                continue;
            }
            if (string4.indexOf(61) >= 0) {
                DSMigrationHelperImpl.setAS400Property(string4, properties);
                continue;
            }
            DSMigrationHelperImpl.parseServerName(string4, properties, string3);
        }
    }

    private static void parseServerName(String string, Properties properties, String string2) {
        int n = string.indexOf(47);
        if (n >= 0) {
            properties.setProperty(string2, string.substring(0, n));
            properties.setProperty("libraries", string.substring(n + 1));
        } else {
            properties.setProperty(string2, string);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setAS400Property(String string, Properties properties) {
        int n = string.indexOf(61);
        if (n == -1) {
            return;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        if (string2.equals("bidirectional string type")) {
            string2 = "bidiStringType";
        } else if (string2.equals("block enabled")) {
            if (!string3.equals("false")) return;
            string2 = "blockSize";
            string3 = "0";
        } else if (string2.equals("CURSORHOLD")) {
            string2 = "cursorHold";
        } else if (string2.equals("errors")) {
            string2 = "errorsOption";
        } else if (string2.equals("naming")) {
            string2 = "namingOption";
        } else if (string2.equals("trace")) {
            string2 = "traceActive";
        } else if (string2.equals("transaction isolation")) {
            string2 = "transactionIsolationLevel";
        }
        int n2 = string2.indexOf(" ");
        while (n2 != -1) {
            string2 = string2.substring(0, n2) + Character.toUpperCase(string2.charAt(n2 + 1)) + string2.substring(n2 + 2);
            n2 = string2.indexOf(" ", n2);
        }
        properties.setProperty(string2, string3);
    }

    private static Properties migrateIDBJDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        if (bl && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The jtaEnabled flag is ignored for instantDB");
        }
        properties.setProperty("dataSourceClassName", "com.ibm.ejs.cm.portability.IDBConnectionPoolDataSource");
        properties.setProperty("url", string + ":" + string2);
        properties.setProperty("driverName", "org.enhydra.instantdb.jdbc.idbDriver");
        return properties;
    }

    private static Properties migrateMerantJDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        properties.setProperty("dataSourceClassName", "com.merant.sequelink.jdbcx.datasource.SequeLinkDataSource");
        int n = string.lastIndexOf(47);
        int n2 = string.indexOf(":", n);
        properties.setProperty("serverName", string.substring(n + 1, n2));
        properties.setProperty("portNumber", string.substring(n2 + 1));
        if (string2 != null) {
            int n3 = string2.indexOf(59);
            if (n3 == -1) {
                properties.setProperty("databaseName", string2);
            } else {
                properties.setProperty("databaseName", string2.substring(0, n3));
                int n4 = -1;
                while (n3 != -1) {
                    n4 = string2.indexOf(59, n3 + 1);
                    int n5 = string2.indexOf(61, n3 + 1);
                    String string3 = null;
                    String string4 = null;
                    string3 = string2.substring(n3 + 1, n5);
                    string4 = n4 == -1 ? string2.substring(n5 + 1) : string2.substring(n5 + 1, n4);
                    properties.setProperty(string3, string4);
                    n3 = n4;
                }
            }
        }
        return properties;
    }

    private static Properties migrateOracleJDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        if (bl) {
            properties.setProperty("dataSourceClassName", "oracle.jdbc.xa.client.OracleXADataSource");
        } else {
            properties.setProperty("dataSourceClassName", "oracle.jdbc.pool.OracleConnectionPoolDataSource");
        }
        properties.setProperty("URL", string + ":" + string2);
        return properties;
    }

    private static Properties migrateSybaseJDBCDriver(String string, String string2, boolean bl) {
        Properties properties = new Properties();
        if (bl) {
            properties.setProperty("dataSourceClassName", "com.sybase.jdbc2.jdbc.SybXADataSource");
        } else {
            properties.setProperty("dataSourceClassName", "com.sybase.jdbc2.jdbc.SybConnectionPoolDataSource");
        }
        int n = string.indexOf("Tds:");
        int n2 = string.lastIndexOf(58);
        properties.setProperty("serverName", string.substring(n + 4, n2));
        properties.setProperty("portNumber", string.substring(n2 + 1));
        if (string2 != null) {
            int n3 = string2.indexOf(63);
            if (n3 == -1) {
                properties.setProperty("databaseName", string2);
            } else {
                properties.setProperty("databaseName", string2.substring(0, n3));
                String string3 = string2.substring(n3 + 1);
                String string4 = string3.replace('&', ';');
                properties.setProperty("connectionProperties", string4);
            }
        }
        return properties;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

