/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.pool.ConnectionFactory;
import com.ibm.ejs.cm.pool.ConnectionPool;
import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.management.MBeanFactory;
import com.ibm.websphere.management.exception.AdminException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.management.collaborator.DefaultRuntimeCollaborator;
import java.io.PrintWriter;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import java.util.Set;
import javax.management.ObjectName;

public abstract class DataSourceImpl
implements PortableDataSource {
    private DefaultRuntimeCollaborator collab;
    protected transient ConnectionPool source;
    protected final CMPropertiesImpl attrs;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$DataSourceImpl == null ? (class$com$ibm$ejs$cm$DataSourceImpl = DataSourceImpl.class$("com.ibm.ejs.cm.DataSourceImpl")) : class$com$ibm$ejs$cm$DataSourceImpl));
    private static final TraceComponent tc2 = Tr.register((String)"com.ibm.ejs.cm.MBeans", null, (String)"com.ibm.ws.runtime.runtime");
    static /* synthetic */ Class class$com$ibm$ejs$cm$DataSourceImpl;

    protected DataSourceImpl(CMProperties cMProperties) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)cMProperties);
        }
        this.attrs = (CMPropertiesImpl)cMProperties;
        this.registerMBean(this.attrs.getMBeanFactoryId(), this.attrs.getMBeanProviderId());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public String toString() {
        return "WebSphere DataSource:" + this.attrs;
    }

    public final PortabilityLayerExt getPortabilityLayer() throws SQLException {
        return this.getSource().getPortabilityLayer();
    }

    public CMProperties getAttributes() {
        return this.attrs;
    }

    public Connection getConnection() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection");
        }
        Connection connection = null;
        connection = this.getConnection(null, null);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getConnection", (Object)string);
        }
        final String string3 = string;
        final String string4 = string2;
        Connection connection = null;
        try {
            boolean bl = false;
            if (this.source == null && this.attrs.getUser() == null) {
                this.attrs.setTmpUser(string3);
                this.attrs.setTmpPassword(string4);
                bl = true;
            }
            connection = (Connection)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    return DataSourceImpl.this.getSource().getConnection(string3, string4);
                }
            });
            if (bl) {
                if (this.attrs.getTmpUser() != null) {
                    this.attrs.setTmpUser(null);
                }
                if (this.attrs.getTmpPassword() != null) {
                    this.attrs.setTmpPassword(null);
                }
            }
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getException();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getConnection", (Object)connection);
        }
        return connection;
    }

    public int getLoginTimeout() throws SQLException {
        return this.getSource().getLoginTimeout();
    }

    public void setLoginTimeout(int n) throws SQLException {
        this.getSource().setLoginTimeout(n);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.getSource().getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        final PrintWriter printWriter2 = printWriter;
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws Exception {
                    DataSourceImpl.this.getSource().setLogWriter(printWriter2);
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (SQLException)privilegedActionException.getException();
        }
    }

    protected abstract ConnectionFactory createConnectionFactory() throws SQLException;

    public synchronized ConnectionPool getSource() throws SQLException {
        if (this.source == null) {
            ConnectionFactory connectionFactory = null;
            try {
                connectionFactory = (ConnectionFactory)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws Exception {
                        return DataSourceImpl.this.createConnectionFactory();
                    }
                });
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw (SQLException)privilegedActionException.getException();
            }
            this.source = new ConnectionPool(connectionFactory, this.attrs, this.attrs.getPassword());
        }
        return this.source;
    }

    protected final synchronized void destroy() {
        if (this.source != null) {
            this.source.destroy();
        }
        this.source = null;
    }

    private Boolean registerMBean(String string, String string2) {
        Object object;
        block18: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"registerMBean");
            }
            PrivExAction privExAction = new PrivExAction();
            privExAction.setMBeanID(string);
            privExAction.setMBeanName(this.attrs.getName());
            String string3 = null;
            String string4 = null;
            if (string2 != null && !string2.equals("")) {
                block17: {
                    try {
                        object = AdminServiceFactory.getAdminService();
                        if (object != null) {
                            ObjectName objectName = new ObjectName("WebSphere:mbeanIdentifier=" + string2 + ",*");
                            Set set = object.queryNames(objectName, null);
                            ObjectName objectName2 = (ObjectName)set.iterator().next();
                            string3 = objectName2.getKeyProperty("name");
                            string4 = objectName2.getKeyProperty("Server");
                        } else if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"No Admin Service available in this process.  If this is a client process, this is expected. The MBean may still be registered, but will be missing the server= and [JDBCProvider]= properties.");
                        }
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.j2c.DataSourceImpl.registerMBean", (String)"%c", (Object)this);
                        if (!tc.isDebugEnabled()) break block17;
                        Tr.debug((TraceComponent)tc, (String)"An exception occurred when trying to obtain the parent MBean for this connection factory");
                        Tr.debug((TraceComponent)tc, (String)"This is not a terminal failure, however the MBean that will be created for this connection factory will be missing the server= and [JDBCProvider]= properties.");
                        Tr.debug((TraceComponent)tc, (String)("The parent MBean's identifier is " + string2));
                        Tr.debug((TraceComponent)tc, (String)"The exception is ", (Object)exception);
                    }
                }
                if (string3 != null && !string3.equals("")) {
                    privExAction.setMBeanParentName(string3);
                }
                if (string4 != null && !string4.equals("")) {
                    privExAction.setServer(string4);
                }
            }
            if (string != null && !string.equals("") && string2 != null && !string2.equals("")) {
                this.collab = new DefaultRuntimeCollaborator(this, string);
                privExAction.setCollaborator(this.collab);
                try {
                    object = (Boolean)AccessController.doPrivileged(privExAction);
                }
                catch (PrivilegedActionException privilegedActionException) {
                    FFDCFilter.processException((Throwable)privilegedActionException, (String)"com.ibm.ejs.cm.DataSourceImpl.registerMBean", (String)"%c", (Object)this);
                    object = new Boolean(false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Error registering MBean with Id " + string));
                        Tr.debug((TraceComponent)tc, (String)"Processing continues - registering an MBean should not effect the server.");
                    }
                    break block18;
                }
                catch (ClassCastException classCastException) {
                    FFDCFilter.processException((Throwable)classCastException, (String)"com.ibm.ejs.cm.DataSourceImpl.registerMBean", (String)"%c", (Object)this);
                    object = new Boolean(false);
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Class cast exception on rVal of registerMBean.");
                        Tr.debug((TraceComponent)tc, (String)"Processing continues");
                    }
                    break block18;
                }
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Unable to create WAS40DataSource MBean with the following data");
                Tr.debug((TraceComponent)tc, (String)("factoryID = " + string));
                Tr.debug((TraceComponent)tc, (String)("providerId = " + string2));
            }
            object = new Boolean(false);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"registerMBean returning ", (Object)object);
        }
        return object;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PrivExAction
    implements PrivilegedExceptionAction {
        private String mbeanID = null;
        private String mbeanName = null;
        private DefaultRuntimeCollaborator collab = null;
        private String mbeanParentName = null;
        private String server = null;

        private PrivExAction() {
        }

        public void setMBeanID(String string) {
            this.mbeanID = string;
        }

        public void setMBeanName(String string) {
            this.mbeanName = string;
        }

        public void setMBeanParentName(String string) {
            this.mbeanParentName = string;
        }

        public void setServer(String string) {
            this.server = string;
        }

        public void setCollaborator(DefaultRuntimeCollaborator defaultRuntimeCollaborator) {
            this.collab = defaultRuntimeCollaborator;
        }

        public Object run() {
            Boolean bl = new Boolean(false);
            MBeanFactory mBeanFactory = AdminServiceFactory.getMBeanFactory();
            if (mBeanFactory != null) {
                Properties properties = new Properties();
                if (this.mbeanName != null) {
                    properties.setProperty("name", this.mbeanName);
                }
                if (this.server != null) {
                    properties.setProperty("Server", this.server);
                }
                if (this.mbeanParentName != null) {
                    properties.setProperty("JDBCProvider", this.mbeanParentName);
                }
                try {
                    mBeanFactory.activateMBean("WAS40DataSource", this.collab, this.mbeanID, null, properties);
                    bl = new Boolean(true);
                }
                catch (AdminException adminException) {
                    FFDCFilter.processException((Throwable)((Object)adminException), (String)"com.ibm.ejs.cm.DataSourceImpl.registerMBean", (String)"330", (Object)this);
                    Object[] objectArray = new Object[]{"WAS40DataSource", adminException};
                    Tr.service((TraceComponent)tc2, (String)"WSVR0400W", (Object)objectArray);
                }
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No MBeanFactory available in this process.  If this is a client process, this is expected.  MBean will not be registered, and MBean services will not be available for this datasource.");
            }
            return bl;
        }
    }
}

