/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm;

import com.ibm.ISecurityUtilityImpl.PasswordUtil;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.ws.security.util.AccessController;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;

public class DataSourceProperties
implements Cloneable,
Serializable {
    public static final int DATASOURCE = 1;
    public static final int CONNECTIONPOOL_DATASOURCE = 2;
    public static final int XA_DATASOURCE = 4;
    private String className;
    private transient Class dataSourceClass = null;
    private transient int dataSourceType = 0;
    private Properties props;
    private static final String bundleName = "com.ibm.ejs.resources.CONMMessages";
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$DataSourceProperties == null ? (class$com$ibm$ejs$cm$DataSourceProperties = DataSourceProperties.class$("com.ibm.ejs.cm.DataSourceProperties")) : class$com$ibm$ejs$cm$DataSourceProperties), null, (String)"com.ibm.ejs.resources.CONMMessages");
    static /* synthetic */ Class class$javax$sql$DataSource;
    static /* synthetic */ Class class$javax$sql$ConnectionPoolDataSource;
    static /* synthetic */ Class class$javax$sql$XADataSource;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$util$Properties;
    static /* synthetic */ Class class$com$ibm$ejs$cm$DataSourceProperties;

    public DataSourceProperties() {
        this.props = new Properties();
    }

    public DataSourceProperties(String string, Properties properties) {
        this.setDataSourceClassName(string);
        this.props = properties;
    }

    public String getDataSourceClassName() {
        return this.className;
    }

    public void setDataSourceClassName(String string) {
        this.className = string;
        this.dataSourceClass = null;
        this.dataSourceType = 0;
    }

    public DataSource getDataSource() throws SQLException {
        DataSource dataSource = null;
        try {
            dataSource = (DataSource)this.getGenericDataSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7005E", (Object)this.className);
            String string = "The class (" + this.className + ") does not implement" + " javax.sql.DataSource";
            throw new SQLException(TraceNLS.getTraceNLS((String)bundleName).getFormattedMessage("MSG_CONM_7005E", new Object[]{this.className}, string));
        }
        return dataSource;
    }

    public ConnectionPoolDataSource getConnectionPoolDataSource() throws SQLException {
        ConnectionPoolDataSource connectionPoolDataSource = null;
        try {
            connectionPoolDataSource = (ConnectionPoolDataSource)this.getGenericDataSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7005E", (Object)this.className);
            String string = "The class (" + this.className + ") does not implement" + " javax.sql.ConnectionPoolDataSource";
            throw new SQLException(TraceNLS.getTraceNLS((String)bundleName).getFormattedMessage("MSG_CONM_7005E", new Object[]{this.className}, string));
        }
        return connectionPoolDataSource;
    }

    public XADataSource getXADataSource() throws SQLException {
        XADataSource xADataSource = null;
        try {
            xADataSource = (XADataSource)this.getGenericDataSource();
        }
        catch (ClassCastException classCastException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7005E", (Object)this.className);
            String string = "The class (" + this.className + ") does not implement" + " javax.sql.XADataSource";
            throw new SQLException(TraceNLS.getTraceNLS((String)bundleName).getFormattedMessage("MSG_CONM_7005E", new Object[]{this.className}, string));
        }
        return xADataSource;
    }

    private Object getGenericDataSource() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getGenericDataSource");
        }
        Object object = this.instantiateObject(this.getDataSourceClassName());
        this.setGenericDataSourceProperties(object);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getGenericDataSource", (Object)object);
        }
        return object;
    }

    public int getDataSourceType() throws SQLException {
        if (this.dataSourceType == 0) {
            if (this.dataSourceClass == null) {
                this.loadDataSourceClass();
            }
            if ((class$javax$sql$DataSource == null ? (class$javax$sql$DataSource = DataSourceProperties.class$("javax.sql.DataSource")) : class$javax$sql$DataSource).isAssignableFrom(this.dataSourceClass)) {
                ++this.dataSourceType;
            }
            if ((class$javax$sql$ConnectionPoolDataSource == null ? (class$javax$sql$ConnectionPoolDataSource = DataSourceProperties.class$("javax.sql.ConnectionPoolDataSource")) : class$javax$sql$ConnectionPoolDataSource).isAssignableFrom(this.dataSourceClass)) {
                this.dataSourceType += 2;
            }
            if ((class$javax$sql$XADataSource == null ? (class$javax$sql$XADataSource = DataSourceProperties.class$("javax.sql.XADataSource")) : class$javax$sql$XADataSource).isAssignableFrom(this.dataSourceClass)) {
                this.dataSourceType += 4;
            }
        }
        return this.dataSourceType;
    }

    public Object setProperty(String string, String string2) {
        return this.props.setProperty(string, string2);
    }

    public String getProperty(String string) {
        if (string.equals("password")) {
            return PasswordUtil.passwordDecode((String)this.props.getProperty(string));
        }
        return this.props.getProperty(string);
    }

    public Enumeration propertyNames() {
        return this.props.propertyNames();
    }

    public Object remove(Object object) {
        return this.props.remove(object);
    }

    public boolean equals(Object object) {
        try {
            DataSourceProperties dataSourceProperties = (DataSourceProperties)object;
            return (this.className == null && dataSourceProperties.className == null || this.className.equals(dataSourceProperties.className)) && this.props.equals(dataSourceProperties.props);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public Object clone() {
        DataSourceProperties dataSourceProperties = null;
        try {
            dataSourceProperties = (DataSourceProperties)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        if (this.props != null) {
            dataSourceProperties.props = (Properties)this.props.clone();
        }
        return dataSourceProperties;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DataSource Properties [" + this.getDataSourceClassName() + "]: {");
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (string.equals("password")) {
                stringBuffer.append("password=XXXXXXXX");
            } else if (string.equals("tmpPassword")) {
                stringBuffer.append("tmpPassword=XXXXXXXX");
            } else {
                stringBuffer.append(string + "=" + this.props.getProperty(string));
            }
            stringBuffer.append(";");
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    private Object instantiateObject(String string) throws SQLException {
        Object var2_2 = null;
        if (this.dataSourceClass == null) {
            this.loadDataSourceClass();
        }
        try {
            var2_2 = this.dataSourceClass.newInstance();
        }
        catch (InstantiationException instantiationException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7006E", (Object)new Object[]{string, "<unknown>", instantiationException});
            throw new SQLException(TraceNLS.getTraceNLS((String)bundleName).getFormattedMessage("MSG_CONM_7006E", new Object[]{string, "<unknown>", instantiationException}, "MSG_CONM_7006E"));
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7006E", (Object)new Object[]{string, "<unknown>", illegalAccessException});
            throw new SQLException(TraceNLS.getTraceNLS((String)bundleName).getFormattedMessage("MSG_CONM_7006E", new Object[]{string, "<unknown>", illegalAccessException}, "MSG_CONM_7006E"));
        }
        return var2_2;
    }

    private void loadDataSourceClass() throws SQLException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        try {
            this.dataSourceClass = classLoader.loadClass(this.className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_1006E", (Object)new Object[]{this.className, "<unknown>"});
            throw new SQLException(TraceNLS.getTraceNLS((String)bundleName).getFormattedMessage("MSG_CONM_1006E", new Object[]{this.className, "<unknown>"}, "MSG_CONM_1006E"));
        }
    }

    private void setGenericDataSourceProperties(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"setGenericDataSourceProperties", (Object)object);
        }
        Class<?> clazz = object.getClass();
        PropertyDescriptor[] propertyDescriptorArray = null;
        try {
            propertyDescriptorArray = this.getPropertyDescriptors(clazz);
        }
        catch (IntrospectionException introspectionException) {
            Tr.error((TraceComponent)tc, (String)"MSG_CONM_7001E", (Object)new Object[]{clazz.getName(), introspectionException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setGenericDataSourceProperties", (Object)introspectionException);
            }
            return;
        }
        Enumeration<?> enumeration = this.props.propertyNames();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.props.getProperty(string);
            if (string.equals("tmpUser") || string.equals("tmpPassword") || string2.equals("") || string2 == null) continue;
            this.setProperty(string, string2, object, propertyDescriptorArray);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setGenericDataSourceProperties");
        }
    }

    private PropertyDescriptor[] getPropertyDescriptors(Class propertyDescriptorArray) throws IntrospectionException {
        PropertyDescriptor[] propertyDescriptorArray2;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"getPropertyDescriptors", (Object)propertyDescriptorArray);
        }
        BeanInfo beanInfo = null;
        try {
            propertyDescriptorArray2 = propertyDescriptorArray;
            beanInfo = (BeanInfo)AccessController.doPrivileged((PrivilegedExceptionAction)new PrivilegedExceptionAction((Class)propertyDescriptorArray2){
                private final /* synthetic */ Class val$fc;
                {
                    this.val$fc = clazz;
                }

                public Object run() throws IntrospectionException {
                    return Introspector.getBeanInfo(this.val$fc);
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IntrospectionException)privilegedActionException.getException();
        }
        propertyDescriptorArray2 = beanInfo.getPropertyDescriptors();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"getPropertyDescriptors");
        }
        return propertyDescriptorArray2;
    }

    private PropertyDescriptor findPropertyDescriptorFor(String string, PropertyDescriptor[] propertyDescriptorArray) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findPropertyDescriptorFor", (Object)new Object[]{string, propertyDescriptorArray});
        }
        PropertyDescriptor propertyDescriptor = null;
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            if (!propertyDescriptorArray[i].getName().equals(string)) continue;
            propertyDescriptor = propertyDescriptorArray[i];
            break;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findPropertyDescriptorFor", propertyDescriptor);
        }
        return propertyDescriptor;
    }

    private boolean setProperty(String string, String string2, Object object, PropertyDescriptor[] propertyDescriptorArray) {
        if (string == null) {
            return false;
        }
        if (tc.isEntryEnabled()) {
            if (!string.equalsIgnoreCase("password")) {
                Tr.entry((TraceComponent)tc, (String)"setProperty", (Object)new Object[]{string, string2});
            } else {
                Tr.entry((TraceComponent)tc, (String)"setProperty", (Object)new Object[]{string, "XXXXXX"});
            }
        }
        Class<?> clazz = object.getClass();
        PropertyDescriptor propertyDescriptor = this.findPropertyDescriptorFor(string, propertyDescriptorArray);
        if (propertyDescriptor == null) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7002W", (Object)new Object[]{string, clazz.getName()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)"false");
            }
            return false;
        }
        Object object2 = this.convertToDeclaredPropertyType(string2, propertyDescriptor);
        Method method = propertyDescriptor.getWriteMethod();
        if (method == null) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7003W", (Object)new Object[]{string, clazz.getName()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)"false");
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Got write method", (Object)method);
        }
        Object[] objectArray = new Object[]{object2};
        try {
            method.invoke(object, objectArray);
        }
        catch (IllegalAccessException illegalAccessException) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7004W", (Object)new Object[]{string, clazz.getName(), illegalAccessException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)"false");
            }
            return false;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7004W", (Object)new Object[]{string, clazz.getName(), illegalArgumentException});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)"false");
            }
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_7004W", (Object)new Object[]{string, clazz.getName(), invocationTargetException.getTargetException()});
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)"false");
            }
            return false;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setProperty", (Object)"true");
        }
        return true;
    }

    private Object convertToDeclaredPropertyType(String string, PropertyDescriptor propertyDescriptor) {
        Object object;
        block14: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"convertToDeclaredPropertyType", (Object)propertyDescriptor);
            }
            object = string;
            Class<Constable> clazz = propertyDescriptor.getPropertyType();
            if (clazz.isAssignableFrom(class$java$lang$String == null ? (class$java$lang$String = DataSourceProperties.class$("java.lang.String")) : class$java$lang$String)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"convertToDeclaredPropertyType");
                }
                return string;
            }
            Class<?> clazz2 = string.getClass();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("GivenPropertyType=" + clazz2.getName() + "; DeclaredPropertyType = " + clazz.getName()));
            }
            try {
                if (clazz.isAssignableFrom(Integer.TYPE) || clazz.isAssignableFrom(class$java$lang$Integer == null ? (class$java$lang$Integer = DataSourceProperties.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                    object = Integer.valueOf(string);
                } else if (clazz.isAssignableFrom(Boolean.TYPE) || clazz.isAssignableFrom(class$java$lang$Boolean == null ? (class$java$lang$Boolean = DataSourceProperties.class$("java.lang.Boolean")) : class$java$lang$Boolean)) {
                    object = Boolean.valueOf(string);
                } else if (clazz.isAssignableFrom(class$java$util$Properties == null ? (class$java$util$Properties = DataSourceProperties.class$("java.util.Properties")) : class$java$util$Properties)) {
                    object = this.convertStringToProperties(string);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Conversion to declared method type " + clazz.getName() + " will not occur because class is unknown."));
                }
            }
            catch (NumberFormatException numberFormatException) {
                if (!tc.isDebugEnabled()) break block14;
                Tr.debug((TraceComponent)tc, (String)"Attempt to convert property to Integer because the declared method is int/Integer failed", (Object)numberFormatException);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertToDeclaredPropertyType", (Object)object);
        }
        return object;
    }

    private Properties convertStringToProperties(String string) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"convertStringToProperties", (Object)string);
        }
        Properties properties = new Properties();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";=");
        while (stringTokenizer.hasMoreTokens()) {
            properties.setProperty(stringTokenizer.nextToken(), stringTokenizer.nextToken());
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"convertStringToProperties", (Object)properties);
        }
        return properties;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        String string = this.getProperty("password");
        if (string != null) {
            this.setProperty("password", PasswordUtil.passwordEncode((String)string));
        }
        objectOutputStream.defaultWriteObject();
        if (string != null) {
            this.setProperty("password", PasswordUtil.passwordDecode((String)string));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        String string = this.getProperty("password");
        if (string != null) {
            this.setProperty("password", PasswordUtil.passwordDecode((String)string));
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

