/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.cache;

import com.ibm.ejs.cm.cache.StatementCache;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.LRUCacheElement;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.BitSet;
import java.util.Calendar;

public final class CachedStatement
extends LRUCacheElement
implements PreparedStatement {
    private StatementCache cache;
    private BitSet currentBitSet;
    private BitSet priorBitSet;
    private PreparedStatement statement;
    private boolean bitSetError = false;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$cache$CachedStatement == null ? (class$com$ibm$ejs$cm$cache$CachedStatement = CachedStatement.class$("com.ibm.ejs.cm.cache.CachedStatement")) : class$com$ibm$ejs$cm$cache$CachedStatement));
    static /* synthetic */ Class class$com$ibm$ejs$cm$cache$CachedStatement;

    public void setURL(int n, URL uRL) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public ParameterMetaData getParameterMetaData() throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public boolean execute(String string, int n) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public boolean execute(String string, int[] nArray) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public int executeUpdate(String string, int n) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public int executeUpdate(String string, int[] nArray) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public boolean execute(String string, String[] stringArray) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public int executeUpdate(String string, String[] stringArray) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public boolean getMoreResults(int n) throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("This method is not supported.");
    }

    CachedStatement(StatementCache statementCache, String string, PreparedStatement preparedStatement) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{statementCache, preparedStatement});
        }
        this.cache = statementCache;
        this.statement = preparedStatement;
        this.key = string;
        this.currentBitSet = new BitSet();
        this.priorBitSet = null;
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void close() throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"close");
        }
        if (this.cache != null) {
            this.cache.releaseStatement(this);
        }
        if (this.currentBitSet != null) {
            if (this.bitSetError) {
                this.currentBitSet = new BitSet();
            } else {
                for (int i = this.currentBitSet.length() - 1; i > -1; --i) {
                    this.currentBitSet.clear(i);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        try {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Exception closing statement", (Object)sQLException);
                }
                Object var3_2 = null;
                this.statement = null;
                this.cache = null;
                this.currentBitSet = null;
                this.priorBitSet = null;
            }
            Object var3_1 = null;
            this.statement = null;
            this.cache = null;
            this.currentBitSet = null;
            this.priorBitSet = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.statement = null;
            this.cache = null;
            this.currentBitSet = null;
            this.priorBitSet = null;
            throw throwable;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public String getStatementString() {
        return (String)this.key;
    }

    public final void setFetchDirection(int n) throws SQLException {
        this.statement.setFetchDirection(n);
    }

    public final int getFetchDirection() throws SQLException {
        return this.statement.getFetchDirection();
    }

    public final void setFetchSize(int n) throws SQLException {
        this.statement.setFetchSize(n);
    }

    public final int getFetchSize() throws SQLException {
        return this.statement.getFetchSize();
    }

    public final int getResultSetType() throws SQLException {
        return this.statement.getResultSetType();
    }

    public final int getResultSetConcurrency() throws SQLException {
        return this.statement.getResultSetConcurrency();
    }

    public final void addBatch(String string) throws SQLException {
        this.statement.addBatch(string);
    }

    public final void clearBatch() throws SQLException {
        this.statement.clearBatch();
    }

    public final int[] executeBatch() throws SQLException {
        return this.statement.executeBatch();
    }

    public final Connection getConnection() throws SQLException {
        return this.statement.getConnection();
    }

    public void cancel() throws SQLException {
        this.statement.cancel();
    }

    public void clearWarnings() throws SQLException {
        this.statement.clearWarnings();
    }

    public boolean execute(String string) throws SQLException {
        return this.statement.execute(string);
    }

    public ResultSet executeQuery(String string) throws SQLException {
        return this.statement.executeQuery(string);
    }

    public int executeUpdate(String string) throws SQLException {
        return this.statement.executeUpdate(string);
    }

    public int getMaxFieldSize() throws SQLException {
        return this.statement.getMaxFieldSize();
    }

    public int getMaxRows() throws SQLException {
        return this.statement.getMaxRows();
    }

    public boolean getMoreResults() throws SQLException {
        return this.statement.getMoreResults();
    }

    public int getQueryTimeout() throws SQLException {
        return this.statement.getQueryTimeout();
    }

    public ResultSet getResultSet() throws SQLException {
        return this.statement.getResultSet();
    }

    public int getUpdateCount() throws SQLException {
        return this.statement.getUpdateCount();
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.statement.getWarnings();
    }

    public void setCursorName(String string) throws SQLException {
        this.statement.setCursorName(string);
    }

    public void setEscapeProcessing(boolean bl) throws SQLException {
        this.statement.setEscapeProcessing(bl);
    }

    public void setMaxFieldSize(int n) throws SQLException {
        this.statement.setMaxFieldSize(n);
    }

    public void setMaxRows(int n) throws SQLException {
        this.statement.setMaxRows(n);
    }

    public void setQueryTimeout(int n) throws SQLException {
        this.statement.setQueryTimeout(n);
    }

    public void addBatch() throws SQLException {
        this.statement.addBatch();
    }

    public void setCharacterStream(int n, Reader reader, int n2) throws SQLException {
        this.statement.setCharacterStream(n, reader, n2);
        this.currentBitSet.set(n);
    }

    public void setRef(int n, Ref ref) throws SQLException {
        this.statement.setRef(n, ref);
        this.currentBitSet.set(n);
    }

    public void setBlob(int n, Blob blob) throws SQLException {
        this.statement.setBlob(n, blob);
        this.currentBitSet.set(n);
    }

    public void setClob(int n, Clob clob) throws SQLException {
        this.statement.setClob(n, clob);
        this.currentBitSet.set(n);
    }

    public void setArray(int n, Array array) throws SQLException {
        this.statement.setArray(n, array);
        this.currentBitSet.set(n);
    }

    public ResultSetMetaData getMetaData() throws SQLException {
        return this.statement.getMetaData();
    }

    public void setDate(int n, Date date, Calendar calendar) throws SQLException {
        this.statement.setDate(n, date, calendar);
        this.currentBitSet.set(n);
    }

    public void setTime(int n, Time time, Calendar calendar) throws SQLException {
        this.statement.setTime(n, time, calendar);
        this.currentBitSet.set(n);
    }

    public void setTimestamp(int n, Timestamp timestamp, Calendar calendar) throws SQLException {
        this.statement.setTimestamp(n, timestamp, calendar);
        this.currentBitSet.set(n);
    }

    public void setNull(int n, int n2, String string) throws SQLException {
        this.statement.setNull(n, n2, string);
        this.currentBitSet.set(n);
    }

    public ResultSet executeQuery() throws SQLException {
        if (this.priorBitSet == null) {
            ResultSet resultSet = null;
            try {
                resultSet = this.statement.executeQuery();
                this.bitSetError = false;
            }
            catch (SQLException sQLException) {
                this.bitSetError = true;
                throw sQLException;
            }
            this.priorBitSet = (BitSet)this.currentBitSet.clone();
            return resultSet;
        }
        if (!this.currentBitSet.equals(this.priorBitSet)) {
            throw new SQLException("Insufficient number of parameter were set before execution " + this.currentBitSet.toString() + " of " + this.priorBitSet.toString());
        }
        return this.statement.executeQuery();
    }

    public int executeUpdate() throws SQLException {
        if (this.priorBitSet == null) {
            int n = 0;
            try {
                n = this.statement.executeUpdate();
                this.bitSetError = false;
            }
            catch (SQLException sQLException) {
                this.bitSetError = true;
                throw sQLException;
            }
            this.priorBitSet = (BitSet)this.currentBitSet.clone();
            return n;
        }
        if (!this.currentBitSet.equals(this.priorBitSet)) {
            throw new SQLException("Insufficient number of parameter were set before execution " + this.currentBitSet.toString() + " of " + this.priorBitSet.toString());
        }
        return this.statement.executeUpdate();
    }

    public void setNull(int n, int n2) throws SQLException {
        this.statement.setNull(n, n2);
        this.currentBitSet.set(n);
    }

    public void setBoolean(int n, boolean bl) throws SQLException {
        this.statement.setBoolean(n, bl);
        this.currentBitSet.set(n);
    }

    public void setByte(int n, byte by) throws SQLException {
        this.statement.setByte(n, by);
        this.currentBitSet.set(n);
    }

    public void setShort(int n, short s) throws SQLException {
        this.statement.setShort(n, s);
        this.currentBitSet.set(n);
    }

    public void setInt(int n, int n2) throws SQLException {
        this.statement.setInt(n, n2);
        this.currentBitSet.set(n);
    }

    public void setLong(int n, long l) throws SQLException {
        this.statement.setLong(n, l);
        this.currentBitSet.set(n);
    }

    public void setFloat(int n, float f) throws SQLException {
        this.statement.setFloat(n, f);
        this.currentBitSet.set(n);
    }

    public void setDouble(int n, double d) throws SQLException {
        this.statement.setDouble(n, d);
        this.currentBitSet.set(n);
    }

    public void setBigDecimal(int n, BigDecimal bigDecimal) throws SQLException {
        this.statement.setBigDecimal(n, bigDecimal);
        this.currentBitSet.set(n);
    }

    public void setString(int n, String string) throws SQLException {
        this.statement.setString(n, string);
        this.currentBitSet.set(n);
    }

    public void setBytes(int n, byte[] byArray) throws SQLException {
        this.statement.setBytes(n, byArray);
        this.currentBitSet.set(n);
    }

    public void setDate(int n, Date date) throws SQLException {
        this.statement.setDate(n, date);
        this.currentBitSet.set(n);
    }

    public void setTime(int n, Time time) throws SQLException {
        this.statement.setTime(n, time);
        this.currentBitSet.set(n);
    }

    public void setTimestamp(int n, Timestamp timestamp) throws SQLException {
        this.statement.setTimestamp(n, timestamp);
        this.currentBitSet.set(n);
    }

    public void setAsciiStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.statement.setAsciiStream(n, inputStream, n2);
        this.currentBitSet.set(n);
    }

    public void setUnicodeStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.statement.setUnicodeStream(n, inputStream, n2);
        this.currentBitSet.set(n);
    }

    public void setBinaryStream(int n, InputStream inputStream, int n2) throws SQLException {
        this.statement.setBinaryStream(n, inputStream, n2);
        this.currentBitSet.set(n);
    }

    public void clearParameters() throws SQLException {
        if (this.priorBitSet == null) {
            this.statement.clearParameters();
            if (this.bitSetError) {
                this.currentBitSet = new BitSet();
            }
        }
        for (int i = this.currentBitSet.length() - 1; i > -1; --i) {
            this.currentBitSet.clear(i);
        }
    }

    public void setObject(int n, Object object, int n2, int n3) throws SQLException {
        this.statement.setObject(n, object, n2, n3);
        this.currentBitSet.set(n);
    }

    public void setObject(int n, Object object, int n2) throws SQLException {
        this.statement.setObject(n, object, n2);
        this.currentBitSet.set(n);
    }

    public void setObject(int n, Object object) throws SQLException {
        this.statement.setObject(n, object);
        this.currentBitSet.set(n);
    }

    public boolean execute() throws SQLException {
        if (this.priorBitSet == null) {
            boolean bl = false;
            try {
                bl = this.statement.execute();
                this.bitSetError = false;
            }
            catch (SQLException sQLException) {
                this.bitSetError = true;
                throw sQLException;
            }
            this.priorBitSet = (BitSet)this.currentBitSet.clone();
            return bl;
        }
        if (!this.currentBitSet.equals(this.priorBitSet)) {
            throw new SQLException("Insufficient number of parameter were set before execution " + this.currentBitSet.toString() + " of " + this.priorBitSet.toString());
        }
        return this.statement.execute();
    }

    public PreparedStatement getPreparedStatement() {
        return this.statement;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

