/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.cache;

import com.ibm.ejs.cm.cache.CachedStatement;
import com.ibm.ejs.cm.exception.ConnectionPoolInternalErrorException;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.CastoutPolicy;
import com.ibm.ejs.util.LRUCache;
import com.ibm.ejs.util.LRUCacheElement;
import com.ibm.websphere.pmi.ConnPoolPerf;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;

public final class StatementCache {
    private static final int RESOURCE_ALLOCATION_RETRY_LIMIT = 4;
    private final LRUCache freeStatements;
    private final ArrayList busyStatements;
    private final ConnPoolPerf connPoolData;
    private final ConnectO connectO;
    private final Connection conn;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$cache$StatementCache == null ? (class$com$ibm$ejs$cm$cache$StatementCache = StatementCache.class$("com.ibm.ejs.cm.cache.StatementCache")) : class$com$ibm$ejs$cm$cache$StatementCache));
    static /* synthetic */ Class class$com$ibm$ejs$cm$cache$StatementCache;

    public StatementCache(Connection connection, ConnPoolPerf connPoolPerf, ConnectO connectO, int n) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{connection});
        }
        this.connectO = connectO;
        this.connPoolData = connPoolPerf;
        this.conn = connection;
        CastoutPolicy castoutPolicy = new CastoutPolicy(){

            public void castout(LRUCacheElement lRUCacheElement) {
                CachedStatement cachedStatement = (CachedStatement)lRUCacheElement;
                cachedStatement.destroy();
                if (StatementCache.this.connPoolData != null) {
                    StatementCache.this.connPoolData.preparedStmtCacheDiscard();
                }
            }
        };
        this.freeStatements = new LRUCache(n, castoutPolicy);
        this.busyStatements = new ArrayList(n);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CachedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"prepareStatement", (Object)string);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"sql, type, and concurrency", (Object)new Object[]{string, new Integer(n), new Integer(n2)});
        }
        StringBuffer stringBuffer = new StringBuffer(string.length() + 25);
        stringBuffer.append(string).append(n).append(n2);
        String string2 = stringBuffer.toString();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Key for Hashtable ", (Object)string2);
        }
        CachedStatement cachedStatement = null;
        StatementCache statementCache = this;
        synchronized (statementCache) {
            cachedStatement = (CachedStatement)this.freeStatements.remove((Object)string2);
        }
        if (cachedStatement == null) {
            cachedStatement = this.reallyPrepareStatement(string2, string, n, n2);
        } else {
            statementCache = this;
            synchronized (statementCache) {
                this.busyStatements.add(cachedStatement);
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"prepareStatement", (Object)cachedStatement);
        }
        return cachedStatement;
    }

    public void releaseStatements() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseStatements");
        }
        if (this.busyStatements != null) {
            Iterator iterator = this.busyStatements.iterator();
            while (iterator.hasNext()) {
                CachedStatement cachedStatement = (CachedStatement)iterator.next();
                this.freeStatements.put((Object)cachedStatement.getStatementString(), (LRUCacheElement)cachedStatement);
            }
            this.busyStatements.clear();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseStatements");
        }
    }

    synchronized void releaseStatement(CachedStatement cachedStatement) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"releaseStatement", (Object)cachedStatement);
        }
        if (!(bl = this.busyStatements.remove(cachedStatement))) {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"releaseStatement: Unknown statement");
            }
            throw new ConnectionPoolInternalErrorException(cachedStatement + " doesn't belong to this cache");
        }
        cachedStatement.clearParameters();
        PortabilityLayer portabilityLayer = (PortabilityLayer)this.connectO.getPortabilityLayer();
        portabilityLayer.resetStatement(cachedStatement);
        this.freeStatements.put((Object)cachedStatement.getStatementString(), (LRUCacheElement)cachedStatement);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"releaseStatement");
        }
    }

    public void destroy() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        Object object = this.freeStatements.elements();
        while (object.hasMoreElements()) {
            ((CachedStatement)object.nextElement()).destroy();
        }
        object = this.busyStatements.iterator();
        while (object.hasNext()) {
            ((CachedStatement)object.next()).destroy();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CachedStatement reallyPrepareStatement(String string, String string2, int n, int n2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reallyPrepareStatement", (Object)new Object[]{string, string2});
        }
        int n3 = 0;
        while (true) {
            try {
                CachedStatement cachedStatement = n == 1003 && n2 == 1007 ? new CachedStatement(this, string, this.conn.prepareStatement(string2)) : new CachedStatement(this, string, this.conn.prepareStatement(string2, n, n2));
                StatementCache statementCache = this;
                synchronized (statementCache) {
                    this.busyStatements.add(cachedStatement);
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reallyPrepareStatement", (Object)cachedStatement);
                }
                return cachedStatement;
            }
            catch (ResourceAllocationException resourceAllocationException) {
                if (++n3 <= 4) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"reallyPrepareStatement: hit retry limit", (Object)resourceAllocationException.getNativeException());
                }
                throw resourceAllocationException.getNativeException();
            }
            catch (SQLException sQLException) {
                if (this.connectO != null) {
                    throw this.connectO.translateException(sQLException);
                }
                throw sQLException;
            }
            break;
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

