/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.pool;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.DSFactoryImpl;
import com.ibm.ejs.cm.DataSourceImpl;
import com.ibm.ejs.cm.cache.StatementCache;
import com.ibm.ejs.cm.pool.ConnectO;
import com.ibm.ejs.cm.pool.ConnectOEventListener;
import com.ibm.ejs.cm.pool.ConnectionFactory;
import com.ibm.ejs.cm.pool.ConnectionPoolDestroyedException;
import com.ibm.ejs.cm.pool.ConnectionWaitTimeoutException;
import com.ibm.ejs.cm.pool.DiagnosticModuleForCMPool;
import com.ibm.ejs.cm.pool.Waiter;
import com.ibm.ejs.cm.pool.syncInt;
import com.ibm.ejs.cm.portability.ConnectionProxyFactory;
import com.ibm.ejs.cm.portability.ErrorMap;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerExt;
import com.ibm.ejs.cm.portability.PortabilityLayerFactory;
import com.ibm.ejs.cm.portability.PortableDataSource;
import com.ibm.ejs.cm.portability.ResourceAllocationException;
import com.ibm.ejs.cm.proxy.ConnectionProxy;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.util.FastHashtable;
import com.ibm.ejs.util.Queue;
import com.ibm.ejs.util.QueueElement;
import com.ibm.ejs.util.am.Alarm;
import com.ibm.ejs.util.am.AlarmListener;
import com.ibm.ejs.util.am.AlarmManager;
import com.ibm.websphere.ce.cm.StaleConnectionException;
import com.ibm.websphere.management.AdminService;
import com.ibm.websphere.management.AdminServiceFactory;
import com.ibm.websphere.pmi.ConnPoolPerf;
import com.ibm.ws.Transaction.TransactionManagerFactory;
import com.ibm.ws.Transaction.UOWCoordinator;
import com.ibm.ws.Transaction.UOWCurrent;
import com.ibm.ws.Transaction.XAResourceInfo;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.pmi.server.PmiFactory;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Set;
import java.util.Vector;
import javax.management.ObjectName;

public final class ConnectionPool
implements PortableDataSource,
ConnectOEventListener,
AlarmListener {
    static final String NULL_USERNAME = "_null_username";
    static final String NULL_PASSWORD = "_null_password";
    private static final int CREATE_RETRY_LIMIT = 4;
    private final ConnectionFactory factory;
    private final CMPropertiesImpl attrs;
    private final String dsPassword;
    private final FastHashtable connectionsByTx = new FastHashtable(255);
    private final FastHashtable connectionsByUser = new FastHashtable(11);
    private final int statementCacheSize;
    private ErrorMap errorMap = null;
    private final Vector connections;
    private Queue waiters = new Queue();
    private Queue freeList = new Queue();
    private PortabilityLayer portability;
    private int connectionCount = 0;
    private final syncInt connectionsInUse = new syncInt();
    private boolean destroyed = false;
    protected String xaResourceFactoryName;
    protected XAResourceInfo xaResourceInfo;
    private Alarm orphanAlarm;
    private static final Object ORPHAN_ALARM;
    private Alarm agedAlarm;
    private static final Object AGED_ALARM;
    private static final TraceComponent tc;
    protected ConnPoolPerf pmiData = null;
    static /* synthetic */ Class class$com$ibm$ejs$cm$pool$ConnectionPool;

    public ConnectionPool(ConnectionFactory connectionFactory, CMProperties cMProperties, String string) throws SQLException {
        this(connectionFactory, cMProperties, null, null, string);
    }

    public ConnectionPool(ConnectionFactory connectionFactory, CMProperties cMProperties, String string, XAResourceInfo xAResourceInfo, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)new Object[]{connectionFactory, cMProperties});
        }
        this.factory = connectionFactory;
        this.attrs = (CMPropertiesImpl)cMProperties;
        this.xaResourceFactoryName = string;
        this.xaResourceInfo = xAResourceInfo;
        this.connections = new Vector(this.attrs.getMaxConnectionPoolSize());
        this.dsPassword = string2;
        this.statementCacheSize = this.attrs.getMaxStatementCacheSize();
        this.createPmiData(this.attrs);
        this.setupOrphanAlarm();
        this.setupAgedAlarm();
        this.portability = PortabilityLayerFactory.getPortabilityLayer(this.attrs.getDataSourceProperties());
        if (this.attrs.getDiagOptions() != 0) {
            Tr.audit((TraceComponent)tc, (String)"MSG_CONM_6025I", (Object)new Object[]{this.attrs.getName(), this.attrs.getDiagOptionsString()});
        }
        if (this.attrs.getOraTransLoose()) {
            Tr.warning((TraceComponent)tc, (String)"MSG_CONM_6021W");
        }
        this.errorMap = ErrorMap.createErrorMap(this.portability, this.attrs.getErrorMap());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public void freeConnection(ConnectO connectO) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"freeConnection", (Object)connectO);
        }
        connectO.decRef();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"freeConnection");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Enumeration enumeration;
        Vector vector;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroy");
        }
        Object object = this;
        synchronized (object) {
            vector = (Vector)this.connections.clone();
            enumeration = this.waiters.elements();
            this.destroyed = true;
            this.notifyAll();
        }
        while (enumeration.hasMoreElements()) {
            object = (Waiter)((Object)enumeration.nextElement());
            ((Waiter)((Object)object)).setWokeUpOnNotify(true);
            object.notify();
        }
        for (int i = 0; i < vector.size(); ++i) {
            this.destroyConnection((ConnectO)vector.elementAt(i));
        }
        if (this.orphanAlarm != null) {
            this.orphanAlarm.cancel();
        }
        Tr.audit((TraceComponent)tc, (String)"MSG_CONM_6007I", (Object)this.attrs.getName());
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public synchronized void destroyAllFreeConnections() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"destroyAllFreeConnections of ");
        }
        Enumeration enumeration = this.connectionsByUser.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            Queue queue = (Queue)this.connectionsByUser.get((Object)string);
            if (queue == null) continue;
            ConnectO connectO = (ConnectO)queue.removeHead();
            while (connectO != null) {
                this.connections.removeElement(connectO);
                try {
                    this.destroyConnection(connectO);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                connectO = (ConnectO)queue.removeHead();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Setting all in-use connections stale");
        }
        for (int i = 0; i < this.connections.size(); ++i) {
            ((ConnectO)this.connections.elementAt((int)i)).maybeStale = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroyAllFreeConnections");
        }
    }

    public PortabilityLayerExt getPortabilityLayer() {
        return this.portability;
    }

    public CMProperties getAttributes() {
        return this.attrs;
    }

    public Connection getConnection() throws SQLException {
        return this.getConnection(null, null);
    }

    public Connection getConnection(String string, String string2) throws SQLException {
        ConnectO connectO = this.allocateConnection(string, string2);
        ConnectionProxy connectionProxy = ((ConnectionProxyFactory)((Object)this.portability)).createConnectionProxy(connectO);
        connectO.addEventListener(connectionProxy);
        return connectionProxy;
    }

    public int getLoginTimeout() throws SQLException {
        return this.attrs.getConnectionTimeout();
    }

    public synchronized void setLoginTimeout(int n) throws SQLException {
        this.factory.setLoginTimeout(n);
        this.attrs.setConnectionTimeout(n);
    }

    public PrintWriter getLogWriter() throws SQLException {
        return this.factory.getLogWriter();
    }

    public void setLogWriter(PrintWriter printWriter) throws SQLException {
        this.factory.setLogWriter(printWriter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionEnlisted(ConnectO connectO, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionEnlisted", (Object)new Object[]{connectO, object});
        }
        Object object2 = this.connectionsByTx.getLock(object);
        synchronized (object2) {
            Vector<ConnectO> vector = (Vector<ConnectO>)this.connectionsByTx.get(object);
            if (vector == null) {
                vector = new Vector<ConnectO>();
                this.connectionsByTx.put(object, vector);
            }
            vector.addElement(connectO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionEnlisted");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionDestroyed(ConnectO connectO) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionDestroyed", (Object)connectO);
        }
        Object object = this.connectionsByUser.getLock((Object)connectO.getUsername());
        synchronized (object) {
            try {
                connectO.removeFromQueue();
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        this.connections.removeElement(connectO);
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"Shrinking pool", (Object)new Integer(this.connectionCount));
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionDestroyed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectionIdleTimeout(ConnectO connectO) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionIdleTimeout", (Object)connectO);
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.connectionCount <= this.attrs.getMinConnectionPoolSize()) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"connectionIdleTimeout: At minimum size");
                }
                return false;
            }
            Object object = this.connectionsByUser.getLock((Object)connectO.getUsername());
            synchronized (object) {
                try {
                    connectO.removeFromQueue();
                }
                catch (RuntimeException runtimeException) {
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"connectionIdleTimeout: Not on free queue", (Object)connectO);
                    }
                    return true;
                }
            }
            this.commonDestroyForIdleAndAged(connectO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionIdleTimeout");
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean connectionAgedTimeout(ConnectO connectO) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionAgedTimeout", (Object)connectO);
        }
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            Object object = this.connectionsByUser.getLock((Object)connectO.getUsername());
            synchronized (object) {
                try {
                    connectO.removeFromQueue();
                }
                catch (RuntimeException runtimeException) {
                    connectO.aged = -1;
                    if (tc.isEntryEnabled()) {
                        Tr.exit((TraceComponent)tc, (String)"connectionAgedTimeout: Not on free queue", (Object)connectO);
                    }
                    return true;
                }
            }
            this.commonDestroyForIdleAndAged(connectO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionAgedTimeout");
        }
        return true;
    }

    public void commonDestroyForIdleAndAged(ConnectO connectO) {
        this.destroyConnection(connectO);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionIdleTimeout");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connectionTxComplete(ConnectO connectO, int n, Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"connectionTxComplete", (Object)new Object[]{connectO, new Integer(n), object});
        }
        Object object2 = this.connectionsByTx.getLock(object);
        synchronized (object2) {
            this.connectionsByTx.remove(object);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectionTxComplete");
        }
    }

    public void connectionOrphaned(ConnectO connectO) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"connectionOrphaned", (Object)connectO);
        }
    }

    public void setDestroyed(ConnectO connectO) {
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)"setDestroyed", (Object)connectO);
        }
    }

    String getXAResourceFactoryName() {
        return this.xaResourceFactoryName;
    }

    XAResourceInfo getXAResourceInfo() {
        return this.xaResourceInfo;
    }

    StatementCache createStatementCache(Connection connection, ConnectO connectO) {
        if (this.statementCacheSize == 0) {
            return null;
        }
        return new StatementCache(connection, this.pmiData, connectO, this.statementCacheSize);
    }

    int getIdleTimeoutInMillis() {
        return this.attrs.getIdleTimeoutInMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void returnConnection(ConnectO connectO) {
        int n;
        block42: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"returnConnection", (Object)connectO);
            }
            connectO.unsetTracer();
            if (connectO.aged == -1) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Aged. Do not return to free pool");
                }
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    this.connections.removeElement(connectO);
                    this.destroyConnection(connectO);
                    syncInt syncInt2 = this.connectionsInUse;
                    synchronized (syncInt2) {
                        this.connectionsInUse.decInt();
                        if (this.pmiData != null) {
                            this.pmiData.connectionFreed(this.attrs.getMaxConnectionPoolSize(), this.connectionsInUse.getInt());
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"returnConnection");
                }
                return;
            }
            if (connectO.maybeStale) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Maybe Stale. Do not return to free pool");
                }
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    this.connections.removeElement(connectO);
                    this.destroyConnection(connectO);
                    syncInt syncInt3 = this.connectionsInUse;
                    synchronized (syncInt3) {
                        this.connectionsInUse.decInt();
                        if (this.pmiData != null) {
                            this.pmiData.connectionFreed(this.attrs.getMaxConnectionPoolSize(), this.connectionsInUse.getInt());
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"returnConnection");
                }
                return;
            }
            if (this.attrs.isResetReadOnlyEnabled() && connectO.isReadOnlyChanged()) {
                try {
                    connectO.setReadOnly(false);
                }
                catch (SQLException sQLException) {
                    if (!tc.isEventEnabled()) break block42;
                    Tr.event((TraceComponent)tc, (String)"SQLException while resetting read only value");
                }
            }
        }
        Object object = this.connectionsByUser.getLock((Object)connectO.getUsername());
        synchronized (object) {
            Queue queue = (Queue)this.connectionsByUser.get((Object)connectO.getUsername());
            if (queue == null) {
                queue = new Queue();
                this.connectionsByUser.put((Object)connectO.getUsername(), (Object)queue);
            }
            queue.addToTail((QueueElement)connectO);
        }
        object = null;
        Object object2 = this.waiters;
        synchronized (object2) {
            n = this.waiters.size();
            if (n > 0) {
                object = (Waiter)this.waiters.removeHead();
            }
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("number of waiters: " + n));
        }
        if (object != null) {
            object2 = object;
            synchronized (object2) {
                ((Waiter)((Object)object)).setWokeUpOnNotify(true);
                object.notify();
            }
        }
        object2 = this.connectionsInUse;
        synchronized (object2) {
            this.connectionsInUse.decInt();
            if (this.pmiData != null) {
                this.pmiData.connectionFreed(this.attrs.getMaxConnectionPoolSize(), this.connectionsInUse.getInt());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"returnConnection");
        }
    }

    private ConnectO allocateConnection(String string, String string2) throws SQLException {
        boolean bl;
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"allocateConnection", (Object)string);
        }
        String string3 = null;
        boolean bl2 = string == null || string.equals("");
        boolean bl3 = bl = string2 == null || string2.equals("");
        if (bl2) {
            if (!bl) {
                throw new IllegalArgumentException("Non-null password with null user - Please check configuration panels for datasource, ejb module, and ejb, as well as application code.");
            }
            string3 = this.attrs.getUser();
            if (string3 == null) {
                string3 = NULL_USERNAME;
            }
        } else {
            if (bl) {
                throw new IllegalArgumentException("null password with user:'" + string + "' - Please check configuration panels for datasource, ejb module, and ejb, as well as application code.");
            }
            string3 = string;
        }
        String string4 = null;
        string4 = bl ? (this.dsPassword == null ? NULL_PASSWORD : this.dsPassword) : string2;
        UOWCurrent uOWCurrent = TransactionManagerFactory.getUOWCurrent();
        UOWCoordinator uOWCoordinator = uOWCurrent.getUOWCoord();
        ConnectO connectO = this.findConnectionForTx(uOWCoordinator, string3, string4);
        connectO.incRef();
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocateConnection", (Object)connectO);
        }
        return connectO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectO findConnectionForTx(UOWCoordinator uOWCoordinator, String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findConnectionForTx", (Object)new Object[]{uOWCoordinator, string});
        }
        ConnectO connectO = null;
        if (uOWCoordinator != null) {
            Object object = this.connectionsByTx.getLock((Object)uOWCoordinator);
            synchronized (object) {
                Vector vector = (Vector)this.connectionsByTx.get((Object)uOWCoordinator);
                if (vector != null) {
                    for (int i = 0; i < vector.size(); ++i) {
                        ConnectO connectO2 = (ConnectO)vector.elementAt(i);
                        if (!connectO2.getUsername().equals(string)) continue;
                        connectO = connectO2;
                        if (!connectO.getPassword().equals(NULL_PASSWORD) && !connectO.getPassword().equals(string2)) {
                            Tr.warning((TraceComponent)tc, (String)"Connection requested with same user id but different password than existing enlisted connection.  A new connection will be created and enlisted.");
                            connectO = null;
                        }
                        break;
                    }
                } else if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"No connection list for transaction");
                }
            }
        }
        if (connectO == null) {
            boolean bl;
            connectO = this.findFreeConnection(string, string2);
            if (this.attrs.isValidateEnabled() && !(bl = connectO.validate())) {
                this.destroyConnection(connectO);
                this.destroyAllFreeConnections();
                connectO = this.findFreeConnection(string, string2);
            }
            if (!connectO.getPassword().equals(NULL_PASSWORD) && !connectO.getPassword().equals(string2)) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Connection retrieved from pool with same userid but different password.  Connection will be closed and new connection created.");
                }
                this.destroyConnection(connectO);
                connectO = this.createOrWaitForConnection(string, string2);
            }
            this.allocateConnForTransaction(connectO, uOWCoordinator);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findConnectionForTx", (Object)connectO);
        }
        return connectO;
    }

    Vector getConnectionsForTransaction(UOWCoordinator uOWCoordinator) {
        Vector vector = new Vector();
        Enumeration enumeration = DSFactoryImpl.getDataSources();
        DataSourceImpl dataSourceImpl = null;
        ConnectionPool connectionPool = null;
        while (enumeration.hasMoreElements()) {
            try {
                dataSourceImpl = (DataSourceImpl)enumeration.nextElement();
                connectionPool = dataSourceImpl.getSource();
                if (connectionPool.connectionsByTx.get((Object)uOWCoordinator) == null) continue;
                vector.addAll((Vector)connectionPool.connectionsByTx.get((Object)uOWCoordinator));
            }
            catch (SQLException sQLException) {
                Tr.debug((TraceComponent)tc, (String)"Failed to get connections by tran from DataSource {0}", (Object)dataSourceImpl);
            }
        }
        return vector;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void allocateConnForTransaction(ConnectO connectO, UOWCoordinator uOWCoordinator) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"allocateConnForTransaction");
        }
        try {
            connectO.allocate(uOWCoordinator);
        }
        catch (StaleConnectionException staleConnectionException) {
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                if (connectO.maybeStale) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Connection marked stale");
                    }
                } else {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Stale connection. Free pool");
                    }
                    this.destroyAllFreeConnections();
                }
            }
            throw staleConnectionException;
        }
        syncInt syncInt2 = this.connectionsInUse;
        synchronized (syncInt2) {
            this.connectionsInUse.incInt();
            if (this.pmiData != null) {
                this.pmiData.connectionAllocated(this.attrs.getMaxConnectionPoolSize(), this.connectionsInUse.getInt());
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"allocateConnForTransaction");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectO findFreeConnection(String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"findFreeConnection", (Object)string);
        }
        ConnectO connectO = null;
        int n = 0;
        Object object = this.waiters;
        synchronized (object) {
            n = this.waiters.size();
        }
        if (n == 0) {
            object = this.connectionsByUser.getLock((Object)string);
            synchronized (object) {
                Queue queue = (Queue)this.connectionsByUser.get((Object)string);
                if (queue != null && queue.size() > 0) {
                    connectO = (ConnectO)queue.removeTail();
                    connectO.orphaned = false;
                }
            }
        }
        if (connectO == null) {
            connectO = this.createOrWaitForConnection(string, string2);
        }
        if (this.attrs.isDiagOptionEnabled(2 | 4)) {
            connectO.setTracer();
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"findFreeConnection", (Object)connectO);
        }
        return connectO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectO createOrWaitForConnection(String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createOrWaitForConnection", (Object)string);
        }
        ConnectO connectO = null;
        int n = 0;
        while (true) {
            if (this.destroyed) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createOrWaitForConnection: Pool destroyed");
                }
                throw new ConnectionPoolDestroyedException();
            }
            if (this.connectionCount < this.attrs.getMaxConnectionPoolSize()) {
                boolean bl = false;
                int n2 = -1;
                ConnectionPool connectionPool = this;
                synchronized (connectionPool) {
                    if (this.connectionCount < this.attrs.getMaxConnectionPoolSize()) {
                        bl = true;
                        n2 = this.connectionCount++;
                    }
                }
                if (bl) {
                    Object object;
                    if (tc.isEventEnabled()) {
                        Tr.event((TraceComponent)tc, (String)"Expanding pool", (Object)new Object[]{new Integer(this.connectionCount), new Integer(this.attrs.getMaxConnectionPoolSize())});
                    }
                    try {
                        connectO = this.createConnection(string, string2);
                        if (this.pmiData != null) {
                            this.pmiData.connectionCreated(n2 + 1);
                        }
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"createOrWaitForConnection", (Object)connectO);
                        }
                        return connectO;
                    }
                    catch (ResourceAllocationException resourceAllocationException) {
                        object = this;
                        synchronized (object) {
                            --this.connectionCount;
                        }
                        if (this.connectionCount == 0 || ++n > 4) {
                            if (tc.isEntryEnabled()) {
                                Tr.exit((TraceComponent)tc, (String)"createOrWaitForConnection: Resource Allocation Exception", (Object)((Object)resourceAllocationException));
                            }
                            throw resourceAllocationException.getNativeException();
                        }
                        Tr.warning((TraceComponent)tc, (String)"MSG_CONM_6001W");
                    }
                    catch (SQLException sQLException) {
                        object = this;
                        synchronized (object) {
                            --this.connectionCount;
                        }
                        object = this.portability.translateException(sQLException);
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"createOrWaitForConnection: Exception", (Object)object);
                        }
                        throw object;
                    }
                    catch (Exception exception) {
                        object = this;
                        synchronized (object) {
                            --this.connectionCount;
                        }
                        Tr.warning((TraceComponent)tc, (String)"MSG_CONM_6024W", (Object)exception);
                        object = new StaleConnectionException("Exception caught while processing createConnection.: " + exception.getMessage());
                    }
                }
            }
            if ((connectO = this.waitForVictimConnection()).getUsername().equals(string) && connectO.getPassword().equals(string2)) {
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createOrWaitForConnection", (Object)connectO);
                }
                return connectO;
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Available connection has wrong username or password");
            }
            this.destroyConnection(connectO);
            connectO = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectO createConnection(String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createConnection", (Object)string);
        }
        ConnectO connectO = null;
        int n = 1;
        while (true) {
            try {
                if (string == NULL_USERNAME && string2 == NULL_PASSWORD) {
                    connectO = this.factory.createConnection(this);
                    break;
                }
                connectO = this.factory.createConnection(this, string, string2);
            }
            catch (SQLException sQLException) {
                Tr.error((TraceComponent)tc, (String)"MSG_CONM_6009E", (Object)this.attrs.getName());
                if (--n != 0) continue;
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createConnection", (Object)sQLException);
                }
                throw this.portability.translateException(sQLException);
            }
            break;
        }
        connectO.addEventListener(this);
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            if (this.destroyed) {
                this.destroyConnection(connectO);
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"createConnection: Pool destroyed");
                }
                throw new ConnectionPoolDestroyedException();
            }
            this.connections.addElement(connectO);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createConnection", (Object)connectO);
        }
        return connectO;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroyConnection(ConnectO connectO) {
        Object object;
        connectO.alreadyDestroyed = true;
        if (connectO.state == 1 | connectO.state == 2 | connectO.state == 3 | connectO.state == 4) {
            object = this.connectionsInUse;
            synchronized (object) {
                this.connectionsInUse.decInt();
                if (this.pmiData != null) {
                    this.pmiData.connectionFreed(this.attrs.getMaxConnectionPoolSize(), this.connectionsInUse.getInt());
                }
            }
        }
        connectO.destroy();
        object = this;
        synchronized (object) {
            --this.connectionCount;
            if (this.pmiData != null) {
                this.pmiData.connectionDestroyed(this.connectionCount);
            }
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Shrinking pool", (Object)new Integer(this.connectionCount));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConnectO waitForVictimConnection() throws SQLException {
        long l;
        ConnectO connectO;
        block61: {
            Object object;
            boolean bl;
            long l2;
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"waitForVictimConnection");
            }
            connectO = null;
            l = l2 = (long)this.attrs.getConnectionTimeoutInMillis();
            boolean bl2 = bl = l2 != 0L;
            if (this.pmiData != null) {
                this.pmiData.beginWaitForConnection();
            }
            Waiter waiter = null;
            do {
                Queue queue;
                Enumeration enumeration = this.connectionsByUser.keys();
                while (connectO == null && enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    Object object2 = this.connectionsByUser.getLock(object);
                    synchronized (object2) {
                        queue = (Queue)this.connectionsByUser.get(object);
                        connectO = (ConnectO)queue.removeHead();
                    }
                }
                if (connectO != null) {
                    if (waiter == null || this.freeList.size() >= 10) break block61;
                    object = this.freeList;
                    synchronized (object) {
                        if (this.freeList.size() < 10) {
                            this.freeList.addToTail((QueueElement)waiter);
                        }
                        break block61;
                    }
                }
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Waiting for free connection: ", (Object)new Object[]{new Long(l), new Integer(this.connectionCount), new Integer(this.attrs.getMaxConnectionPoolSize())});
                }
                if (waiter == null) {
                    object = this.freeList;
                    synchronized (object) {
                        waiter = (Waiter)this.freeList.removeHead();
                    }
                    if (waiter == null) {
                        waiter = new Waiter();
                    }
                }
                object = waiter;
                synchronized (object) {
                    Queue queue2 = this.waiters;
                    synchronized (queue2) {
                        if (l == l2) {
                            waiter.setWokeUpOnNotify(false);
                            this.waiters.addToTail((QueueElement)waiter);
                        } else {
                            waiter.setWokeUpOnNotify(false);
                            this.waiters.addToHead((QueueElement)waiter);
                        }
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("number of waiters: " + this.waiters.size()));
                        }
                    }
                    try {
                        if (!bl) {
                            ((Object)((Object)waiter)).wait();
                        } else {
                            long l3 = System.currentTimeMillis();
                            ((Object)((Object)waiter)).wait(l);
                            long l4 = System.currentTimeMillis();
                            l -= l4 - l3;
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        if (tc.isEntryEnabled()) {
                            Tr.exit((TraceComponent)tc, (String)"waitForVictimConnection: Interrupted!", (Object)interruptedException);
                        }
                        queue = this.waiters;
                        synchronized (queue) {
                            waiter.removeFromQueue();
                        }
                        if (this.freeList.size() < 10) {
                            queue = this.freeList;
                            synchronized (queue) {
                                if (this.freeList.size() < 10) {
                                    this.freeList.addToTail((QueueElement)waiter);
                                }
                            }
                        }
                        throw new SQLException("Interruped waiting for connection");
                    }
                }
                if (!this.destroyed) continue;
                if (this.freeList.size() < 10) {
                    object = this.freeList;
                    synchronized (object) {
                        if (this.freeList.size() < 10) {
                            this.freeList.addToTail((QueueElement)waiter);
                        }
                    }
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"waitForVictimConnection: Pool destroyed");
                }
                throw new ConnectionPoolDestroyedException();
            } while (!bl || waiter.getWokeUpOnNotify());
            object = this.waiters;
            synchronized (object) {
                waiter.removeFromQueue();
            }
            if (this.pmiData != null) {
                this.pmiData.connectionWaitTimeout();
            }
            if (this.freeList.size() < 10) {
                object = this.freeList;
                synchronized (object) {
                    if (this.freeList.size() < 10) {
                        this.freeList.addToTail((QueueElement)waiter);
                    }
                }
            }
            if (this.attrs.isDiagOptionEnabled(4)) {
                object = (Vector)this.connections.clone();
                int n = ((Vector)object).size();
                for (int i = 0; i < n; ++i) {
                    ConnectO connectO2 = (ConnectO)((Vector)object).elementAt(i);
                    if (connectO2.state == 0) continue;
                    Tr.warning((TraceComponent)tc, (String)"MSG_CONM_6026W", (Object)new Object[]{this.attrs.getName(), connectO2.getTracer()});
                }
            } else {
                Tr.warning((TraceComponent)tc, (String)"MSG_CONM_6008W", (Object)new Object[]{"diagOptions", new Integer(4), this.attrs.getName()});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("waitForVictimConnection: Timeout " + (Object)((Object)waiter) + " " + waiter.getWokeUpOnNotify()));
            }
            throw new ConnectionWaitTimeoutException();
        }
        if (this.pmiData != null) {
            this.pmiData.endWaitForConnection((long)this.attrs.getConnectionTimeoutInMillis() - l);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"waitForVictimConnection", connectO);
        }
        return connectO;
    }

    private void setupOrphanAlarm() {
        if (this.attrs.getOrphanTimeout() > 0) {
            this.orphanAlarm = AlarmManager.create((long)this.attrs.getOrphanTimeoutInMillis(), (AlarmListener)this, (Object)ORPHAN_ALARM);
        }
    }

    private void setupAgedAlarm() {
        if (this.attrs.getAgedTimeout() > 0) {
            this.agedAlarm = AlarmManager.create((long)this.attrs.getAgedTimeoutInMillis(), (AlarmListener)this, (Object)AGED_ALARM);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void alarm(Object object) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"alarm", (Object)object);
        }
        if (object == ORPHAN_ALARM) {
            this.orphanAlarm = null;
            Vector vector = null;
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                vector = (Vector)this.connections.clone();
            }
            for (int i = 0; i < vector.size(); ++i) {
                ((ConnectO)vector.elementAt(i)).checkForOrphan();
            }
            ConnectionPool connectionPool2 = this;
            synchronized (connectionPool2) {
                if (!this.destroyed) {
                    this.setupOrphanAlarm();
                }
            }
        }
        if (object == AGED_ALARM) {
            this.agedAlarm = null;
            Vector vector = null;
            ConnectionPool connectionPool = this;
            synchronized (connectionPool) {
                vector = (Vector)this.connections.clone();
            }
            for (int i = 0; i < vector.size(); ++i) {
                ((ConnectO)vector.elementAt(i)).checkForAged();
            }
            ConnectionPool connectionPool3 = this;
            synchronized (connectionPool3) {
                if (!this.destroyed) {
                    this.setupAgedAlarm();
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"alarm");
        }
    }

    private synchronized int getConnectionCount() {
        return this.connectionCount;
    }

    public ErrorMap getErrorMap() {
        return this.errorMap;
    }

    private void createPmiData(CMPropertiesImpl cMPropertiesImpl) {
        ObjectName objectName;
        ObjectName objectName2;
        block7: {
            if (tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)"createPmiData");
            }
            objectName2 = null;
            objectName = null;
            try {
                AdminService adminService = AdminServiceFactory.getAdminService();
                ObjectName objectName3 = new ObjectName("WebSphere:mbeanIdentifier=" + cMPropertiesImpl.getMBeanProviderId() + ",*");
                Set set = adminService.queryNames(objectName3, null);
                objectName = (ObjectName)set.iterator().next();
                objectName3 = new ObjectName("WebSphere:mbeanIdentifier=" + cMPropertiesImpl.getMBeanFactoryId() + ",*");
                set = adminService.queryNames(objectName3, null);
                objectName2 = (ObjectName)set.iterator().next();
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ejs.cm.ConnectionPool.createPmiData", (String)"1490", (Object)this);
                if (!tc.isDebugEnabled()) break block7;
                Tr.debug((TraceComponent)tc, (String)"Caught exception when trying to get objectNames for PMI data. Setting them to null and continuing");
                Tr.debug((TraceComponent)tc, (String)("Exception = " + exception));
                objectName2 = null;
                objectName = null;
            }
        }
        if (objectName2 == null || objectName == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Warning : FactoryName or ProviderName was null when trying to create pmiData");
                Tr.debug((TraceComponent)tc, (String)("FactoryName = " + (objectName2 == null ? "null" : "not null")));
                Tr.debug((TraceComponent)tc, (String)("ProviderName = " + (objectName == null ? "null" : "not null")));
                Tr.debug((TraceComponent)tc, (String)"Setting both to null - pmi can handle null values.");
                objectName2 = null;
                objectName = null;
            }
        } else {
            this.pmiData = PmiFactory.createConnPoolPerf((String)cMPropertiesImpl.getName(), objectName, objectName2);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createPmiData");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        TraceComponent traceComponent = Tr.register((Class)(class$com$ibm$ejs$cm$pool$ConnectionPool == null ? (class$com$ibm$ejs$cm$pool$ConnectionPool = ConnectionPool.class$("com.ibm.ejs.cm.pool.ConnectionPool")) : class$com$ibm$ejs$cm$pool$ConnectionPool), null, (String)"com.ibm.ejs.resources.CONMMessages");
        DiagnosticModuleForCMPool diagnosticModuleForCMPool = new DiagnosticModuleForCMPool();
        int n = FFDC.registerDiagnosticModule((DiagnosticModule)diagnosticModuleForCMPool, (String)"com.ibm.ejs.cm.pool");
        if (n != 0 && traceComponent.isDebugEnabled()) {
            Tr.debug((TraceComponent)traceComponent, (String)"Error registering DiagnosticModule");
            Tr.debug((TraceComponent)traceComponent, (String)("Value returned from attempt to register DM = " + n));
        }
        ORPHAN_ALARM = new Object();
        AGED_ALARM = new Object();
        tc = Tr.register((Class)(class$com$ibm$ejs$cm$pool$ConnectionPool == null ? (class$com$ibm$ejs$cm$pool$ConnectionPool = ConnectionPool.class$("com.ibm.ejs.cm.pool.ConnectionPool")) : class$com$ibm$ejs$cm$pool$ConnectionPool), null, (String)"com.ibm.ejs.resources.CONMMessages");
    }
}

