/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.cm.portability;

import com.ibm.ejs.cm.CMProperties;
import com.ibm.ejs.cm.CMPropertiesImpl;
import com.ibm.ejs.cm.DataSourceProperties;
import com.ibm.ejs.cm.cache.CachedStatement;
import com.ibm.ejs.cm.portability.GenericPortabilityLayer;
import com.ibm.ejs.cm.portability.HugeString;
import com.ibm.ejs.cm.portability.MSSQLPortabilityLayer;
import com.ibm.ejs.cm.portability.OraclePortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayer;
import com.ibm.ejs.cm.portability.PortabilityLayerImpl;
import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.PooledConnection;
import javax.sql.XAConnection;
import javax.sql.XADataSource;

public class MerantPortabilityLayer
extends PortabilityLayerImpl {
    private static final int NUM_SUPPORTED_MERANT_BACKENDS = 3;
    private static final int GENERIC_BACKEND = 0;
    private static final int SQLSERVER_BACKEND = 1;
    private static final int ORACLE_BACKEND = 2;
    private static MerantPortabilityLayer[] instanceArray = new MerantPortabilityLayer[3];
    protected PortabilityLayer backendPortabilityLayer = null;
    private static final TraceComponent tc = Tr.register((Class)(class$com$ibm$ejs$cm$portability$MerantPortabilityLayer == null ? (class$com$ibm$ejs$cm$portability$MerantPortabilityLayer = MerantPortabilityLayer.class$("com.ibm.ejs.cm.portability.MerantPortabilityLayer")) : class$com$ibm$ejs$cm$portability$MerantPortabilityLayer));
    static /* synthetic */ Class class$com$ibm$websphere$ce$cm$StaleConnectionException;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$ibm$ejs$cm$portability$MerantPortabilityLayer;

    protected MerantPortabilityLayer(PortabilityLayer portabilityLayer) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"<init>", (Object)portabilityLayer);
        }
        this.backendPortabilityLayer = portabilityLayer;
        this.errorMap.put(new Integer(2251), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = MerantPortabilityLayer.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.errorMap.put(new Integer(2306), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = MerantPortabilityLayer.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.errorMap.put(new Integer(2310), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = MerantPortabilityLayer.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        this.errorMap.put(new Integer(2311), class$com$ibm$websphere$ce$cm$StaleConnectionException == null ? (class$com$ibm$websphere$ce$cm$StaleConnectionException = MerantPortabilityLayer.class$("com.ibm.websphere.ce.cm.StaleConnectionException")) : class$com$ibm$websphere$ce$cm$StaleConnectionException);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"<init>");
        }
    }

    public SQLException translateException(SQLException sQLException, Hashtable hashtable) {
        String string = sQLException.getMessage();
        int n = string.indexOf("]");
        if (n != -1 && string.charAt(n + 1) == '[' && string.charAt((n = string.indexOf("]", n + 2)) + 1) == '[') {
            return this.backendPortabilityLayer.translateException(sQLException, hashtable);
        }
        return super.translateException(sQLException, hashtable);
    }

    public void createTable(Connection connection, String string, String string2, String string3) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTable", (Object)new Object[]{connection, string, string2, string3});
        }
        this.backendPortabilityLayer.createTable(connection, string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTable");
        }
    }

    public void createTable(Connection connection, String string, String string2) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTable", (Object)new Object[]{connection, string, string2});
        }
        this.backendPortabilityLayer.createTable(connection, string, string2);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTable");
        }
    }

    public void createTableForPersister(Connection connection, String string, String string2, String string3) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"createTableForPersister", (Object)new Object[]{connection, string, string3});
        }
        this.backendPortabilityLayer.createTableForPersister(connection, string, string2, string3);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"createTableForPersister");
        }
    }

    public String addRowLockHint(String string) {
        return this.backendPortabilityLayer.addRowLockHint(string);
    }

    public boolean supportsRowLockHint() {
        return this.backendPortabilityLayer.supportsRowLockHint();
    }

    public void setDate(PreparedStatement preparedStatement, int n, Date date, Calendar calendar) throws SQLException {
        this.backendPortabilityLayer.setDate(preparedStatement, n, date, calendar);
    }

    public void setDate(PreparedStatement preparedStatement, int n, Date date) throws SQLException {
        this.backendPortabilityLayer.setDate(preparedStatement, n, date);
    }

    public void setTime(PreparedStatement preparedStatement, int n, Time time, Calendar calendar) throws SQLException {
        this.backendPortabilityLayer.setTime(preparedStatement, n, time, calendar);
    }

    public void setTime(PreparedStatement preparedStatement, int n, Time time) throws SQLException {
        this.backendPortabilityLayer.setTime(preparedStatement, n, time);
    }

    public Date getDate(ResultSet resultSet, int n, Calendar calendar) throws SQLException {
        return this.backendPortabilityLayer.getDate(resultSet, n, calendar);
    }

    public Date getDate(ResultSet resultSet, String string, Calendar calendar) throws SQLException {
        return this.backendPortabilityLayer.getDate(resultSet, string, calendar);
    }

    public Date getDate(ResultSet resultSet, int n) throws SQLException {
        return this.backendPortabilityLayer.getDate(resultSet, n);
    }

    public Date getDate(ResultSet resultSet, String string) throws SQLException {
        return this.backendPortabilityLayer.getDate(resultSet, string);
    }

    public Time getTime(ResultSet resultSet, int n, Calendar calendar) throws SQLException {
        return this.backendPortabilityLayer.getTime(resultSet, n, calendar);
    }

    public Time getTime(ResultSet resultSet, String string, Calendar calendar) throws SQLException {
        return this.backendPortabilityLayer.getTime(resultSet, string, calendar);
    }

    public Time getTime(ResultSet resultSet, int n) throws SQLException {
        return this.backendPortabilityLayer.getTime(resultSet, n);
    }

    public Time getTime(ResultSet resultSet, String string) throws SQLException {
        return this.backendPortabilityLayer.getTime(resultSet, string);
    }

    public String scanSQL(String string) {
        return this.backendPortabilityLayer.scanSQL(string);
    }

    public String processSQL(String string, int n, boolean bl, boolean bl2) {
        return this.backendPortabilityLayer.processSQL(string, n, bl, bl2);
    }

    public String getColumnTypeSpec(int n) {
        return this.backendPortabilityLayer.getColumnTypeSpec(n);
    }

    public String getNamedColumnSpec(int n) {
        return this.backendPortabilityLayer.getNamedColumnSpec(n);
    }

    public void setTransactionIsolation(Connection connection, int n) throws SQLException {
        this.backendPortabilityLayer.setTransactionIsolation(connection, n);
    }

    public ConnectionPoolDataSource getDataSource(DataSourceProperties dataSourceProperties) throws SQLException {
        return this.backendPortabilityLayer.getDataSource(dataSourceProperties);
    }

    public XADataSource getXADataSource(DataSourceProperties dataSourceProperties) throws SQLException {
        return this.backendPortabilityLayer.getXADataSource(dataSourceProperties);
    }

    public Properties getDefaultDataSourceProps() {
        return this.backendPortabilityLayer.getDefaultDataSourceProps();
    }

    public boolean supportsSchema() {
        return this.backendPortabilityLayer.supportsSchema();
    }

    public void setHugeStringForPreparedStatement(HugeString hugeString, PreparedStatement preparedStatement, int n) throws SQLException {
        this.backendPortabilityLayer.setHugeStringForPreparedStatement(hugeString, preparedStatement, n);
    }

    public boolean checkCMPStoreOperation(String string, Connection connection, boolean bl) throws SQLException {
        return this.backendPortabilityLayer.checkCMPStoreOperation(string, connection, bl);
    }

    public void configureConnection(Connection connection, CMPropertiesImpl cMPropertiesImpl) throws SQLException {
        MerantPortabilityLayer.unlockJDBCDriver(connection, cMPropertiesImpl.getDataSourceClassName());
        this.backendPortabilityLayer.configureConnection(connection, cMPropertiesImpl);
    }

    public void configurePooledConnection(PooledConnection pooledConnection, CMProperties cMProperties) throws SQLException {
        this.backendPortabilityLayer.configurePooledConnection(pooledConnection, cMProperties);
    }

    public void configureXAConnection(XAConnection xAConnection, CMProperties cMProperties) throws SQLException {
        this.backendPortabilityLayer.configureXAConnection(xAConnection, cMProperties);
    }

    public static void unlockJDBCDriver(Connection connection, String string) throws SQLException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"unlockJDBCDriver", (Object)new Object[]{connection, string});
        }
        String string2 = null;
        if (string.startsWith("com.ibm.websphere") || string.startsWith("com.ddtek.jdbcx.sequelink")) {
            Tr.event((TraceComponent)tc, (String)"unlockJDBCDriver", (Object)string);
            string2 = "unlock";
        } else if (string.startsWith("com.merant.")) {
            Tr.event((TraceComponent)tc, (String)"unlockJDBCDriver", (Object)string);
            string2 = "setOemId";
        } else {
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unlockJDBCDriver, driver not branded, unlock not called");
            }
            return;
        }
        try {
            connection.getClass().getMethod(string2, class$java$lang$String == null ? (class$java$lang$String = MerantPortabilityLayer.class$("java.lang.String")) : class$java$lang$String).invoke((Object)connection, "WebSphereDataDirectOemId");
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"unlockJDBCDriver, unlockMethod: ", (Object)string2);
            }
        }
        catch (InvocationTargetException invocationTargetException) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"InvocationTargetException: ", (Object)invocationTargetException.getTargetException());
            }
            throw new SQLException(invocationTargetException.getTargetException().toString());
        }
        catch (Exception exception) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception: ", (Object)exception);
            }
            throw new SQLException(exception.toString());
        }
    }

    public PortabilityLayer getBackendPortabilityLayer() {
        return this.backendPortabilityLayer;
    }

    static PortabilityLayer getPortabilityLayer(Connection connection) throws SQLException {
        DatabaseMetaData databaseMetaData = connection.getMetaData();
        if (databaseMetaData != null) {
            String string = databaseMetaData.getDatabaseProductName();
            if (string == null) {
                return MerantPortabilityLayer.getInstance(0);
            }
            if (string.equals("Oracle")) {
                return MerantPortabilityLayer.getInstance(2);
            }
            if (string.equals("Microsoft SQL Server")) {
                return MerantPortabilityLayer.getInstance(1);
            }
        }
        return MerantPortabilityLayer.getInstance(0);
    }

    private static PortabilityLayer getInstance(int n) throws SQLException {
        if (instanceArray[n] == null) {
            switch (n) {
                case 1: {
                    MerantPortabilityLayer.instanceArray[n] = new MerantPortabilityLayer(MSSQLPortabilityLayer.getInstance());
                    break;
                }
                case 2: {
                    MerantPortabilityLayer.instanceArray[n] = new MerantPortabilityLayer(OraclePortabilityLayer.getInstance());
                    break;
                }
                default: {
                    MerantPortabilityLayer.instanceArray[n] = new MerantPortabilityLayer(GenericPortabilityLayer.getInstance());
                }
            }
        }
        return instanceArray[n];
    }

    public void resetStatement(CachedStatement cachedStatement) throws SQLException {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"resetStatement no-op");
        }
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

