/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.text.MessageFormat;
import javax.accessibility.AccessibleContext;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import sun.plugin.panel.ActivatorSubPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class AdvancedPanel
extends ActivatorSubPanel
implements ActionListener,
ItemListener,
KeyListener {
    private static boolean hideJITBox;
    private static boolean hideDebugBox;
    private MessageHandler mh = new MessageHandler("advanced");
    private JCheckBox debugButton;
    private JCheckBox jitButton;
    private JTextField debugPort;
    private JLabel debugPortLabel;
    private JTextField jdkPath;
    private JComboBox jdkInstalled;
    private final String otherJDK = this.mh.getMessage("other_jdk");
    private final String defaultJRE = this.mh.getMessage("default_jdk");
    private JLabel pathLabel;
    private int jreNb;
    private int jdkNb;

    AdvancedPanel(ConfigurationInfo configurationInfo) {
        super(configurationInfo);
        this.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("jre_name")));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BoxLayout(jPanel2, 0));
        jPanel.setLayout(new BoxLayout(jPanel, 0));
        jPanel2.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel.add(jPanel2);
        this.jdkInstalled = new JComboBox();
        this.addAccessibleName(this.jdkInstalled, this.mh.getMessage("jre_name"));
        this.jdkInstalled.setMaximumRowCount(3);
        if (this.setInstalledJavaList()) {
            this.jdkInstalled.addItemListener(this);
            jPanel2.add(this.jdkInstalled);
        }
        jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
        this.setLayout(new BoxLayout(this, 1));
        this.add(Box.createRigidArea(new Dimension(1, 15)));
        this.add(jPanel);
        this.add(Box.createRigidArea(new Dimension(1, 10)));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new GridLayout(1, 0));
        jPanel3.setBorder(BorderFactory.createEmptyBorder(15, 8, 4, 4));
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout(new BoxLayout(jPanel4, 0));
        this.pathLabel = new JLabel(this.mh.getMessage("path") + " ");
        jPanel4.add(this.pathLabel);
        this.jdkPath = new JTextField();
        this.pathLabel.setLabelFor(this.jdkPath);
        Dimension dimension = this.jdkPath.getPreferredSize();
        dimension.width = 200;
        this.jdkPath.setMaximumSize(dimension);
        this.jdkPath.addKeyListener(this);
        jPanel4.add(this.jdkPath);
        jPanel3.add(jPanel4);
        jPanel.setLayout(new BoxLayout(jPanel, 1));
        jPanel.add(jPanel3);
        JPanel jPanel5 = new JPanel();
        jPanel5.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel5.setLayout(new BoxLayout(jPanel5, 0));
        this.jitButton = new JCheckBox(this.mh.getMessage("enable_jit"));
        this.jitButton.addActionListener(this);
        jPanel5.add(this.jitButton);
        if (!hideJITBox) {
            jPanel.add(Box.createRigidArea(new Dimension(1, 5)));
            jPanel.add(jPanel5);
        }
        this.debugButton = new JCheckBox(this.mh.getMessage("enable_debug"));
        this.debugButton.addActionListener(this);
        JPanel jPanel6 = new JPanel();
        jPanel6.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        jPanel6.setBorder(BorderFactory.createTitledBorder(this.mh.getMessage("debug_settings")));
        jPanel6.add(this.debugButton);
        JPanel jPanel7 = new JPanel();
        this.debugPortLabel = new JLabel(this.mh.getMessage("debug_port"));
        jPanel7.add(this.debugPortLabel);
        jPanel7.add(Box.createRigidArea(new Dimension(5, 1)));
        this.debugPort = new JTextField("2502", 6);
        this.debugPort.setAlignmentX(0.0f);
        this.debugPort.setMaximumSize(this.debugPort.getPreferredSize());
        this.debugPort.addKeyListener(this);
        this.debugPortLabel.setLabelFor(this.debugPort);
        jPanel7.add(this.debugPort);
        if (!hideDebugBox) {
            this.add(Box.createRigidArea(new Dimension(1, 5)));
            this.add(jPanel6);
        }
        jPanel6.add(jPanel7);
        this.reset();
    }

    private boolean setInstalledJavaList() {
        Object[] objectArray;
        Object object;
        if (this.jdkInstalled.getItemCount() > 0) {
            this.jdkInstalled.removeAllItems();
        }
        this.jdkInstalled.addItem(this.defaultJRE);
        String[][] stringArray = this.model.getInstalledJREList();
        this.jreNb = stringArray == null ? 0 : stringArray.length;
        int n = 0;
        while (n < this.jreNb) {
            object = stringArray[n][0];
            String string = stringArray[n][1];
            objectArray = new Object[]{object, string};
            this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jre_format"), objectArray));
            ++n;
        }
        object = this.model.getInstalledJDKList();
        this.jdkNb = object == null ? 0 : ((String[][])object).length;
        int n2 = 0;
        while (n2 < this.jdkNb) {
            objectArray = object[n2][0];
            String string = object[n2][1];
            Object[] objectArray2 = new Object[]{objectArray, string};
            this.jdkInstalled.addItem(MessageFormat.format(this.mh.getMessage("jdk_format"), objectArray2));
            ++n2;
        }
        this.jdkInstalled.addItem(this.otherJDK);
        return true;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.debugButton) {
            this.debugPort.setEnabled(this.debugButton.isSelected());
            this.debugPortLabel.setEnabled(this.debugButton.isSelected());
            this.debugPort.repaint();
            this.debugPortLabel.repaint();
            this.model.setDebugEnabled(this.debugButton.isSelected());
        } else if (actionEvent.getSource() == this.jitButton) {
            boolean bl = this.jitButton.isSelected();
            this.model.setJITEnabled(bl);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.jdkInstalled) {
            String[][] stringArray;
            int n = this.jdkInstalled.getSelectedIndex();
            if (n == 0) {
                this.enableDebug(false);
                this.model.setJavaRuntimeType("Default");
                this.model.setJavaRuntimeVersion(null);
            }
            if (n > 0 && n <= this.jreNb) {
                this.enableDebug(false);
                this.model.setJavaRuntimeType("JRE");
                stringArray = this.model.getInstalledJREList();
                this.model.setJavaRuntimeVersion(stringArray[n - 1][0]);
            }
            if (n > this.jreNb && n <= this.jreNb + this.jdkNb) {
                this.enableDebug(true);
                this.model.setJavaRuntimeType("JDK");
                stringArray = this.model.getInstalledJDKList();
                this.model.setJavaRuntimeVersion(stringArray[n - this.jreNb - 1][0]);
            }
            if (n == this.jdkInstalled.getItemCount() - 1) {
                this.enableDebug(true);
                this.model.setJavaRuntimeType(this.jdkPath.getText());
                this.model.setJavaRuntimeVersion(null);
            }
            this.reset();
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.getSource() == this.debugPort) {
            this.model.setDebugPort(this.debugPort.getText());
        } else if (keyEvent.getSource() == this.jdkPath) {
            this.model.setJavaRuntimeType(this.jdkPath.getText());
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.keyTyped(keyEvent);
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void reset() {
        boolean bl = this.model.isJITEnabled();
        this.jitButton.setSelected(bl);
        boolean bl2 = this.model.isDebugEnabled();
        this.debugButton.setSelected(bl2);
        this.debugPort.setText(this.model.getDebugPort());
        this.debugPort.setEnabled(bl2);
        this.debugPortLabel.setEnabled(bl2);
        boolean bl3 = true;
        String string = this.model.getJavaRuntimeType();
        this.pathLabel.setEnabled(false);
        this.jdkPath.setEnabled(false);
        try {
            if (string.equalsIgnoreCase("Default")) {
                this.enableDebug(false);
                this.jdkInstalled.setSelectedIndex(0);
            } else if (string.equalsIgnoreCase("JDK")) {
                this.enableDebug(true);
                String[][] stringArray = this.model.getInstalledJDKList();
                String string2 = this.model.getJavaRuntimeVersion();
                int n = 0;
                while (!stringArray[n][0].equalsIgnoreCase(string2)) {
                    ++n;
                }
                this.jdkInstalled.setSelectedIndex(this.jreNb + n + 1);
            } else if (string.equalsIgnoreCase("JRE")) {
                this.enableDebug(false);
                String[][] stringArray = this.model.getInstalledJREList();
                String string3 = this.model.getJavaRuntimeVersion();
                int n = 0;
                while (!stringArray[n][0].equalsIgnoreCase(string3)) {
                    ++n;
                }
                this.jdkInstalled.setSelectedIndex(n + 1);
            } else {
                this.jdkInstalled.setSelectedIndex(this.jdkInstalled.getItemCount() - 1);
                this.jdkPath.setText(string);
                this.jdkPath.setEnabled(true);
                this.pathLabel.setEnabled(true);
                this.enableDebug(true);
            }
        }
        catch (Exception exception) {
            this.jdkInstalled.setSelectedIndex(0);
            this.model.firePropertyChange();
        }
    }

    public static void setHideJITBox(boolean bl) {
        hideJITBox = bl;
    }

    public static void setHideDebugBox(boolean bl) {
        hideDebugBox = bl;
    }

    private void enableDebug(boolean bl) {
        this.debugButton.setEnabled(bl);
        this.debugPort.setEnabled(bl);
        if (!bl) {
            this.model.setDebugEnabled(false);
            this.debugButton.setSelected(false);
        }
    }

    private void addAccessibleName(JComponent jComponent, String string) {
        AccessibleContext accessibleContext = jComponent.getAccessibleContext();
        accessibleContext.setAccessibleName(string);
    }
}

