/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.Vector;
import sun.plugin.panel.MessageHandler;
import sun.plugin.security.PluginCertificateStore;
import sun.plugin.usability.Trace;

public class ConfigurationInfo {
    private static File theUserPropertiesFile;
    private Properties props;
    private boolean debugMode = false;
    private boolean javapluginEnabled = true;
    private boolean showConsole = false;
    private boolean showException = false;
    private boolean classLoaderCacheEnabled = true;
    private boolean useJIT = false;
    private String JITPath;
    private String debugPort = "2502";
    private String[][] installedJREs;
    private String[][] installedJDKs;
    private boolean useDefaultProxy = true;
    private boolean useSameProxy = false;
    private String proxySettings;
    private String javaParms;
    private String javaVersion;
    private String javaRuntimePath = null;
    private String javaRuntimeType = "Default";
    private HashMap activeCertsMap = new HashMap();
    private HashMap inactiveCertsMap = new HashMap();
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private MessageHandler mh = new MessageHandler("config");

    public ConfigurationInfo() {
        if (theUserPropertiesFile == null) {
            String string = File.separator;
            String string2 = System.getProperty("os.name");
            if (string2.equals("OS/2")) {
                try {
                    String string3 = "sun.plugin.panel.Os2Platform";
                    Class<?> clazz = Class.forName(string3);
                    if (clazz != null) {
                        Object obj = clazz.newInstance();
                    }
                    theUserPropertiesFile = new File(System.getProperty("user.home") + string + "_java" + string + "plugin.prp");
                }
                catch (Exception exception) {}
            } else {
                String string4;
                theUserPropertiesFile = string2.indexOf("Windows") != -1 ? ((string4 = System.getProperty("websphere.workaround")) != null ? new File(System.getProperty("user.home") + string + ".java" + string + "properties.websphere") : new File(System.getProperty("user.home") + string + ".java" + string + "properties")) : new File(System.getProperty("user.home") + string + ".java" + string + "properties");
            }
            new File(theUserPropertiesFile.getParent()).mkdirs();
        }
        this.reset();
    }

    public void setJavaEnabled(boolean bl) {
        this.javapluginEnabled = bl;
        this.firePropertyChange();
    }

    public boolean isJavaEnabled() {
        return this.javapluginEnabled;
    }

    public void setConsoleEnabled(boolean bl) {
        this.showConsole = bl;
        this.firePropertyChange();
    }

    public boolean isConsoleEnabled() {
        return this.showConsole;
    }

    public void setShowException(boolean bl) {
        this.showException = bl;
        this.firePropertyChange();
    }

    public boolean isShowExceptionEnabled() {
        return this.showException;
    }

    public void setJarCacheEnabled(boolean bl) {
        this.classLoaderCacheEnabled = bl;
        this.firePropertyChange();
    }

    public boolean isJarCacheEnabled() {
        return this.classLoaderCacheEnabled;
    }

    public boolean isJITEnabled() {
        return this.useJIT;
    }

    public void setJITEnabled(boolean bl) {
        this.useJIT = bl;
        this.firePropertyChange();
    }

    public String getJITPath() {
        return this.JITPath;
    }

    public void setJITPath(String string) {
        this.JITPath = string;
        this.firePropertyChange();
    }

    public void setDebugEnabled(boolean bl) {
        this.debugMode = bl;
        this.firePropertyChange();
    }

    public boolean isDebugEnabled() {
        return this.debugMode;
    }

    public void setDebugPort(String string) {
        this.debugPort = string;
        this.firePropertyChange();
    }

    public String getDebugPort() {
        return this.debugPort;
    }

    public void setInstalledJREList(Vector vector) {
        this.installedJREs = new String[vector.size() / 2][2];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.installedJREs[n][0] = (String)enumeration.nextElement();
            this.installedJREs[n][1] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[][] getInstalledJREList() {
        return this.installedJREs;
    }

    public void setInstalledJDKList(Vector vector) {
        this.installedJDKs = new String[vector.size() / 2][2];
        int n = 0;
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            this.installedJDKs[n][0] = (String)enumeration.nextElement();
            this.installedJDKs[n][1] = (String)enumeration.nextElement();
            ++n;
        }
    }

    public String[][] getInstalledJDKList() {
        return this.installedJDKs;
    }

    public void setJavaRuntimeVersion(String string) {
        if (this.javaVersion == string) {
            return;
        }
        this.javaVersion = string;
        this.firePropertyChange();
    }

    public String getJavaRuntimeVersion() {
        return this.javaVersion;
    }

    public void setJavaRuntimeType(String string) {
        if (string != null) {
            if (string.equalsIgnoreCase("Default")) {
                this.javaRuntimeType = "Default";
                this.javaRuntimePath = null;
            } else if (string.equalsIgnoreCase("JDK")) {
                this.javaRuntimeType = "JDK";
                this.javaRuntimePath = null;
            } else if (string.equalsIgnoreCase("JRE")) {
                this.javaRuntimeType = "JRE";
                this.javaRuntimePath = null;
            } else {
                this.javaRuntimeType = "Other";
                this.javaRuntimePath = string;
            }
            this.firePropertyChange();
        }
    }

    public String getJavaRuntimeType() {
        if (this.javaRuntimeType != null && this.javaRuntimeType.equalsIgnoreCase("Other")) {
            return this.javaRuntimePath;
        }
        return this.javaRuntimeType;
    }

    public boolean useDefaultProxy() {
        return this.useDefaultProxy;
    }

    public void setDefaultProxySettings(boolean bl) {
        this.useDefaultProxy = bl;
        this.firePropertyChange();
    }

    public void setUseSameProxy(boolean bl) {
        this.useSameProxy = bl;
        this.firePropertyChange();
    }

    public boolean useSameProxy() {
        return this.useSameProxy;
    }

    public void setProxySettingsString(String string) {
        this.proxySettings = string;
        this.firePropertyChange();
    }

    public String getProxySettingsString() {
        return this.proxySettings;
    }

    public void setJavaParms(String string) {
        this.javaParms = string;
        this.firePropertyChange();
    }

    public String getJavaParms() {
        return this.javaParms;
    }

    public Collection getCertificates() {
        return this.activeCertsMap.keySet();
    }

    public void deactivateCertificate(String string) {
        Object v = this.activeCertsMap.remove(string);
        this.inactiveCertsMap.put(string, v);
        this.firePropertyChange();
    }

    private String extractAliasName(X509Certificate x509Certificate) {
        String string = "Unknown subject";
        try {
            Principal principal = x509Certificate.getSubjectDN();
            String string2 = principal.getName();
            int n = string2.indexOf("CN=");
            int n2 = 0;
            string = n < 0 ? "Unknown subject" : ((n2 = string2.charAt(n += 3) == '\"' ? string2.indexOf(34, ++n) : string2.indexOf(44, n)) < 0 ? string2.substring(n) : string2.substring(n, n2));
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        return string;
    }

    public void applyChanges() throws IOException {
        Object object;
        ((Hashtable)this.props).put("javaplugin.console", this.showConsole ? "true" : "false");
        ((Hashtable)this.props).put("javaplugin.exception", this.showException ? "true" : "false");
        ((Hashtable)this.props).put("javaplugin.classloader.cache.enabled", this.classLoaderCacheEnabled ? "true" : "false");
        ((Hashtable)this.props).put("javaplugin.enabled", this.javapluginEnabled ? "true" : "false");
        if (this.useJIT) {
            ((Hashtable)this.props).put("javaplugin.jit.enabled", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.jit.enabled", "false");
        }
        if (this.debugMode) {
            ((Hashtable)this.props).put("javaplugin.debug.mode", "true");
            ((Hashtable)this.props).put("javaplugin.debug.port", this.debugPort);
        } else {
            ((Hashtable)this.props).put("javaplugin.debug.mode", "false");
        }
        if (this.useDefaultProxy) {
            ((Hashtable)this.props).put("javaplugin.proxy.usebrowsersettings", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.proxy.usebrowsersettings", "false");
        }
        if (this.proxySettings != null) {
            ((Hashtable)this.props).put("javaplugin.proxy.settings", this.proxySettings);
        } else {
            ((Hashtable)this.props).remove("javaplugin.proxy.settings");
        }
        if (this.useSameProxy) {
            ((Hashtable)this.props).put("javaplugin.proxy.forallprotocols", "true");
        } else {
            ((Hashtable)this.props).put("javaplugin.proxy.forallprotocols", "false");
        }
        if (this.javaRuntimeType != null) {
            ((Hashtable)this.props).put("javaplugin.jre.type", this.javaRuntimeType);
        } else {
            this.javaRuntimeType = "Default";
            ((Hashtable)this.props).put("javaplugin.jre.type", "Default");
        }
        String string = null;
        if (this.javaVersion != null && this.javaVersion.length() > 0) {
            object = null;
            if (this.javaRuntimeType.equalsIgnoreCase("JRE")) {
                object = this.getInstalledJREList();
            }
            if (this.javaRuntimeType.equalsIgnoreCase("JDK")) {
                object = this.getInstalledJDKList();
            }
            if (object != null) {
                int n = 0;
                while (n < ((String[][])object).length) {
                    if (object[n][0].equalsIgnoreCase(this.javaVersion)) {
                        string = object[n][1];
                    }
                    ++n;
                }
            }
        }
        if (this.javaRuntimeType.equalsIgnoreCase("Other") && this.javaRuntimePath != null && !this.javaRuntimePath.trim().equals("")) {
            string = this.javaRuntimePath;
        }
        if (string != null) {
            ((Hashtable)this.props).put("javaplugin.jre.path", string);
        } else {
            ((Hashtable)this.props).put("javaplugin.jre.type", "Default");
            ((Hashtable)this.props).put("javaplugin.jre.path", "Default");
        }
        if (this.javaVersion != null && this.javaVersion.length() > 0) {
            ((Hashtable)this.props).put("javaplugin.jre.version", this.javaVersion);
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.version");
        }
        if (this.javaParms != null && this.javaParms.length() > 0) {
            ((Hashtable)this.props).put("javaplugin.jre.params", this.javaParms);
        } else {
            ((Hashtable)this.props).remove("javaplugin.jre.params");
        }
        object = new FileOutputStream(theUserPropertiesFile);
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream((OutputStream)object);
        PrintWriter printWriter = new PrintWriter(bufferedOutputStream);
        printWriter.println(this.mh.getMessage("property_file_header"));
        printWriter.flush();
        this.props.store(bufferedOutputStream, "");
        bufferedOutputStream.close();
        ((FileOutputStream)object).close();
        try {
            PluginCertificateStore pluginCertificateStore = new PluginCertificateStore();
            pluginCertificateStore.load();
            Collection collection = this.inactiveCertsMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                pluginCertificateStore.remove((Certificate)iterator.next());
            }
            pluginCertificateStore.save();
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
        this.inactiveCertsMap.clear();
    }

    public void reset() {
        Object object;
        Object object2;
        this.firePropertyChange();
        this.props = new Properties();
        try {
            object2 = new FileInputStream(theUserPropertiesFile);
            object = new BufferedInputStream((InputStream)object2);
            this.props.load((InputStream)object);
            ((BufferedInputStream)object).close();
            ((FileInputStream)object2).close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        object2 = this.props.getProperty("javaplugin.console");
        this.showConsole = object2 != null && ((String)object2).equals("true");
        object2 = this.props.getProperty("javaplugin.exception");
        this.showException = object2 != null && !((String)object2).equals("false");
        object2 = this.props.getProperty("javaplugin.classloader.cache.enabled");
        this.classLoaderCacheEnabled = object2 == null || ((String)object2).equals("true");
        object2 = this.props.getProperty("javaplugin.enabled");
        this.javapluginEnabled = object2 == null || ((String)object2).equals("true");
        object2 = this.props.getProperty("javaplugin.jit.enabled");
        this.useJIT = object2 == null || ((String)object2).equals("true");
        object2 = this.props.getProperty("javaplugin.debug.mode");
        this.debugMode = object2 != null && ((String)object2).equals("true");
        this.debugPort = this.props.getProperty("javaplugin.debug.port");
        if (this.debugPort == null) {
            this.debugPort = "2502";
        }
        this.useDefaultProxy = (object2 = this.props.getProperty("javaplugin.proxy.usebrowsersettings")) == null || ((String)object2).equals("true");
        this.proxySettings = this.props.getProperty("javaplugin.proxy.settings");
        object2 = this.props.getProperty("javaplugin.proxy.forallprotocols");
        this.useSameProxy = "true".equals(object2);
        this.javaRuntimePath = this.props.getProperty("javaplugin.jre.path");
        this.javaRuntimeType = this.props.getProperty("javaplugin.jre.type");
        this.javaRuntimeType = this.javaRuntimeType == null ? (this.javaRuntimePath != null && !this.javaRuntimePath.trim().equals("") ? "Other" : "Default") : (this.javaRuntimeType.equalsIgnoreCase("JRE") ? "JRE" : (this.javaRuntimeType.equalsIgnoreCase("JDK") ? "JDK" : (this.javaRuntimeType.equalsIgnoreCase("Other") ? (this.javaRuntimePath != null && !this.javaRuntimePath.trim().equals("") ? "Other" : "Default") : "Default")));
        if (this.javaRuntimeType == null) {
            this.javaRuntimeType = "Default";
        }
        this.javaVersion = this.props.getProperty("javaplugin.jre.version");
        this.javaParms = this.props.getProperty("javaplugin.jre.params");
        this.activeCertsMap.clear();
        this.inactiveCertsMap.clear();
        try {
            object = new PluginCertificateStore();
            object.load();
            Iterator iterator = object.iterator();
            while (iterator.hasNext()) {
                X509Certificate x509Certificate = (X509Certificate)iterator.next();
                String string = this.extractAliasName(x509Certificate);
                this.activeCertsMap.put(string, x509Certificate);
            }
        }
        catch (Exception exception) {
            Trace.printException(exception);
        }
    }

    protected void firePropertyChange() {
        this.pcs.firePropertyChange(null, null, null);
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.pcs.removePropertyChangeListener(propertyChangeListener);
    }
}

