/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.panel;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import sun.plugin.panel.ActivatorPanel;
import sun.plugin.panel.ConfigurationInfo;
import sun.plugin.panel.MessageHandler;

public class ControlPanel
extends JApplet {
    private static ControlPanel panel = null;
    private static MessageHandler mh = new MessageHandler("main");

    public void init() {
        ConfigurationInfo configurationInfo = new ConfigurationInfo();
        ActivatorPanel activatorPanel = new ActivatorPanel(configurationInfo);
        this.getContentPane().add(activatorPanel);
        this.validate();
    }

    public static ControlPanel getJavaControlPanel() {
        if (panel != null) {
            return panel;
        }
        panel = new ControlPanel();
        panel.init();
        return panel;
    }

    public static boolean isJavaControlPanelVisible() {
        if (panel == null) {
            return false;
        }
        ControlPanel controlPanel = ControlPanel.getJavaControlPanel();
        if (controlPanel != null) {
            return controlPanel.isVisible();
        }
        return false;
    }

    public static void showJavaControlPanel(boolean bl) {
        ControlPanel controlPanel;
        if (bl != ControlPanel.isJavaControlPanelVisible() && (controlPanel = ControlPanel.getJavaControlPanel()) != null) {
            controlPanel.setVisible(bl);
        }
    }

    public static void main(String[] stringArray) {
        if (stringArray.length != 0 && stringArray[0].equalsIgnoreCase("websphereCPL")) {
            System.setProperty("websphere.workaround", "true");
        }
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InstantiationException instantiationException) {
            // empty catch block
        }
        ControlPanel.setupUIManager();
        ControlPanel controlPanel = new ControlPanel();
        controlPanel.init();
        JFrame jFrame = new JFrame(mh.getMessage("control_panel_caption"));
        jFrame.getContentPane().setLayout(new BorderLayout());
        jFrame.getContentPane().add((Component)controlPanel, "Center");
        jFrame.pack();
        jFrame.setResizable(false);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        Dimension dimension = jFrame.getSize();
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)jFrame).setSize(dimension);
        ((Component)jFrame).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        controlPanel.start();
        ((Component)jFrame).setVisible(true);
    }

    private static void setupUIManager() {
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        Font font = (Font)toolkit.getDesktopProperty("win.menu.font");
        Font font2 = (Font)toolkit.getDesktopProperty("win.messagebox.font");
        Color color = (Color)toolkit.getDesktopProperty("win.frame.backgroundColor");
        Color color2 = (Color)toolkit.getDesktopProperty("win.frame.textColor");
        if (font2 != null && ControlPanel.canFontDisplay(font2, mh.getMessage("control_panel_title"))) {
            UIManager.put("Menu.font", font);
            UIManager.put("MenuBar.font", font);
            UIManager.put("MenuItem.font", font);
            UIManager.put("Label.font", font2);
            UIManager.put("MessageBox.font", font2);
            UIManager.put("Panel.font", font2);
            UIManager.put("CheckBox.font", font2);
            UIManager.put("TabbedPane.font", font2);
        }
        UIManager.put("ComboBox.background", color);
        UIManager.put("ComboBox.foreground", color2);
    }

    private static boolean canFontDisplay(Font font, String string) {
        int n = font.canDisplayUpTo(string);
        return n == -1;
    }
}

