/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Random;
import sun.plugin.security.CertificateStore;
import sun.plugin.usability.Trace;
import sun.security.action.GetPropertyAction;

public class PluginCertificateStore
implements CertificateStore {
    private static String _filename = null;
    private KeyStore _jpicerts = null;

    public void load() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln("Loading JPI certificates from " + _filename);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    File file;
                    if (PluginCertificateStore.this._jpicerts == null) {
                        PluginCertificateStore.this._jpicerts = KeyStore.getInstance("JKS");
                        PluginCertificateStore.this._jpicerts.load(null, null);
                    }
                    if ((file = new File(_filename)).exists()) {
                        FileInputStream fileInputStream = new FileInputStream(new File(_filename));
                        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
                        PluginCertificateStore.this._jpicerts.load(bufferedInputStream, new char[0]);
                        bufferedInputStream.close();
                        fileInputStream.close();
                    }
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.securityPrintln("Loaded JPI certificates from " + _filename);
    }

    public void save() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
        Trace.securityPrintln("Saving JPI certificates in " + _filename);
        try {
            AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws IOException, CertificateException, KeyStoreException, NoSuchAlgorithmException {
                    FileOutputStream fileOutputStream = new FileOutputStream(new File(_filename));
                    BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(fileOutputStream);
                    PluginCertificateStore.this._jpicerts.store(bufferedOutputStream, new char[0]);
                    bufferedOutputStream.close();
                    fileOutputStream.close();
                    return null;
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            Exception exception = privilegedActionException.getException();
            if (exception instanceof IOException) {
                throw (IOException)exception;
            }
            if (exception instanceof CertificateException) {
                throw (CertificateException)exception;
            }
            if (exception instanceof KeyStoreException) {
                throw (KeyStoreException)exception;
            }
            if (exception instanceof NoSuchAlgorithmException) {
                throw (NoSuchAlgorithmException)exception;
            }
            Trace.securityPrintException(privilegedActionException);
        }
        Trace.securityPrintln("Saved JPI certificates in " + _filename);
    }

    public void add(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Adding certificate in JPI permanent certificate store");
        if (!this.contains(certificate)) {
            Random random = new Random();
            boolean bl = false;
            String string = null;
            do {
                Certificate certificate2;
                if ((certificate2 = this._jpicerts.getCertificate(string = "jpicert" + random.nextLong())) != null) continue;
                bl = true;
            } while (!bl);
            this._jpicerts.setCertificateEntry(string, certificate);
            Trace.securityPrintln("Added certificate in JPI permanent certificate store as alias " + string);
        }
    }

    public void remove(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Removing certificate in JPI permanent certificate store");
        String string = this._jpicerts.getCertificateAlias(certificate);
        if (string != null) {
            this._jpicerts.deleteEntry(string);
        }
        Trace.securityPrintln("Removed certificate in JPI permanent certificate store as alias " + string);
    }

    public boolean contains(Certificate certificate) throws KeyStoreException {
        Trace.securityPrintln("Checking if certificate is in JPI permanent certificate store");
        String string = null;
        string = this._jpicerts.getCertificateAlias(certificate);
        return string != null;
    }

    public boolean verify(Certificate certificate) {
        Trace.securityPrintln("Check if certificate can be verified using certificates in JPI permanent certificate store");
        return false;
    }

    public Iterator iterator() throws KeyStoreException {
        Trace.securityPrintln("Obtain certificate iterator in JPI permanent certificate store");
        HashSet<Certificate> hashSet = new HashSet<Certificate>();
        Enumeration<String> enumeration = this._jpicerts.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            Certificate certificate = this._jpicerts.getCertificate(string);
            hashSet.add(certificate);
        }
        return hashSet.iterator();
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("user.home"));
        String string2 = System.getProperty("os.name");
        if (string2.equals("OS/2")) {
            _filename = string + File.separator + "_java" + File.separator + "jpicerts";
        } else if (string2.indexOf("Windows") != -1) {
            String string3 = System.getProperty("websphere.workaround");
            _filename = string3 != null ? string + File.separator + ".java" + File.separator + "jpicerts.websphere" : string + File.separator + ".java" + File.separator + "jpicerts";
        } else {
            String string4 = AccessController.doPrivileged(new GetPropertyAction("javaplugin.nodotversion"));
            _filename = string + File.separator + ".java" + File.separator + "jpicerts";
        }
    }
}

