/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.security;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.security.Principal;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import javax.swing.JButton;
import javax.swing.JDialog;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.security.CertificateDialog;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.Trace;

class TrustDeciderDialog
implements ActionListener {
    public static final int TrustOption_GrantThisSession = 0;
    public static final int TrustOption_Deny = 1;
    public static final int TrustOption_GrantAlways = 2;
    private Certificate[] certs = null;
    private boolean rootCANotValid = false;
    private boolean timeNotValid = false;

    TrustDeciderDialog(Certificate[] certificateArray, boolean bl, boolean bl2) {
        this.certs = certificateArray;
        this.rootCANotValid = bl;
        this.timeNotValid = bl2;
    }

    int DoModal() {
        int n = -1;
        if (this.certs[0] instanceof X509Certificate && this.certs[this.certs.length - 1] instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)this.certs[0];
            X509Certificate x509Certificate2 = (X509Certificate)this.certs[this.certs.length - 1];
            Principal principal = x509Certificate.getSubjectDN();
            Principal principal2 = x509Certificate2.getIssuerDN();
            String string = principal.getName();
            String string2 = null;
            int n2 = string.indexOf("CN=");
            int n3 = 0;
            if (n2 < 0) {
                string2 = "\"Unknown subject\"";
            } else {
                try {
                    n3 = string.charAt(n2 += 3) == '\"' ? string.indexOf(34, ++n2) : string.indexOf(44, n2);
                    string2 = n3 < 0 ? string.substring(n2) : string.substring(n2, n3);
                    string2 = "\"" + string2 + "\"";
                }
                catch (Throwable throwable) {
                    string2 = "\"Unknown subject\"";
                }
            }
            String string3 = principal2.getName();
            String string4 = null;
            n2 = string3.indexOf("O=");
            n3 = 0;
            if (n2 < 0) {
                string4 = "\"Unknown issuer\"";
            } else {
                try {
                    n3 = string3.charAt(n2 += 2) == '\"' ? string3.indexOf(34, ++n2) : string3.indexOf(44, n2);
                    string4 = n3 < 0 ? string3.substring(n2) : string3.substring(n2, n3);
                    string4 = "\"" + string4 + "\"";
                }
                catch (Throwable throwable) {
                    string4 = "\"Unknown issuer\"";
                }
            }
            String string5 = TrustDeciderDialog.getMessage("security_dialog.text0") + string2 + TrustDeciderDialog.getMessage("security_dialog.text1") + string4 + TrustDeciderDialog.getMessage("security_dialog.text2") + string2 + TrustDeciderDialog.getMessage("security_dialog.text3") + string2 + TrustDeciderDialog.getMessage("security_dialog.text4");
            JButton jButton = new JButton(TrustDeciderDialog.getMessage("security_dialog.buttonInfo"));
            jButton.addActionListener(this);
            Object[] objectArray = new Object[]{TrustDeciderDialog.getMessage("security_dialog.buttonYes"), TrustDeciderDialog.getMessage("security_dialog.buttonNo"), TrustDeciderDialog.getMessage("security_dialog.buttonAlways"), jButton};
            if (!Trace.isAutomationEnabled()) {
                n = DialogFactory.showOptionDialog(string5, TrustDeciderDialog.getMessage("security_dialog.caption"), objectArray, objectArray[0]);
            } else {
                Trace.securityPrintln("Automation: Trust RSA certificate for signing", 2);
                n = 0;
            }
        }
        return n;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        CertificateDialog certificateDialog = new CertificateDialog((JDialog)null, this.certs, 0);
        certificateDialog.DoModal();
    }

    private static String getMessage(String string) {
        return ResourceHandler.getMessage(string);
    }
}

