/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.Component;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Array;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.PluginSysAction;
import sun.plugin.usability.PluginSysUtil;
import sun.plugin.usability.Trace;

public class DialogFactory {
    public static final int ERROR_MESSAGE = 1;
    public static final int INFORMATION_MESSAGE = 2;
    public static final int WARNING_MESSAGE = 3;
    public static final int QUESTION_MESSAGE = 4;
    public static final int PLAIN_MESSAGE = 5;
    private static ImageIcon icon = null;
    private static String confirmDialogTitle;
    private static String inputDialogTitle;
    private static String messageDialogTitle;
    private static String exceptionDialogTitle;
    private static String optionDialogTitle;
    private static String aboutDialogTitle;

    public static void showAboutPluginDialog() {
        try {
            PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    DialogFactory.showAboutPluginDialogImpl();
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void showAboutPluginDialogImpl() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                StringBuffer stringBuffer = new StringBuffer();
                stringBuffer.append(System.getProperty("java.runtime.name") + " " + System.getProperty("java.version"));
                stringBuffer.append("\n");
                stringBuffer.append(ResourceHandler.getMessage("default_vm_version") + System.getProperty("java.vm.version"));
                stringBuffer.append("\n");
                stringBuffer.append(ResourceHandler.getMessage("product_name"));
                stringBuffer.append(" ");
                stringBuffer.append(System.getProperty("javaplugin.version"));
                JOptionPane jOptionPane = new JOptionPane();
                jOptionPane.setIcon(icon);
                jOptionPane.setOptionType(-1);
                jOptionPane.setWantsInput(false);
                DialogFactory.showDialog(jOptionPane, aboutDialogTitle, stringBuffer, false);
                return null;
            }
        });
    }

    public static int showConfirmDialog(Object object) {
        return DialogFactory.showConfirmDialog(object, confirmDialogTitle);
    }

    public static void showMessageDialog(Object object) {
        DialogFactory.showMessageDialog(object, messageDialogTitle);
    }

    public static int showConfirmDialog(Object object, String string) {
        return DialogFactory.showConfirmDialog(null, object, string);
    }

    public static int showConfirmDialog(final Component component, final Object object, final String string) {
        try {
            return (Integer)PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.showConfirmDialogImpl(component, object, string));
                }
            });
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static int showConfirmDialogImpl(Component component, Object object, String string) {
        String string2 = ResourceHandler.getMessage("usability.confirm.yes");
        String string3 = ResourceHandler.getMessage("usability.confirm.no");
        Object[] objectArray = new Object[]{string2, string3};
        if (string == null) {
            string = confirmDialogTitle;
        }
        return DialogFactory.showOptionDialog(component, 4, object, string, objectArray, objectArray[0]);
    }

    public static int showOptionDialog(Object object, String string, Object[] objectArray, Object object2) {
        return DialogFactory.showOptionDialog(null, 3, object, string, objectArray, object2);
    }

    public static int showOptionDialog(final Component component, final int n, final Object object, final String string, final Object[] objectArray, final Object object2) {
        try {
            return (Integer)PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    return new Integer(DialogFactory.showOptionDialogImpl(component, n, object, string, objectArray, object2));
                }
            });
        }
        catch (Exception exception) {
            return 0;
        }
    }

    private static int showOptionDialogImpl(Component component, int n, Object object, String string, Object[] objectArray, Object object2) {
        Object object3;
        int n2 = -1;
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptions(objectArray);
        jOptionPane.setInitialValue(object2);
        jOptionPane.setWantsInput(false);
        Object object4 = DialogFactory.extractMessage(jOptionPane, object);
        if (string == null) {
            string = optionDialogTitle;
        }
        if (DialogFactory.showDialog(jOptionPane, string, object4) && (object3 = jOptionPane.getValue()) != null) {
            int n3 = 0;
            while (n3 < objectArray.length) {
                if (objectArray[n3].equals(object3)) {
                    n2 = n3;
                    break;
                }
                ++n3;
            }
            Trace.println("User selected: " + n2, 2);
        }
        return n2;
    }

    public static String showInputDialog(final Component component, final Object object, final String string) {
        try {
            return (String)PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    return DialogFactory.showInputDialogImpl(component, object, string);
                }
            });
        }
        catch (Exception exception) {
            return null;
        }
    }

    private static String showInputDialogImpl(Component component, Object object, String string) {
        Object object2;
        String string2 = null;
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptionType(2);
        jOptionPane.setWantsInput(true);
        Object object3 = DialogFactory.extractMessage(jOptionPane, object);
        if (string == null) {
            string = inputDialogTitle;
        }
        if (DialogFactory.showDialog(jOptionPane, string, object3) && (object2 = jOptionPane.getInputValue()) != null) {
            if (object2 instanceof String) {
                string2 = object2.toString();
            }
            Trace.println("User typed: " + string2, 2);
        }
        return string2;
    }

    public static void showMessageDialog(Object object, String string) {
        DialogFactory.showMessageDialog(null, 2, object, string, true);
    }

    public static void showMessageDialog(Object object, String string, boolean bl) {
        DialogFactory.showMessageDialog(null, 2, object, string, bl);
    }

    private static void showMessageDialog(final Component component, final int n, final Object object, final String string, final boolean bl) {
        try {
            PluginSysUtil.execute(new PluginSysAction(){

                public Object execute() throws Exception {
                    DialogFactory.showMessageDialogImpl(component, n, object, string, bl);
                    return null;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void showMessageDialogImpl(Component component, int n, Object object, String string, boolean bl) {
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptionType(-1);
        jOptionPane.setWantsInput(false);
        Object object2 = DialogFactory.extractMessage(jOptionPane, object);
        if (string == null) {
            string = messageDialogTitle;
        }
        DialogFactory.showDialog(jOptionPane, string, object2, bl);
    }

    public static void showExceptionDialog(Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialog(null, throwable, string, string2);
    }

    public static void showExceptionDialog(final Component component, final Throwable throwable, final String string, final String string2) {
        try {
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        PluginSysUtil.execute(new PluginSysAction(this){
                            private final /* synthetic */ 8 this$0;
                            {
                                this.this$0 = var1_1;
                            }

                            public Object execute() throws Exception {
                                DialogFactory.access$1200(8.access$800(this.this$0), 8.access$900(this.this$0), 8.access$1000(this.this$0), 8.access$1100(this.this$0));
                                return null;
                            }
                        });
                    }
                    catch (Throwable throwable2) {
                        throwable2.printStackTrace();
                    }
                    return null;
                }

                static /* synthetic */ Component access$800(8 var0) {
                    return var0.component;
                }

                static /* synthetic */ Throwable access$900(8 var0) {
                    return var0.throwable;
                }

                static /* synthetic */ String access$1000(8 var0) {
                    return var0.string;
                }

                static /* synthetic */ String access$1100(8 var0) {
                    return var0.string2;
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static void showExceptionDialogImpl(Component component, Throwable throwable, String string, String string2) {
        JOptionPane jOptionPane = new JOptionPane();
        jOptionPane.setIcon(icon);
        jOptionPane.setOptionType(-1);
        jOptionPane.setWantsInput(false);
        Object object = DialogFactory.extractMessage(jOptionPane, string);
        if (string2 == null) {
            string2 = exceptionDialogTitle;
        }
        DialogFactory.showDialog(jOptionPane, string2, object);
    }

    private static boolean showDialog(JOptionPane jOptionPane, String string, Object object) {
        return DialogFactory.showDialog(jOptionPane, string, object, true);
    }

    private static boolean showDialog(final JOptionPane jOptionPane, final String string, final Object object, final boolean bl) {
        boolean bl2 = true;
        try {
            jOptionPane.setValue(null);
            Runnable runnable = new Runnable(){

                public void run() {
                    JDialog jDialog = jOptionPane.createDialog(null, string);
                    jOptionPane.setMessage(object);
                    jDialog.pack();
                    DialogFactory.fixSwingLayoutBug(object);
                    jDialog.pack();
                    jDialog.setResizable(false);
                    jDialog.setModal(bl);
                    jDialog.addWindowListener(new WindowAdapter(this, jDialog){
                        private final /* synthetic */ JDialog val$dialog;
                        private final /* synthetic */ 10 this$0;
                        {
                            this.this$0 = var1_1;
                            this.val$dialog = jDialog;
                        }

                        public void windowClosing(WindowEvent windowEvent) {
                            this.val$dialog.removeWindowListener(this);
                            this.val$dialog.dispose();
                        }
                    });
                    jDialog.show();
                    jDialog.toFront();
                }
            };
            if (bl) {
                if (!SwingUtilities.isEventDispatchThread()) {
                    SwingUtilities.invokeAndWait(runnable);
                } else {
                    runnable.run();
                }
            } else if (!SwingUtilities.isEventDispatchThread()) {
                SwingUtilities.invokeLater(runnable);
            } else {
                runnable.run();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
            bl2 = false;
        }
        return bl2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Throwable throwable) {
        return DialogFactory.formatExceptionMessage(jOptionPane, throwable);
    }

    private static Object extractMessage(JOptionPane jOptionPane, String string) {
        return DialogFactory.formatStringMessage(jOptionPane, string);
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object[] objectArray) {
        Object[] objectArray2 = null;
        if (objectArray != null) {
            objectArray2 = new Object[objectArray.length];
            int n = 0;
            while (n < objectArray.length) {
                objectArray2[n] = DialogFactory.extractMessage(jOptionPane, objectArray[n]);
                ++n;
            }
        }
        return objectArray2;
    }

    private static Object extractMessage(JOptionPane jOptionPane, Object object) {
        if (object instanceof Object[]) {
            return DialogFactory.extractMessage(jOptionPane, (Object[])object);
        }
        if (object instanceof String) {
            return DialogFactory.extractMessage(jOptionPane, (String)object);
        }
        if (object instanceof Exception) {
            return DialogFactory.extractMessage(jOptionPane, (Exception)object);
        }
        return object;
    }

    private static Object formatStringMessage(JOptionPane jOptionPane, String string) {
        class MessageArea
        extends JTextArea {
            public MessageArea(String string) {
                super(string);
            }

            public boolean isManagingFocus() {
                return false;
            }

            public boolean isFocusTraversable() {
                return false;
            }
        }
        MessageArea messageArea = new MessageArea("" + string);
        messageArea.setColumns(40);
        messageArea.setAutoscrolls(true);
        messageArea.setEditable(false);
        messageArea.setLineWrap(true);
        messageArea.setWrapStyleWord(true);
        messageArea.setBackground(jOptionPane.getBackground());
        messageArea.setRequestFocusEnabled(false);
        JButton jButton = new JButton();
        jButton.add(messageArea);
        jButton.setBorderPainted(false);
        return jButton;
    }

    private static Object formatExceptionMessage(JOptionPane jOptionPane, Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        JTextArea jTextArea = new JTextArea("" + stringWriter.toString());
        jTextArea.setColumns(40);
        jTextArea.setRows(10);
        jTextArea.setEditable(false);
        jTextArea.setRequestFocusEnabled(false);
        JScrollPane jScrollPane = new JScrollPane(jTextArea);
        jTextArea.setBackground(jOptionPane.getBackground());
        return jScrollPane;
    }

    private static void fixSwingLayoutBug(final Object object) {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                if (object == null) {
                    return null;
                }
                if (object instanceof JButton) {
                    JButton jButton = (JButton)object;
                    JTextArea jTextArea = (JTextArea)jButton.getComponent(0);
                    jTextArea.getUI().getPreferredSize(jTextArea);
                    return null;
                }
                if (object.getClass().isArray()) {
                    int n = Array.getLength(object);
                    int n2 = 0;
                    while (n2 < n) {
                        DialogFactory.fixSwingLayoutBug(Array.get(object, n2));
                        ++n2;
                    }
                }
                return null;
            }
        });
    }

    static /* synthetic */ void access$1200(Component component, Throwable throwable, String string, String string2) {
        DialogFactory.showExceptionDialogImpl(component, throwable, string, string2);
    }

    static {
        try {
            icon = (ImageIcon)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    URL uRL = ClassLoader.getSystemResource("sun/plugin/usability/dukeWave.gif");
                    return new ImageIcon(uRL);
                }
            });
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        confirmDialogTitle = ResourceHandler.getMessage("usability.confirmDialogTitle");
        inputDialogTitle = ResourceHandler.getMessage("usability.inputDialogTitle");
        messageDialogTitle = ResourceHandler.getMessage("usability.messageDialogTitle");
        exceptionDialogTitle = ResourceHandler.getMessage("usability.exceptionDialogTitle");
        optionDialogTitle = ResourceHandler.getMessage("usability.optionDialogTitle");
        aboutDialogTitle = ResourceHandler.getMessage("usability.aboutDialogTitle");
    }
}

