/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InvocationEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import javax.swing.JDialog;
import javax.swing.SwingUtilities;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.plugin.usability.PluginSysAction;
import sun.plugin.usability.PluginSysUtil;
import sun.security.action.GetPropertyAction;

public final class PluginSysUtil {
    private static EventQueue pluginEventQueue = null;
    private static ThreadGroup pluginThreadGroup = null;
    private static ClassLoader pluginSysClassLoader = null;

    public static synchronized ThreadGroup getPluginThreadGroup() {
        if (pluginThreadGroup == null) {
            pluginSysClassLoader = Thread.currentThread().getContextClassLoader();
            pluginThreadGroup = new ThreadGroup(Thread.currentThread().getThreadGroup(), "Plugin Thread Group");
            PluginSysUtil.createAppContext(pluginThreadGroup);
        }
        return pluginThreadGroup;
    }

    public static void invokeAndWait(Runnable runnable) throws InterruptedException, InvocationTargetException {
        if (EventQueue.isDispatchThread()) {
            throw new Error("Cannot call invokeAndWait from the event dispatcher thread");
        }
        class AWTInvocationLock {
            AWTInvocationLock() {
            }
        }
        AWTInvocationLock aWTInvocationLock = new AWTInvocationLock();
        InvocationEvent invocationEvent = new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable, aWTInvocationLock, true);
        AWTInvocationLock aWTInvocationLock2 = aWTInvocationLock;
        synchronized (aWTInvocationLock2) {
            pluginEventQueue.postEvent(invocationEvent);
            aWTInvocationLock.wait();
        }
        Exception exception = invocationEvent.getException();
        if (exception != null) {
            throw new InvocationTargetException(exception);
        }
    }

    public static void invokeLater(Runnable runnable) {
        pluginEventQueue.postEvent(new InvocationEvent((Object)Toolkit.getDefaultToolkit(), runnable));
    }

    public static Thread createPluginSysThread(Runnable runnable) {
        Thread thread = new Thread(pluginThreadGroup, runnable);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public static Thread createPluginSysThread(Runnable runnable, String string) {
        Thread thread = new Thread(pluginThreadGroup, runnable, string);
        thread.setContextClassLoader(pluginSysClassLoader);
        return thread;
    }

    public static Object execute(PluginSysAction pluginSysAction) throws Exception {
        if (Thread.currentThread().getThreadGroup().equals(pluginThreadGroup)) {
            return pluginSysAction.execute();
        }
        final SysExecutionThread sysExecutionThread = new SysExecutionThread(pluginSysAction);
        sysExecutionThread.setContextClassLoader(pluginSysClassLoader);
        if (SwingUtilities.isEventDispatchThread()) {
            Object object = sysExecutionThread.syncObject;
            synchronized (object) {
                DummyDialog dummyDialog;
                sysExecutionThread.theDummy = dummyDialog = new DummyDialog(null, true);
                dummyDialog.addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent windowEvent) {
                        sysExecutionThread.start();
                    }

                    public void windowClosing(WindowEvent windowEvent) {
                        dummyDialog.hide();
                    }
                });
                Rectangle rectangle = new Rectangle(new Point(0, 0), Toolkit.getDefaultToolkit().getScreenSize());
                if (!PluginSysUtil.isOnWindows()) {
                    ((Component)dummyDialog).setLocation(rectangle.x + rectangle.width / 2 - 50, rectangle.y + rectangle.height / 2);
                } else {
                    ((Component)dummyDialog).setLocation(-100, -100);
                }
                dummyDialog.setResizable(false);
                ((Window)dummyDialog).toBack();
                dummyDialog.show();
                try {
                    try {
                        sysExecutionThread.syncObject.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        Object var7_7 = null;
                        dummyDialog.hide();
                    }
                    Object var7_6 = null;
                    dummyDialog.hide();
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    dummyDialog.hide();
                    throw throwable;
                }
            }
        }
        sysExecutionThread.start();
        try {
            sysExecutionThread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        if (sysExecutionThread.exception != null) {
            throw sysExecutionThread.exception;
        }
        return sysExecutionThread.result;
    }

    private static void createAppContext(ThreadGroup threadGroup) {
        AppContextCreatorThread appContextCreatorThread = new AppContextCreatorThread(threadGroup);
        Object object = appContextCreatorThread.synObject;
        synchronized (object) {
            appContextCreatorThread.start();
            try {
                appContextCreatorThread.synObject.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static boolean isOnWindows() {
        String string = AccessController.doPrivileged(new GetPropertyAction("os.name"));
        return string.indexOf("Windows") != -1;
    }

    static class SysExecutionThread
    extends Thread {
        Exception exception = null;
        Object result = null;
        PluginSysAction action = null;
        Object syncObject = new Object();
        DummyDialog theDummy = null;

        public SysExecutionThread(PluginSysAction pluginSysAction) {
            super(pluginThreadGroup, "SysExecutionThead");
            this.action = pluginSysAction;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            Object object;
            try {
                try {
                    this.result = this.action.execute();
                }
                catch (Exception exception) {
                    this.exception = exception;
                    Object var3_2 = null;
                    if (this.theDummy != null) {
                        this.theDummy.secureHide();
                    }
                    Object object3 = this.syncObject;
                    synchronized (object3) {
                        this.syncObject.notifyAll();
                        return;
                    }
                }
                Object var3_1 = null;
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                object = this.syncObject;
            }
            catch (Throwable throwable) {
                Object var3_3 = null;
                if (this.theDummy != null) {
                    this.theDummy.secureHide();
                }
                Object object2 = this.syncObject;
                synchronized (object2) {
                    this.syncObject.notifyAll();
                    throw throwable;
                }
            }
            synchronized (object) {
                this.syncObject.notifyAll();
                return;
            }
        }
    }

    private static class AppContextCreatorThread
    extends Thread {
        Object synObject = new Object();

        public AppContextCreatorThread(ThreadGroup threadGroup) {
            super(threadGroup, "AppContext Creator Thread");
        }

        public void run() {
            Object object = this.synObject;
            synchronized (object) {
                AppContext appContext = SunToolkit.createNewAppContext();
                pluginEventQueue = (EventQueue)appContext.get(AppContext.EVENT_QUEUE_KEY);
                this.synObject.notifyAll();
            }
        }
    }

    private static class DummyDialog
    extends JDialog {
        private ThreadGroup _unsecureGroup = Thread.currentThread().getThreadGroup();

        DummyDialog(Frame frame, boolean bl) {
            super(frame, bl);
        }

        public void secureHide() {
            new Thread(this._unsecureGroup, new Runnable(this){
                private final /* synthetic */ DummyDialog this$0;
                {
                    this.this$0 = dummyDialog;
                }

                public void run() {
                    this.this$0.hide();
                }
            }).start();
        }
    }
}

