/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.ConsoleContext;
import com.ibm.storage.console.User;
import com.ibm.storage.console.adaptor.PageAdaptor;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.HashMap;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ActionItem {
    public static final String ROLE_ANY = "any";
    private HashMap m_parameters = new HashMap();
    private PageAdaptor m_pageAdaptor = null;
    private String m_name = null;
    private String m_pageAdaptorClassName = null;
    private String m_roles = "";
    private String m_title = "";
    private User m_user = null;
    private boolean m_transient = false;

    public ActionItem(String taskid, String adaptorclass, HashMap params) {
        this.m_name = taskid;
        this.m_pageAdaptorClassName = adaptorclass;
        this.m_parameters.putAll(params);
        this.m_transient = true;
    }

    protected ActionItem() {
    }

    public static ActionItem parseActionItem(Element ssgAction_Elem) {
        SsgLogUtilities.logEntrySSG("ActionItem", "parseActionItem(Element)", null);
        ActionItem actionItem = new ActionItem();
        try {
            NodeList nodes;
            actionItem.m_name = ssgAction_Elem.getAttribute("name");
            actionItem.m_pageAdaptorClassName = ssgAction_Elem.getAttribute("adaptor");
            String pageClassName = ssgAction_Elem.getAttribute("page");
            if (pageClassName != null && pageClassName.length() > 0) {
                actionItem.m_pageAdaptorClassName = "com.ibm.storage.console.adaptor.PsAdaptor";
                actionItem.addParameter("PsAdaptor.pageClassname", pageClassName);
            }
            actionItem.m_title = ssgAction_Elem.getFirstChild().getNodeValue().trim();
            actionItem.m_roles = ssgAction_Elem.getAttribute("role");
            actionItem.m_roles = actionItem.m_roles.toLowerCase();
            if (actionItem.m_name == null || actionItem.m_name.length() == 0) {
                SsgLogUtilities.throwUnexpectedError("ActionItem", "parseActionItem(Element)", "Invalid ssg:action definition found!", null);
            }
            if (actionItem.m_roles == null || actionItem.m_roles.length() == 0) {
                SsgLogUtilities.logSSG("ActionItem", "parseActionItem", "No role found in application.xml for ssg:action name=" + actionItem.m_name + ". Setting role='any'");
                actionItem.m_roles = ROLE_ANY;
            }
            int len = (nodes = ssgAction_Elem.getElementsByTagName("ssg:param")) != null ? nodes.getLength() : 0;
            int i = 0;
            while (i < len) {
                Element ssgParam_Elem = (Element)nodes.item(i);
                if (ssgParam_Elem.getParentNode() == ssgAction_Elem) {
                    actionItem.addParameter(ssgParam_Elem.getAttribute("name"), ssgParam_Elem.getAttribute("value"));
                }
                ++i;
            }
        }
        catch (Exception ex) {
            SsgLogUtilities.throwUnexpectedError("ActionItem", "parseActionItem(Element)", "Could not read ssg:action definition!", ex);
        }
        SsgLogUtilities.logExitSSG("ActionItem", "parseActionItem(Element)", actionItem.getName());
        return actionItem;
    }

    public final String getId() {
        return this.m_name;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getTitle() {
        return this.m_title;
    }

    public final boolean isTransient() {
        return this.m_transient;
    }

    public final void setUser(User user) {
        if (user == null) {
            SsgLogUtilities.throwUnexpectedError(this, "setUser(User)", "The user for action item is null!", null);
        }
        this.m_user = user;
    }

    public PageAdaptor getPageApator() {
        return this.m_pageAdaptor;
    }

    public void destroy() {
        SsgLogUtilities.logEntrySSG(this, "destroy()", null);
        if (this.m_pageAdaptor != null) {
            this.m_pageAdaptor.destroy();
            this.m_pageAdaptor = null;
        }
        SsgLogUtilities.logExitSSG(this, "destroy()", null);
    }

    public boolean hasPermission(int role) {
        if (this.m_roles.indexOf(ROLE_ANY) != -1) {
            return true;
        }
        String rolename = User.getRoleName(role);
        return this.m_roles.indexOf(rolename = rolename.toLowerCase()) != -1;
    }

    public void render(ConsoleContext consoleContext) {
        SsgLogUtilities.logEntrySSG(this, "render(ConsoleContext)", null);
        this.getPageAdaptor(consoleContext).render(consoleContext);
        SsgLogUtilities.logExitSSG(this, "render(ConsoleContext)", null);
    }

    protected final User getUser() {
        return this.m_user;
    }

    private PageAdaptor getPageAdaptor(ConsoleContext consoleContext) {
        SsgLogUtilities.logEntrySSG(this, "getPageAdaptor(ConsoleContext)", null);
        if (this.m_pageAdaptor == null) {
            this.m_pageAdaptor = PageAdaptor.createPageAdaptor(this.m_pageAdaptorClassName);
            this.m_pageAdaptor.setUser(this.m_user);
            this.m_pageAdaptor.setActionItem(this);
            this.m_pageAdaptor.addParameters(this.m_parameters);
            this.m_pageAdaptor.addParameters(this.m_user.getConsoleParameters());
            this.m_pageAdaptor.init(consoleContext);
        }
        SsgLogUtilities.logExitSSG(this, "getPageAdaptor(ConsoleContext)", this.m_pageAdaptor.toString());
        return this.m_pageAdaptor;
    }

    private String addParameter(String name, String value) {
        return this.m_parameters.put(name, value);
    }
}

