/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.ActionGroup;
import com.ibm.storage.console.ActionItem;
import com.ibm.storage.console.ConsoleContext;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.User;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Application {
    public static final String APP_NAME = "name";
    public static final String APP_ROOT_CONTEXT = "root_context";
    public static final String APP_AUTH_CLASS = "authenticate_class";
    public static final String APP_ROLE_CLASS = "role_class";
    public static final String APP_REDIRECT_MANAGER = "redirect_class";
    public static final String APP_RESOURCE = "resource";
    public static final String APP_RESOURCE_MESSAGE = "resource_message";
    public static final String APP_RESOURCE_XML = "resource_xml";
    public static final String APP_CIMOM_MANAGER = "cimom_class";
    public static final String APP_HTTPD_MANAGER = "httpd_class";
    public static final String APP_CONSOLE_MANAGER = "console_class";
    private HashMap m_actionItems = new HashMap();
    private String m_appId = null;
    private String m_currentActionId = null;
    private String m_description = "";
    private String m_name = null;
    private String m_title = null;
    private User m_user = null;
    private Vector m_actionGroups = new Vector();

    public Application(Document descriptionDoc) {
        this.processDescriptionDoc(descriptionDoc);
    }

    protected Application() {
    }

    public final Vector getActionGroups() {
        return this.m_actionGroups;
    }

    public final String getAppId() {
        return this.m_appId;
    }

    public final String getDescription() {
        return this.m_description;
    }

    public final String getName() {
        return this.m_name;
    }

    public final String getTitle() {
        return this.m_title;
    }

    public ActionItem[] getActionItems() {
        if (this.m_actionItems.size() == 0) {
            SsgLogUtilities.throwUnexpectedError(this, "getActionItems()", "no action is definied for the application " + this.m_name + "!", null);
        }
        return this.m_actionItems.values().toArray(new ActionItem[0]);
    }

    public void setUser(User user) {
        if (user == null) {
            SsgLogUtilities.throwUnexpectedError(this, "setUser(User)", "user for application is null!", null);
        }
        this.m_user = user;
        Iterator it = this.m_actionItems.values().iterator();
        while (it.hasNext()) {
            ((ActionItem)it.next()).setUser(this.m_user);
        }
    }

    public final User getUser() {
        return this.m_user;
    }

    public ActionItem getActionItem(String actionItemId) {
        return (ActionItem)this.m_actionItems.get(actionItemId);
    }

    public String getCurrentActionItemId() {
        return this.m_currentActionId;
    }

    public void destroy() {
        Iterator it = this.m_actionItems.keySet().iterator();
        while (it.hasNext()) {
            this.getActionItem((String)it.next()).destroy();
        }
    }

    public void destroyTask(String actionid) {
        SsgLogUtilities.logEntrySSG(this, "destroyTask()", null);
        ActionItem task = this.getActionItem(actionid);
        if (task == null) {
            return;
        }
        if (task.isTransient()) {
            this.m_actionItems.remove(actionid);
        }
        task.destroy();
        SsgLogUtilities.logExitSSG(this, "destroyTask()", null);
    }

    public void render(ConsoleContext consoleContext) throws SsgConsoleException {
        SsgLogUtilities.logEntrySSG(this, "render()", null);
        String actionItemId = consoleContext.getHttpServletRequest().getParameter("Application.taskId");
        if (actionItemId == null) {
            actionItemId = this.m_currentActionId;
        } else {
            this.m_currentActionId = actionItemId;
        }
        ActionItem activeActionItem = this.getActionItem(actionItemId);
        String adaptor = consoleContext.getHttpServletRequest().getParameter("Application.adaptor");
        if (adaptor != null && activeActionItem == null) {
            HashMap<String, String> params = new HashMap<String, String>();
            Enumeration pnames = consoleContext.getHttpServletRequest().getParameterNames();
            while (pnames.hasMoreElements()) {
                String pname = (String)pnames.nextElement();
                if (!pname.startsWith("Application.")) continue;
                params.put(pname.substring("Application.".length()), consoleContext.getHttpServletRequest().getParameter(pname));
            }
            activeActionItem = new ActionItem(actionItemId, adaptor, params);
            activeActionItem.setUser(this.m_user);
            this.m_actionItems.put(actionItemId, activeActionItem);
        }
        if (activeActionItem != null) {
            activeActionItem.render(consoleContext);
        } else {
            HttpServletRequest request = consoleContext.getHttpServletRequest();
            HttpServletResponse response = consoleContext.getHttpServletResponse();
            User user = this.getUser();
            String id = user.getApplication().getCurrentActionItemId();
            if (id == null || id.length() == 0) {
                id = "temporary_error_task";
            }
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("PsAdaptor.pageClassname", "com.ibm.storage.console.adaptor.PsErrorPage");
            params.put("PsErrorPage.exception", new SsgConsoleException("COMMON_UNKNOWN_ERROR"));
            ActionItem errorAI = new ActionItem(id, "com.ibm.storage.console.adaptor.PsAdaptor", params);
            errorAI.setUser(user);
            errorAI.render(new ConsoleContext(request, response, consoleContext.getServletContext()));
            SsgLogUtilities.logExitSSG(this, "render", null);
        }
    }

    private void addAction(ActionItem actionItem) {
        this.m_actionItems.put(actionItem.getId(), actionItem);
    }

    private void parseActionGroup(Element ssgActionGroup_Elem, ActionGroup parent) {
        SsgLogUtilities.logEntrySSG(this, "parseActionGroup(Element,ActionGroup)", "elem=" + ssgActionGroup_Elem + ", parent=" + parent);
        ActionGroup newgroup = new ActionGroup(ssgActionGroup_Elem.getAttribute(APP_NAME), ssgActionGroup_Elem.getFirstChild().getNodeValue());
        if (parent == null) {
            this.m_actionGroups.add(newgroup);
        } else {
            parent.addNode(newgroup);
        }
        if (ssgActionGroup_Elem.getNodeName().equals("ssg:action")) {
            ActionItem ai = ActionItem.parseActionItem(ssgActionGroup_Elem);
            this.addAction(ai);
            newgroup.setActionItem(ai);
            return;
        }
        NodeList nodes = ssgActionGroup_Elem.getChildNodes();
        if (nodes == null) {
            SsgLogUtilities.throwUnexpectedError(this, "parseActionGroup(Element,ActionGroup)", "invalid application description: no actions!", null);
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Node subnode = nodes.item(i);
            if (subnode instanceof Element) {
                Element action_elem = (Element)subnode;
                this.parseActionGroup(action_elem, newgroup);
            }
            ++i;
        }
        SsgLogUtilities.logExitSSG(this, "parseActionGroup(Element,ActionGroup)", null);
    }

    private void parseActions(Element ssgActions_Elem) {
        SsgLogUtilities.logEntrySSG(this, "parseActions()", "");
        NodeList nodes = ssgActions_Elem.getChildNodes();
        if (nodes == null) {
            SsgLogUtilities.throwUnexpectedError(this, "parseActions(Element)", "invalid application description: no action groups!", null);
        }
        int i = 0;
        while (i < nodes.getLength()) {
            Element action_elem;
            Node subnode = nodes.item(i);
            if (subnode instanceof Element && ((action_elem = (Element)subnode).getNodeName().equals("ssg:group") || action_elem.getNodeName().equals("ssg:action"))) {
                this.parseActionGroup(action_elem, null);
            }
            ++i;
        }
        SsgLogUtilities.logExitSSG(this, "parseActions()", "nodes=" + nodes.getLength());
    }

    private void processDescriptionDoc(Document doc) {
        Element ssgApp_Elem = doc.getDocumentElement();
        this.m_name = this.m_appId = ssgApp_Elem.getAttribute(APP_NAME);
        Element ssgTitle_Elem = (Element)ssgApp_Elem.getElementsByTagName("ssg:title").item(0);
        this.m_title = ssgTitle_Elem.getFirstChild().getNodeValue();
        Element ssgDesc_Elem = (Element)ssgApp_Elem.getElementsByTagName("ssg:description").item(0);
        this.m_description = ssgDesc_Elem.getFirstChild().getNodeValue().trim();
        if (this.m_name == null || this.m_name.length() == 0 || this.m_title == null || this.m_title.length() == 0) {
            SsgLogUtilities.throwUnexpectedError(this, "processDescriptionDoc(Document)", "invalid application description!", null);
        }
        this.parseActions((Element)ssgApp_Elem.getElementsByTagName("ssg:portfolio").item(0));
    }
}

