/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class CimomManager {
    public static final String DEFAULT_NAMESPACE = "root/cimv2";
    public static final int DEFAULT_SSL_PORT = 5989;
    public static final int DEFAULT_PORT = 5988;
    private Properties m_properties = null;

    public String getHost() {
        String host = this.getPropValue("Host");
        if (host != null) {
            return host.trim();
        }
        return "localhost";
    }

    public String getNameSpace() {
        String ns = this.getPropValue("NameSpace");
        if (ns != null) {
            return ns.trim();
        }
        return DEFAULT_NAMESPACE;
    }

    public int getPort() {
        String port = this.getPropValue("Port");
        if (port != null) {
            return Integer.parseInt(port.trim());
        }
        return 5988;
    }

    public int getSslPort() {
        String sslport = this.getPropValue("SslPort");
        if (sslport != null) {
            return Integer.parseInt(sslport.trim());
        }
        return 5989;
    }

    public String getTrustStore() {
        String ts = this.getPropValue("TrustStore");
        if (ts != null) {
            return ts.trim();
        }
        return "truststore";
    }

    public String getTrustStorePassword() {
        String tp = this.getPropValue("TrustPassword");
        if (tp != null) {
            return tp.trim();
        }
        return "ibmstore";
    }

    public boolean sslEnabled() {
        String sslon = this.getPropValue("SslEnabled");
        if (sslon != null) {
            return sslon.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    private String getPropValue(String propname) {
        if (this.m_properties == null) {
            this.m_properties = new Properties();
            try {
                this.m_properties.load(new FileInputStream(new FileResource("cimom.properties").getFilename()));
            }
            catch (IOException ioex) {
                SsgLogUtilities.logUnexpectedError(this, "getPropValue", "Could not read cimom.properties", (Throwable)ioex);
                return null;
            }
        }
        return this.m_properties.getProperty(propname);
    }
}

