/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.RoleManager;
import com.ibm.storage.console.util.SsgLogUtilities;

public class DefaultRoleManager
implements RoleManager {
    public static final int ROLE_ADMINISTRATOR = 0;
    public static final int ROLE_OPERATOR = 1;
    public static final int ROLE_BACKUP = 2;
    public static final int ROLE_MONITOR = 3;
    public static final String[] ROLE_NAMES = new String[]{"administrator", "operator", "backup", "monitor"};

    public int getRoleFromName(String role) {
        role = role.toLowerCase();
        int i = 0;
        while (i < ROLE_NAMES.length) {
            if (ROLE_NAMES[i].equals(role)) {
                return i;
            }
            ++i;
        }
        SsgLogUtilities.throwUnexpectedError("DefaultRoleManager", "getRoleFromName(String)", "Invalid role: " + role, null);
        return -1;
    }

    public String getRoleName(int role) {
        if (role < 0 || role >= ROLE_NAMES.length) {
            SsgLogUtilities.throwUnexpectedError("DefaultRoleManager", "getRoleName(int)", "Attempt to get role name for an invalid role enumeration.", null);
        }
        return ROLE_NAMES[role];
    }

    public String[] getRoleNames() {
        return ROLE_NAMES;
    }
}

