/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.Resource;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.File;
import java.util.Locale;

public class FileResource
extends Resource {
    private File m_file = null;
    private String m_locator = null;

    public FileResource(String locator, Locale locale, int type) {
        this.setType(type);
        this.setLocale(locale);
        this.setLocator(locator);
    }

    public FileResource(String locator) {
        this.setType(2);
        this.setLocator(locator);
    }

    public File getFile() {
        return this.m_file;
    }

    public String getFilename() {
        return this.m_file.toString();
    }

    public String getLocator() {
        return this.m_locator;
    }

    public String toString() {
        String localeStr = this.getLocale() == null ? "(none)" : this.getLocale().toString();
        switch (this.getType()) {
            case 2: {
                return "<FileResource: " + this.m_locator + ", LOCALE_INDEPENDENT>";
            }
            case 0: {
                return "<FileResource: " + this.m_locator + ", GLOBALIZED with " + localeStr + ">";
            }
            case 1: {
                return "<FileResource: " + this.m_locator + ", LOCALIZED as " + localeStr + ">";
            }
        }
        return "<FileResource: " + this.m_locator + ", (unknown type)>";
    }

    private void setLocator(String locator) {
        this.m_locator = locator;
        if (this.getType() == 1) {
            locator = this.parseLocalizedLocator(locator);
        } else if (Resource.isLocatorLocalized(locator)) {
            SsgLogUtilities.throwUnexpectedError(this, "setLocator(String)", "Resource locator is localized but type is not Resource.LOCALIZED!", null);
        }
        StringBuffer sb = new StringBuffer(locator);
        if (File.separatorChar != '/') {
            int i = 0;
            while (i < sb.length()) {
                if (sb.charAt(i) == '/') {
                    sb.setCharAt(i, File.separatorChar);
                }
                ++i;
            }
        }
        this.m_file = new File(sb.toString());
        if (!this.m_file.isAbsolute()) {
            sb.insert(0, Console.getWebInfPath() + File.separatorChar);
            this.m_file = new File(sb.toString());
        }
    }
}

