/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Properties;

public class HttpdManager {
    private Properties m_properties = null;

    public int getPort() {
        String port = this.getPropValue("Port");
        if (port != null) {
            return Integer.parseInt(port.trim());
        }
        return 9999;
    }

    public int getSslPort() {
        String sslport = this.getPropValue("SslPort");
        if (sslport != null) {
            return Integer.parseInt(sslport.trim());
        }
        return 7979;
    }

    public String getTrustStore() {
        String ts = this.getPropValue("TrustStore");
        if (ts != null) {
            return ts.trim();
        }
        return "/opt/was/etc/DummyClientTrustFile.jks";
    }

    public String getTrustStorePassword() {
        String tp = this.getPropValue("TrustPassword");
        if (tp != null) {
            return tp.trim();
        }
        return "WebAS";
    }

    public boolean sslEnabled() {
        String sslon = this.getPropValue("SslEnabled");
        if (sslon != null) {
            return sslon.trim().equalsIgnoreCase("true");
        }
        return true;
    }

    private String getPropValue(String propname) {
        if (this.m_properties == null) {
            this.m_properties = new Properties();
            try {
                this.m_properties.load(new FileInputStream(new FileResource("httpd.properties").getFilename()));
            }
            catch (IOException ioex) {
                SsgLogUtilities.logUnexpectedError(this, "getPropValue", "Could not read httpd.properties", (Throwable)ioex);
                return null;
            }
        }
        return this.m_properties.getProperty(propname);
    }
}

