/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Locale;

public class ImageUrlResource
extends LocalUrlResource {
    public ImageUrlResource(String locator, Locale locale) {
        super(locator, locale, 1);
    }

    public ImageUrlResource(String locator) {
        super(locator);
    }

    protected void setLocator(String locator) {
        this.m_locator = locator;
        locator = this.getType() == 1 ? this.parseLocalizedLocator(locator) : "/images/" + locator;
        this.m_urlStr = locator;
    }

    protected String parseLocalizedLocator(String locator) {
        String locale;
        String country = locale = this.getLocale().toString();
        int sep = locale.indexOf(95);
        if (sep != -1) {
            country = country.substring(0, sep);
        }
        try {
            String webinfPath = Console.getWebInfPath();
            File appDir = new File(webinfPath).getParentFile();
            String appPath = appDir.getCanonicalPath();
            String imglocalePath = appPath + File.separatorChar + "images" + File.separatorChar + locale;
            if (new File(imglocalePath).exists()) {
                return "/images/" + locale + "/" + locator;
            }
            String imgcountryPath = appPath + File.separatorChar + "images" + File.separatorChar + country;
            if (new File(imgcountryPath).exists()) {
                return "/images/" + country + "/" + locator;
            }
        }
        catch (IOException ioex) {
            SsgLogUtilities.logUnexpectedError(this, "parseLocalizedLocator()", "Could not parse local image directory: " + locator, null);
        }
        return "/images/en/" + locator;
    }
}

