/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.Resource;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Locale;

public class LocalUrlResource
extends Resource {
    public static final int INCLUDE_CONTEXT_PATH = 0;
    public static final int EXCLUDE_CONTEXT_PATH = 1;
    protected String m_locator = null;
    protected String m_urlStr = null;

    public LocalUrlResource(String locator, Locale locale, int type) {
        this.setLocale(locale);
        this.setType(type);
        this.setLocator(locator);
    }

    public LocalUrlResource(String locator) {
        this.setType(2);
        this.setLocator(locator);
    }

    public String getCssUrl() {
        return "url(" + this.getFilePart() + ")";
    }

    public String getFilePart() {
        return this.getFilePart(0);
    }

    public String getFilePart(int mode) {
        if (mode == 0) {
            if (!this.m_urlStr.startsWith("/")) {
                SsgLogUtilities.throwUnexpectedError(this, "getFilePart(int)", "Can't include context path for relative URLs!", null);
            }
            return Console.getAppAttributeValue("root_context") + this.m_urlStr;
        }
        if (mode == 1) {
            return this.m_urlStr;
        }
        SsgLogUtilities.throwUnexpectedError(this, "getFilePart(int)", "Unknown mode: " + mode + ".", null);
        return null;
    }

    public String toString() {
        String localeStr = this.getLocale() == null ? "(none)" : this.getLocale().toString();
        switch (this.getType()) {
            case 2: {
                return "<FileResource: " + this.m_locator + ", LOCALE_INDEPENDENT>";
            }
            case 0: {
                return "<FileResource: " + this.m_locator + ", GLOBALIZED with " + localeStr + ">";
            }
            case 1: {
                return "<FileResource: " + this.m_locator + ", LOCALIZED as " + localeStr + ">";
            }
        }
        return "<FileResource: " + this.m_locator + ", (unknown type)>";
    }

    protected void setLocator(String locator) {
        this.m_locator = locator;
        if (this.getType() == 1) {
            locator = this.parseLocalizedLocator(locator);
        } else if (Resource.isLocatorLocalized(locator)) {
            SsgLogUtilities.throwUnexpectedError(this, "setLocator(String)", "Resource locator is localized but resource type is not Resource.LOCALIZED!", null);
        }
        this.m_urlStr = locator;
    }
}

