/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.User;
import com.ibm.storage.console.UserManager;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.XmlUtilities;
import java.util.Arrays;
import java.util.Hashtable;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class LocalUserManager
extends UserManager {
    private final FileResource m_configurationResource = new FileResource("users.xml");
    private Document m_configurationDoc = null;

    public LocalUserManager() throws SsgConsoleException {
        this.readConfigurationFile();
    }

    public User authenticateUser(String username, String password) throws SsgConsoleException {
        Hashtable userAttributes;
        byte[] encodedPassword = password.getBytes();
        if (this.m_configurationDoc == null) {
            SsgLogUtilities.throwUnexpectedError(this, "authenticateUser(String,String)", "User authentication attempted but configuration document doesn't exist.", null);
        }
        if ((userAttributes = this.getUserAttributes(username)) == null) {
            SsgLogUtilities.throwError(this, "authenticateUser(String,String)", new SsgConsoleException("USER_DOESNT_EXIST"));
            return null;
        }
        byte[] targetEncodedPassword = ((String)userAttributes.get("password")).getBytes();
        if (Arrays.equals(encodedPassword, targetEncodedPassword)) {
            return this.createUserObject(username, password, userAttributes);
        }
        SsgLogUtilities.throwError(this, "authenticateUser(String,String)", new SsgConsoleException("USER_AUTHENTICATION_FAILED"));
        return null;
    }

    private Hashtable getUserAttributes(String username) {
        NodeList userNodes = this.m_configurationDoc.getDocumentElement().getElementsByTagName("itpc:user");
        int i = 0;
        while (i < userNodes.getLength()) {
            Node userNode = userNodes.item(i);
            NamedNodeMap userAttrs = userNode.getAttributes();
            if (userAttrs.getNamedItem("name").getNodeValue().equals(username)) {
                Hashtable<String, String> attributes = new Hashtable<String, String>();
                int j = 0;
                while (j < userAttrs.getLength()) {
                    attributes.put(userAttrs.item(j).getNodeName(), userAttrs.item(j).getNodeValue());
                    ++j;
                }
                return attributes;
            }
            ++i;
        }
        return null;
    }

    private User createUserObject(String username, String password, Hashtable userAttributes) throws SsgConsoleException {
        int role = User.getRoleFromName((String)userAttributes.get("role"));
        User user = new User(this, username, password, role, null);
        return user;
    }

    private void readConfigurationFile() throws SsgConsoleException {
        if (this.m_configurationResource.getFile().exists()) {
            this.m_configurationDoc = XmlUtilities.parseXml(this.m_configurationResource);
        }
    }
}

