/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.Resource;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;

public class RemoteUrlResource
extends Resource {
    private String m_locator = null;
    private URL m_url = null;

    public RemoteUrlResource(String locator, Locale locale, int type) {
        this.setLocale(locale);
        this.setType(type);
        this.setLocator(locator);
    }

    public RemoteUrlResource(String locator) {
        this.setType(2);
        this.setLocator(locator);
    }

    public String getLocator() {
        return this.m_locator;
    }

    public URL getUrl() {
        return this.m_url;
    }

    public String toString() {
        String localeStr = this.getLocale() == null ? "(none)" : this.getLocale().toString();
        switch (this.getType()) {
            case 2: {
                return "<FileResource: " + this.m_locator + ", LOCALE_INDEPENDENT>";
            }
            case 0: {
                return "<FileResource: " + this.m_locator + ", GLOBALIZED with " + localeStr + ">";
            }
            case 1: {
                return "<FileResource: " + this.m_locator + ", LOCALIZED as " + localeStr + ">";
            }
        }
        return "<FileResource: " + this.m_locator + ", (unknown type)>";
    }

    private void setLocator(String locator) {
        this.m_locator = locator;
        if (this.getType() == 1) {
            locator = this.parseLocalizedLocator(locator);
        } else if (Resource.isLocatorLocalized(locator)) {
            SsgLogUtilities.throwUnexpectedError(this, "setLocator(String)", "Resource locator is localized but resource type is not Resource.LOCALIZED!", null);
        }
        try {
            this.m_url = new URL(locator);
        }
        catch (MalformedURLException mue) {
            SsgLogUtilities.throwUnexpectedError(this, "setLocator(String)", "Invalid resource locator: " + locator + ".", null);
        }
    }
}

