/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Locale;

public abstract class Resource {
    public static final int GLOBALIZED = 0;
    public static final int LOCALIZED = 1;
    public static final int LOCALE_INDEPENDENT = 2;
    protected Locale m_locale = null;
    protected int m_type = -1;

    public Locale getLocale() {
        if (this.m_type == -1) {
            SsgLogUtilities.throwUnexpectedError(this, "getLocale()", "Resource type has not been set!", null);
        }
        return this.m_locale;
    }

    public int getType() {
        return this.m_type;
    }

    public abstract String toString();

    protected void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    protected static boolean isLocatorLocalized(String locator) {
        return locator.indexOf("${locale}") != -1;
    }

    protected void setType(int type) {
        if (type != 0 && type != 1 && type != 2) {
            SsgLogUtilities.throwUnexpectedError(this, "setType(int)", "Invalid resource type: " + type + ".", null);
        }
        this.m_type = type;
    }

    protected String parseLocalizedLocator(String locator) {
        StringBuffer sb = new StringBuffer(locator);
        int pos = 1;
        while ((pos = sb.toString().indexOf("${locale}", 0)) != -1) {
            sb.replace(pos, pos + 9, this.getLocale().toString());
        }
        return sb.toString();
    }
}

