/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.cim.CIMException;
import com.ibm.storage.common.IBMErrorString;
import com.ibm.storage.common.cli.CLIErrorString;
import com.ibm.storage.common.meta.client.CIMDeviceErrorInfo;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Locale;

public class SsgConsoleException
extends Exception {
    protected Exception m_rootCause = null;
    protected IBMErrorString m_ibmError = null;
    protected String m_errorKey;
    protected Object[] m_arguments = null;

    public SsgConsoleException(IBMErrorString ibmerr) {
        this.m_ibmError = ibmerr;
    }

    public SsgConsoleException(String errorkey) {
        this.m_errorKey = errorkey;
    }

    public SsgConsoleException(String errorkey, Exception rootCause) {
        this.m_errorKey = errorkey;
        this.m_rootCause = rootCause;
    }

    public SsgConsoleException(String errorkey, Object[] inserts) {
        this.m_errorKey = errorkey;
        this.m_arguments = inserts;
    }

    public SsgConsoleException(String errorkey, Exception rootCause, Object[] inserts) {
        this.m_errorKey = errorkey;
        this.m_rootCause = rootCause;
        this.m_arguments = inserts;
    }

    public SsgConsoleException(String errorkey, Object arg1) {
        this.m_errorKey = errorkey;
        this.m_arguments = new Object[1];
        this.m_arguments[0] = arg1;
    }

    public SsgConsoleException(String errorkey, Exception rootCause, Object arg1) {
        this.m_errorKey = errorkey;
        this.m_rootCause = rootCause;
        this.m_arguments = new Object[1];
        this.m_arguments[0] = arg1;
    }

    public SsgConsoleException(String errorkey, Object arg1, Object arg2) {
        this.m_errorKey = errorkey;
        this.m_arguments = new Object[2];
        this.m_arguments[0] = arg1;
        this.m_arguments[1] = arg2;
    }

    public SsgConsoleException(String errorkey, Exception rootCause, Object arg1, Object arg2) {
        this.m_errorKey = errorkey;
        this.m_rootCause = rootCause;
        this.m_arguments = new Object[2];
        this.m_arguments[0] = arg1;
        this.m_arguments[1] = arg2;
    }

    public SsgConsoleException(String errorkey, Object arg1, Object arg2, Object arg3) {
        this.m_errorKey = errorkey;
        this.m_arguments = new Object[3];
        this.m_arguments[0] = arg1;
        this.m_arguments[1] = arg2;
        this.m_arguments[2] = arg3;
    }

    public SsgConsoleException(String errorkey, Exception rootCause, Object arg1, Object arg2, Object arg3) {
        this.m_errorKey = errorkey;
        this.m_rootCause = rootCause;
        this.m_arguments = new Object[3];
        this.m_arguments[0] = arg1;
        this.m_arguments[1] = arg2;
        this.m_arguments[2] = arg3;
    }

    public final String getMessage() {
        return this.getMessage(Locale.getDefault());
    }

    public final String getMessageKey() {
        if (this.m_ibmError != null) {
            return this.m_ibmError.getID();
        }
        return this.m_errorKey;
    }

    public String getMessage(Locale locale) {
        if (this.m_ibmError != null) {
            return this.m_ibmError.getError();
        }
        SsgConsoleResource res = new SsgConsoleResource("com.ibm.storage.console.message.f2c_GuiFrameworkMessageResources_1tcpp9", locale);
        return res.getMessage(this.m_errorKey, this.m_arguments);
    }

    public String getMessageId() {
        if (this.m_ibmError != null) {
            return this.m_ibmError.getID();
        }
        SsgConsoleResource res = new SsgConsoleResource("com.ibm.storage.console.message.f2c_GuiFrameworkMessageResources_1tcpp9", Locale.getDefault());
        return res.getMessageId(this.m_errorKey);
    }

    public final void setRootCause(Exception rootCause) {
        this.m_rootCause = rootCause;
    }

    public final Exception getRootCause() {
        return this.m_rootCause;
    }

    public static SsgConsoleException getConsoleException(CIMException cimex) {
        return SsgConsoleException.getConsoleException(cimex, null, null);
    }

    public static SsgConsoleException getConsoleException(CIMException cimex, CIMMetaProvider metaprovider) {
        return SsgConsoleException.getConsoleException(cimex, metaprovider, null);
    }

    public static SsgConsoleException getConsoleException(CIMException cimex, Object[] inserts) {
        return SsgConsoleException.getConsoleException(cimex, null, inserts);
    }

    public static SsgConsoleException getConsoleException(CIMException cimex, CIMMetaProvider metaprovider, Object[] inserts) {
        SsgLogUtilities.log("SsgConsoleException", "getConsoleException(CIMException, CIMMetaProvider, Object[])", "CIMException: " + cimex.toString());
        int xnpcode = SsgConsoleException.getSsgId(cimex);
        if (metaprovider != null && xnpcode != -1) {
            CLIErrorString errobj = metaprovider.getSystemError(new CIMDeviceErrorInfo("", "", xnpcode), inserts);
            return new SsgConsoleException((IBMErrorString)errobj);
        }
        SsgLogUtilities.log("SsgConsoleException", "getConsoleException(CIMException, CIMMetaProvider, Object[])", "CIMException xmlCode: " + cimex.getXmlCode());
        switch (cimex.getXmlCode()) {
            case 2: {
                return new SsgConsoleException("CIM_ERROR_ACCESS_DENIED", (Exception)cimex, inserts);
            }
            case 118: {
                return new SsgConsoleException("CIM_ERROR_UNKNOWN_SERVER", (Exception)cimex, inserts);
            }
            case 116: {
                return new SsgConsoleException("CIM_ERROR_INVALID_TRUSTSTORE", (Exception)cimex, inserts);
            }
            case 119: {
                return new SsgConsoleException("CIM_ERROR_INVALID_CERTIFICATE", (Exception)cimex, inserts);
            }
        }
        return new SsgConsoleException("CIM_ERROR_FAILED", (Exception)cimex, inserts);
    }

    public static int getSsgId(CIMException cimex) {
        int codex;
        String xnpcodestr;
        int endex;
        String cimexDesc = "";
        Object[] params = cimex.getParams();
        if (params != null && params.length > 0) {
            cimexDesc = (String)params[0];
        }
        SsgLogUtilities.log("SsgConsoleException", "getSsgId(CIMException)", "CIMException description: " + cimexDesc);
        int xnpcode = -1;
        if (cimexDesc != null && cimexDesc.indexOf("SSG:") != -1 && (endex = (xnpcodestr = cimexDesc.substring((codex = cimexDesc.indexOf("SSG:")) + 4)).indexOf(")")) != -1) {
            xnpcodestr = xnpcodestr.substring(0, endex);
            try {
                xnpcode = Integer.parseInt(xnpcodestr);
            }
            catch (NumberFormatException nfex) {
                xnpcode = -1;
            }
        }
        SsgLogUtilities.log("SsgConsoleException", "getSsgId(CIMException)", "Retrieving error message for XNP errcode: " + xnpcode);
        return xnpcode;
    }
}

