/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import java.text.MessageFormat;
import java.util.Locale;
import java.util.ResourceBundle;

public class SsgConsoleResource {
    public static final String TYPE_CONSOLE_RESOURCE = "com.ibm.storage.console.message.ConsoleResources";
    public static final String TYPE_CONSOLE_MESSAGE_RESOURCE = "com.ibm.storage.console.message.f2c_GuiFrameworkMessageResources_1tcpp9";
    protected ResourceBundle m_messageBundle = null;
    protected String resourceName;

    public SsgConsoleResource(String restype, Locale locale) {
        this.setResourceName(restype);
        this.m_messageBundle = ResourceBundle.getBundle(restype, locale);
    }

    public String getMessage(String msgkey) {
        return this.formatMessage(msgkey, null);
    }

    public String getMessage(String msgkey, Object arg1) {
        Object[] arguments = new Object[]{arg1};
        return this.formatMessage(msgkey, arguments);
    }

    public String getMessage(String msgkey, Object arg1, Object arg2) {
        Object[] arguments = new Object[]{arg1, arg2};
        return this.formatMessage(msgkey, arguments);
    }

    public String getMessage(String msgkey, Object arg1, Object arg2, Object arg3) {
        Object[] arguments = new Object[]{arg1, arg2, arg3};
        return this.formatMessage(msgkey, arguments);
    }

    public String getMessage(String msgkey, Object[] arguments) {
        return this.formatMessage(msgkey, arguments);
    }

    public String getMessageId(String msgkey) {
        String msg = this.m_messageBundle.getString(msgkey);
        if (this.getResourceName().equals(TYPE_CONSOLE_MESSAGE_RESOURCE)) {
            msg = msg.trim();
            int sep = msg.indexOf(32);
            if (msg != null) {
                int st_index = 0;
                int end_index = msg.indexOf(32);
                if (st_index == 0 && end_index > 0) {
                    return msg.substring(st_index, end_index);
                }
            }
        } else if (msg != null) {
            int st_index = msg.indexOf(91);
            int end_index = msg.indexOf(93);
            if (st_index == 0 && end_index > 0) {
                return msg.substring(st_index + 1, end_index);
            }
        }
        return null;
    }

    protected String formatMessage(String msgkey, Object[] args) {
        String msg = this.m_messageBundle.getString(msgkey);
        if (this.getResourceName().equals(TYPE_CONSOLE_MESSAGE_RESOURCE)) {
            String msgid = this.getMessageId(msgkey);
            if (msgid != null) {
                msg = msg.substring(msgid.length() + 1);
            }
            msg = msg.trim();
            if (args == null) {
                return msg;
            }
            MessageFormat formatter = new MessageFormat("");
            formatter.applyPattern(msg);
            return formatter.format(args);
        }
        String msgid = this.getMessageId(msgkey);
        if (msgid != null) {
            msg = msg.substring(msgid.length() + 2);
        }
        if (args == null) {
            return msg;
        }
        MessageFormat formatter = new MessageFormat("");
        formatter.applyPattern(msg);
        return formatter.format(args);
    }

    public String getResourceName() {
        return this.resourceName;
    }

    public void setResourceName(String string) {
        this.resourceName = string;
    }
}

