/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console;

import com.ibm.cim.CIMClient;
import com.ibm.cim.CIMException;
import com.ibm.cim.CIMNameSpace;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.config.WclConfig;
import com.ibm.psw.wcl.core.config.WclFacadeConfig;
import com.ibm.storage.common.IBMErrorString;
import com.ibm.storage.common.meta.client.CIMDeviceErrorInfo;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.common.meta.client.MetaInitInfo;
import com.ibm.storage.console.Application;
import com.ibm.storage.console.ApplicationTemplate;
import com.ibm.storage.console.ConsoleManager;
import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.UserManager;
import com.ibm.storage.console.UserMap;
import com.ibm.storage.console.gui.MainPage;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.server.UID;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.servlet.http.HttpSession;
import org.w3c.dom.Document;

public class User {
    public static final int BROWSER_NS_MOZILLA = 0;
    public static final int BROWSER_IE = 1;
    public static final int BROWSER_OTHER = 2;
    public static final String LOGIN_TOKEN_NONE = "none";
    private Application m_application = null;
    private CIMMetaProvider m_metaProvider = null;
    private ConsoleManager m_consoleManager = null;
    private Date m_loginTime = null;
    private HashMap m_attributes = new HashMap();
    private HashMap m_consoleParameters = new HashMap();
    private HttpSession m_session = null;
    private Locale m_locale = new Locale("en", "US");
    private MainPage m_consolePage = null;
    private String m_appWclUrlBase = null;
    private String m_consoleWclUrlBase = null;
    private String m_httpUserAgent = "";
    private String m_id = "";
    private String m_loginToken = "none";
    private String m_password = null;
    private String m_username = null;
    private UserManager m_userManager = null;
    private WclFacade m_appWclFacade = null;
    private WclFacade m_consoleWclFacade = null;
    private boolean m_destroyed = false;
    private int m_browserMajorVersion = -1;
    private int m_browserMinorVersion = -1;
    private int m_browserType = 2;
    private int m_role = -1;

    public User(UserManager um, String username, String password, int role, Document configurationDocument) throws SsgConsoleException {
        if (um == null || username == null || password == null) {
            SsgLogUtilities.throwUnexpectedError(this, "User(UserManager,String,String,int,Document)", "Non-null values for um, username, password and configurationDocument must be provided to User objects at creation time.", null);
        }
        this.m_userManager = um;
        this.m_username = username;
        this.m_password = password;
        this.m_role = role;
        this.m_id = new UID().toString();
        SsgLogUtilities.log(this, "User(UserManager,String,String,int,Document)", "New user: " + username + ", Role=" + User.getRoleName(role) + ", ID=" + this.m_id);
    }

    public final String getAppWclUrlBase() {
        if (this.m_appWclUrlBase == null) {
            this.m_appWclUrlBase = new LocalUrlResource("/Application").getFilePart() + "/action/";
        }
        return this.m_appWclUrlBase;
    }

    public final int getBrowserMajorVersion() {
        return this.m_browserMajorVersion;
    }

    public final int getBrowserMinorVersion() {
        return this.m_browserMinorVersion;
    }

    public final int getBrowserType() {
        return this.m_browserType;
    }

    public final void setConsolePage(MainPage consolepage) {
        this.m_consolePage = consolepage;
    }

    public final MainPage getConsolePage() {
        return this.m_consolePage;
    }

    public final HashMap getConsoleParameters() {
        return this.m_consoleParameters;
    }

    public void setAttribute(String key, Object value) {
        this.m_attributes.put(key, value);
    }

    public Object getAttribute(String key) {
        return this.m_attributes.get(key);
    }

    public final WclFacade getConsoleWclFacade() {
        if (this.m_consoleWclFacade == null) {
            WclConfig wclConfig = new WclConfig(new FileResource("wcl-config.xml").getFilename());
            WclFacadeConfig facadeConfig = wclConfig.getWclFacadeConfig("ssg-facade");
            SsgPsUtilities.fixWclFacadeConfig(facadeConfig, "-Console-" + this.m_loginToken, "/Console/action/?WCLFacade.UserID=" + this.m_id + "&" + "Console.loginToken" + "=" + this.m_loginToken);
            this.m_consoleWclFacade = new WclFacade(facadeConfig);
        }
        return this.m_consoleWclFacade;
    }

    public final String getConsoleWclUrlBase() {
        if (this.m_consoleWclUrlBase == null) {
            this.m_consoleWclUrlBase = new LocalUrlResource("/Console").getFilePart() + "/action/";
        }
        return this.m_consoleWclUrlBase;
    }

    public String getID() {
        return this.m_id;
    }

    public static User getUser(HttpSession sess, String id) {
        UserMap users = (UserMap)sess.getAttribute("com.ibm.storage.console.Users");
        if (users != null) {
            return (User)users.get(id);
        }
        return null;
    }

    public final WclFacade getAppWclFacade() {
        if (this.m_appWclFacade == null) {
            WclConfig wclConfig = new WclConfig(new FileResource("wcl-config.xml").getFilename());
            WclFacadeConfig facadeConfig = wclConfig.getWclFacadeConfig("ssg-facade");
            SsgPsUtilities.fixWclFacadeConfig(facadeConfig, "-Application-" + this.m_loginToken, "/Application/action/?WCLFacade.UserID=" + this.m_id + "&" + "Console.loginToken" + "=" + this.m_loginToken);
            this.m_appWclFacade = new WclFacade(facadeConfig);
        }
        return this.m_appWclFacade;
    }

    public String getLocalUrl(String resourceLocator) {
        return new LocalUrlResource(resourceLocator, this.getLocale(), 1).getFilePart(0);
    }

    public final Locale setLocale(Locale locale) {
        if (this.m_locale == null) {
            SsgLogUtilities.throwUnexpectedError(this, "setLocale(Locale,boolean)", "A null locale was passed to User.setLocale()!", null);
        }
        Locale oldLocale = this.m_locale = locale;
        SsgLogUtilities.log(this, "setLocale( Locale )", "User locale: " + locale);
        return oldLocale;
    }

    public final void setName(String name) {
        this.m_username = name;
    }

    public final String getName() {
        return this.m_username;
    }

    public final void setPassword(String password) {
        this.m_password = password;
    }

    public final String getPassword() {
        return this.m_password;
    }

    public void setLocale(String localeStr) throws SsgConsoleException {
        StringTokenizer st = new StringTokenizer(localeStr, "_");
        if (st.countTokens() >= 3) {
            this.m_locale = new Locale(st.nextToken(), st.nextToken(), st.nextToken("").substring(1));
        } else if (st.countTokens() == 2) {
            this.m_locale = new Locale(st.nextToken(), st.nextToken());
        } else {
            SsgLogUtilities.throwError(this, "setLocale(String,boolean)", new SsgConsoleException("INVALID_LOCALE_STRING", localeStr));
        }
    }

    public final Locale getLocale() {
        return this.m_locale;
    }

    public String getRelativeUrl(String resourceLocator) {
        return new LocalUrlResource(resourceLocator, this.getLocale(), 1).getFilePart(1);
    }

    public final int setRole(int role) {
        int oldRole = this.m_role;
        this.m_role = role;
        return oldRole;
    }

    public final int getRole() {
        return this.m_role;
    }

    public static final int getRoleFromName(String role) {
        return Console.getRoleManager().getRoleFromName(role);
    }

    public static final String getRoleName(int role) {
        return Console.getRoleManager().getRoleName(role);
    }

    public Application getApplication() {
        if (this.m_application == null) {
            ApplicationTemplate appTemplate = new ApplicationTemplate(new FileResource("application.xml", this.getLocale(), 0));
            this.m_application = appTemplate.instantiate();
            this.m_application.setUser(this);
        }
        return this.m_application;
    }

    public CIMClient getCimClient() throws SsgConsoleException {
        CIMClient cimClient = null;
        try {
            cimClient = new CIMClient(User.getCimNameSpace(), this.getName(), this.getPassword());
        }
        catch (CIMException cimex) {
            SsgLogUtilities.throwError(this, "getCimClient", SsgConsoleException.getConsoleException(cimex));
        }
        return cimClient;
    }

    public static CIMNameSpace getCimNameSpace() {
        String cimhost = Console.getCimomManager().getHost();
        String cimnamespace = Console.getCimomManager().getNameSpace();
        CIMNameSpace clientNameSpace = new CIMNameSpace(cimhost, cimnamespace);
        if (Console.getCimomManager().sslEnabled()) {
            clientNameSpace.setSSL();
            clientNameSpace.setPort(Console.getCimomManager().getSslPort());
            clientNameSpace.setTrustStore(new FileResource(Console.getCimomManager().getTrustStore()).getFilename(), Console.getCimomManager().getTrustStorePassword());
        } else {
            clientNameSpace.setPort(Console.getCimomManager().getPort());
        }
        return clientNameSpace;
    }

    public CIMMetaProvider getCimMetaProvider() {
        block2: {
            if (this.m_metaProvider != null) break block2;
            URL fileurl = null;
            try {
                fileurl = new File(new FileResource("meta").getFilename()).toURL();
                this.m_metaProvider = new CIMMetaProvider(new MetaInitInfo(fileurl, this.getApplication().getName(), null), this.getLocale());
            }
            catch (MalformedURLException mex) {
                SsgLogUtilities.throwUnexpectedError(this, "getCimMetaProvider", "The file path is incorrect: " + fileurl, (Exception)mex);
            }
        }
        return this.m_metaProvider;
    }

    public IBMErrorString getIbmErrorString(String cimclass, String cimmethod, int retcode, Object[] args) {
        SsgLogUtilities.log(this, "getIbmErrorString(String, String,int, Object[])", "Retrieving error message for " + cimclass + "." + cimmethod + "." + retcode);
        return this.getCimMetaProvider().getSystemError(new CIMDeviceErrorInfo(cimclass, cimmethod, retcode), args);
    }

    public IBMErrorString getIbmErrorString(CIMException cimex, Object[] args) {
        SsgLogUtilities.logUnexpectedError(this, "getIbmErrorString", "CIMOM Exception:", (Throwable)cimex);
        SsgConsoleException conex = SsgConsoleException.getConsoleException(cimex, this.getCimMetaProvider(), args);
        return new IBMErrorString("[" + conex.getMessageId() + "]" + conex.getMessage(this.m_locale));
    }

    public void setLoginToken(String token) {
        SsgLogUtilities.log(this, "setLoginToken(String)", "User ID has been set to: " + token);
        this.m_id = this.m_loginToken = token;
    }

    public String getLoginToken() {
        return this.m_loginToken;
    }

    public String getRoleName() {
        return User.getRoleName(this.m_role);
    }

    public boolean isSessionVariableSet(String sessionvar) {
        Object sessionobj = this.getAttribute(sessionvar);
        boolean set = false;
        if (sessionobj != null) {
            set = (Boolean)sessionobj;
        }
        return set;
    }

    public void addConsoleParameter(String name, String value) {
        this.m_consoleParameters.put(name, value);
    }

    public void bindToSession(HttpSession sess) {
        this.m_session = sess;
        UserMap users = (UserMap)sess.getAttribute("com.ibm.storage.console.Users");
        if (users == null) {
            users = new UserMap();
            sess.setAttribute("com.ibm.storage.console.Users", (Object)users);
        }
        users.put(this.m_id, this);
        SsgLogUtilities.log(this, "bindToSession", "User (" + this.m_id + ") has been bound to the session (" + sess.getId() + ").");
    }

    public static void unbindAllFromSession(HttpSession sess) {
        SsgLogUtilities.logEntry("User", "unbindAllFromSession", null);
        try {
            UserMap users = (UserMap)sess.getAttribute("com.ibm.storage.console.Users");
            if (users != null) {
                SsgLogUtilities.log("User", "unbindAllFromSession", "user map " + users != null ? "not null; size = " + users.size() : "is null");
                Iterator it = users.keySet().iterator();
                while (it.hasNext()) {
                    User user = (User)users.get((String)it.next());
                    user.destroy();
                }
                users.clear();
                SsgLogUtilities.log("User", "unbindAllFromSession", "All users have been unbound from the session (" + sess.getId() + ").");
            }
            sess.removeAttribute("com.ibm.storage.console.Users");
        }
        catch (Exception e) {
            SsgLogUtilities.logUnexpectedError("User", "unbindAllFromSession", e.getMessage(), (Throwable)e);
        }
        SsgLogUtilities.logExit("User", "unbindAllFromSession", null);
    }

    public void destroy() {
        this.m_destroyed = true;
        if (this.m_consolePage != null) {
            this.m_consolePage.destroy();
            this.m_consolePage = null;
        }
        if (this.m_application != null) {
            this.m_application.destroy();
            this.m_application = null;
        }
        SsgLogUtilities.log(this, "destroy()", "User " + this.m_id + " has been destroyed.");
    }

    public void setConsoleManager(ConsoleManager cm) {
        this.m_consoleManager = cm;
    }

    public void setHttpUserAgent(String httpUserAgent) {
        this.m_httpUserAgent = httpUserAgent;
        if (!this.setBrowserIe() && !this.setBrowserNsMozilla()) {
            this.m_browserType = 2;
            this.m_browserMajorVersion = -1;
            this.m_browserMinorVersion = -1;
        }
    }

    public void setLoginTime(Date date) {
        this.m_loginTime = date;
    }

    public Date getLoginTime() {
        return this.m_loginTime;
    }

    public void closeTask(String taskid) {
        if (this.m_consolePage != null) {
            this.m_consolePage.closeTask(taskid);
        }
    }

    public final void destroyTask(String actionid) {
        if (this.m_application != null) {
            this.m_application.destroyTask(actionid);
        }
    }

    public ConsoleManager getConsoleManager() {
        return this.m_consoleManager;
    }

    public boolean destroyed() {
        return this.m_destroyed;
    }

    public void launchTask(String taskid) {
        if (this.m_consolePage != null) {
            this.m_consolePage.getWorkAreaPage().launchTask(taskid);
        }
    }

    public void launchTask(String taskid, String tasktitle, String adaptorclass, Properties params) {
        if (this.m_consolePage != null) {
            this.m_consolePage.launchTask(taskid, tasktitle, adaptorclass, params);
        }
    }

    public void removeAttribute(String key) {
        this.m_attributes.remove(key);
    }

    public void unbindFromSession() {
        if (this.m_session != null) {
            UserMap users = (UserMap)this.m_session.getAttribute("com.ibm.storage.console.Users");
            if (users != null) {
                users.remove(this.m_id);
            }
            SsgLogUtilities.log(this, "unbindFromSession", "User (" + this.m_id + ") has been unbound from the session (" + this.m_session.getId() + ").");
        }
        this.destroy();
    }

    private boolean setBrowserIe() {
        block6: {
            int semicolon;
            int msie = this.m_httpUserAgent.indexOf("MSIE");
            if (msie == -1) {
                return false;
            }
            this.m_browserType = 1;
            int period = this.m_httpUserAgent.indexOf(".", msie);
            this.m_browserMajorVersion = -1;
            this.m_browserMinorVersion = -1;
            if (period == -1) break block6;
            String majorVersion = this.m_httpUserAgent.substring(msie + 5, period);
            try {
                this.m_browserMajorVersion = Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException nfe) {
                this.m_browserMajorVersion = -1;
            }
            if (this.m_browserMajorVersion != -1 && (semicolon = this.m_httpUserAgent.indexOf(";", period)) != -1) {
                String minorVersion = this.m_httpUserAgent.substring(period + 1, semicolon);
                try {
                    this.m_browserMinorVersion = Integer.parseInt(minorVersion);
                }
                catch (NumberFormatException nfe) {
                    this.m_browserMinorVersion = -1;
                }
            }
        }
        return true;
    }

    private boolean setBrowserNsMozilla() {
        block8: {
            if (!this.m_httpUserAgent.startsWith("Mozilla/")) {
                return false;
            }
            if (this.m_httpUserAgent.indexOf("compatible") != -1) {
                return false;
            }
            if (this.m_httpUserAgent.indexOf("MSIE") != -1) {
                return false;
            }
            this.m_browserType = 0;
            this.m_browserMajorVersion = -1;
            this.m_browserMinorVersion = -1;
            int slash = this.m_httpUserAgent.indexOf("/");
            int period = this.m_httpUserAgent.indexOf(".", slash);
            if (period == -1) break block8;
            String majorVersion = this.m_httpUserAgent.substring(slash + 1, period);
            try {
                this.m_browserMajorVersion = Integer.parseInt(majorVersion);
            }
            catch (NumberFormatException nfe) {
                this.m_browserMajorVersion = -1;
            }
            int space = this.m_httpUserAgent.indexOf(" ", period);
            if (space != -1) {
                String minorVersion = this.m_httpUserAgent.substring(period + 1, space);
                try {
                    this.m_browserMinorVersion = Integer.parseInt(minorVersion);
                }
                catch (NumberFormatException nfe) {
                    this.m_browserMinorVersion = -1;
                }
            }
        }
        return true;
    }
}

