/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.storage.console.ActionItem;
import com.ibm.storage.console.ConsoleContext;
import com.ibm.storage.console.User;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.HashMap;

public abstract class PageAdaptor {
    private ActionItem m_actionItem = null;
    private HashMap m_parameters = new HashMap();
    private User m_user = null;

    protected PageAdaptor() {
    }

    public static PageAdaptor createPageAdaptor(String pageAdaptorClassName) {
        SsgLogUtilities.logEntrySSG("PageAdaptor", "createPageAdaptor(String)", pageAdaptorClassName);
        PageAdaptor pa = null;
        try {
            Class<?> paClass = Class.forName(pageAdaptorClassName);
            pa = (PageAdaptor)paClass.newInstance();
        }
        catch (ClassNotFoundException cex) {
            SsgLogUtilities.throwUnexpectedError("PageAdaptor", "createPageAdaptor(String)", "could not find the page adaptor " + pageAdaptorClassName, (Exception)cex);
        }
        catch (Exception ex) {
            SsgLogUtilities.throwUnexpectedError("PageAdaptor", "createPageAdaptor(String)", "could not load the page adaptor " + pageAdaptorClassName, ex);
        }
        SsgLogUtilities.logExitSSG("PageAdaptor", "createPageAdaptor(String)", pa.getActionName());
        return pa;
    }

    public final void setActionItem(ActionItem actionItem) {
        this.m_actionItem = actionItem;
    }

    public final void setUser(User user) {
        this.m_user = user;
    }

    public final void addParameters(HashMap params) {
        this.m_parameters.putAll(params);
    }

    public void destroy() {
    }

    public void init(ConsoleContext consoleContext) {
    }

    public void render(ConsoleContext consoleContext) {
        SsgLogUtilities.throwUnexpectedError(this, "render", "PageAdaptor's render method should never be called", null);
    }

    protected final ActionItem getActionItem() {
        return this.m_actionItem;
    }

    public final String getActionName() {
        if (this.m_actionItem != null) {
            return this.m_actionItem.getName();
        }
        return "";
    }

    public final String getActionTitle() {
        if (this.m_actionItem != null) {
            return this.m_actionItem.getTitle();
        }
        return "";
    }

    protected String setParameter(String key, String value) {
        return this.m_parameters.put(key, value);
    }

    protected String getParameter(String key) {
        return (String)this.m_parameters.get(key);
    }

    public final User getUser() {
        return this.m_user;
    }

    public HashMap getParameters() {
        return this.m_parameters;
    }
}

