/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.storage.console.ConsoleContext;
import com.ibm.storage.console.adaptor.PsWclAdaptor;
import com.ibm.storage.console.adaptor.SsgPsPage;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PsAdaptor
extends PsWclAdaptor {
    public static final String CLASSNAME = "com.ibm.storage.console.adaptor.PsAdaptor";
    public static final String PAGE_CLASSNAME_TAG = "PsAdaptor.pageClassname";
    private Hashtable m_orphanPages = new Hashtable();
    private Hashtable m_pages = new Hashtable();
    private RenderingContext m_rc = null;
    private SsgPsPage m_currentPage = null;

    public synchronized SsgPsPage getPage(String classname) {
        SsgLogUtilities.logEntry(this, "getPage", classname);
        SsgPsPage page = null;
        page = (SsgPsPage)this.m_pages.get(classname);
        if (page == null) {
            try {
                Class<?> c = Class.forName(classname);
                page = (SsgPsPage)c.newInstance();
                page.setUser(this.getUser());
                page.setPsAdaptor(this);
                page.setTaskId(this.getActionName());
                page.setParameters(this.getParameters());
                page.setRenderingContext(this.m_rc);
                String browser = this.m_rc.getDeviceContext().getBrowserVendor();
                if (browser.equals("Opera")) {
                    page.setOnLoad("top.refreshConsole();");
                    page.setOnUnload("top.refreshConsole();");
                }
                this.m_pages.put(classname, page);
                page.init();
            }
            catch (Exception e) {
                SsgLogUtilities.throwUnexpectedError(this, "renderWclPage(RenderingContext)", "Unable to dynamically load page class \"" + classname + "\".", e);
            }
        }
        SsgLogUtilities.logExit(this, "getPage", null);
        return page;
    }

    public void destroy() {
        SsgLogUtilities.logEntry(this, "destroy", null);
        super.destroy();
        Enumeration e = this.m_pages.elements();
        while (e.hasMoreElements()) {
            SsgPsPage page = (SsgPsPage)e.nextElement();
            if (page == null) continue;
            page.destroy();
            page = null;
        }
        this.m_pages = null;
        Enumeration e2 = this.m_orphanPages.elements();
        while (e2.hasMoreElements()) {
            SsgPsPage page = (SsgPsPage)e2.nextElement();
            if (page == null) continue;
            page.destroy();
            Object var3_3 = null;
        }
        this.m_orphanPages = null;
        this.m_rc = null;
        this.m_currentPage = null;
        SsgLogUtilities.logExit(this, "destroy", "PsAdaptor was destroyed!");
    }

    public synchronized SsgPsPage findPage(String classname) {
        return (SsgPsPage)this.m_pages.get(classname);
    }

    public void render(ConsoleContext consoleContext) {
        try {
            super.render(consoleContext);
        }
        catch (Exception ex) {
            HttpServletResponse response = consoleContext.getHttpServletResponse();
            HttpServletRequest request = consoleContext.getHttpServletRequest();
            ServletContext scontext = consoleContext.getServletContext();
            WclFacade wclFacade = this.getUser().getAppWclFacade();
            RenderingContext rc = wclFacade.createRenderingContext(request, response, scontext);
            TriggerContext tc = wclFacade.createTriggerContext(request, scontext);
            SsgPsPage errpage = this.getPage("com.ibm.storage.console.adaptor.PsErrorPage");
            this.showPage(errpage);
            tc.setRedirectPath(errpage.getURL((AContext)tc));
            try {
                SsgPsUtilities.sendPageToResponse(rc, this.getCurrentPage(), null);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (RendererException e) {
                e.printStackTrace();
            }
            SsgLogUtilities.logExit(this, "switchPage", null);
        }
    }

    public void renderWclPage(RenderingContext rc) {
        SsgLogUtilities.logEntry(this, "renderWclPage", null);
        this.m_rc = rc;
        if (this.m_currentPage == null) {
            SsgLogUtilities.log(this, "renderWclPage", "m_currentPage == null");
            String pageClassname = this.getParameter(PAGE_CLASSNAME_TAG);
            if (pageClassname == null || pageClassname.equals("")) {
                pageClassname = "com.ibm.storage.console.adaptor.PsErrorPage";
            } else {
                SsgPsPage page = this.getPage(pageClassname);
                this.showPage(page);
            }
        } else {
            SsgLogUtilities.log(this, "renderWclPage", "m_currentPage != null");
            this.showPage(this.m_currentPage);
        }
        SsgLogUtilities.logExit(this, "renderWclPage", null);
    }

    public synchronized void setPage(SsgPsPage page) {
        SsgLogUtilities.logEntry(this, "setPage", page.getClass().getName());
        if (page != null) {
            this.setCurrentPage(page);
            page.setHelp();
            this.m_currentPage = page;
        }
        SsgLogUtilities.logExit(this, "setPage", page.getClass().getName());
    }

    public synchronized SsgPsPage getPageByClassName(String classname) {
        SsgLogUtilities.logEntry(this, "isPageCreated", classname);
        return (SsgPsPage)this.m_pages.get(classname);
    }

    public synchronized void showPage(SsgPsPage page) {
        SsgLogUtilities.logEntry(this, "showPage", page.getClass().getName());
        if (page != null) {
            page.refresh();
            this.setCurrentPage(page);
            page.setHelp();
            this.m_currentPage = page;
        }
        SsgLogUtilities.logExit(this, "showPage", null);
    }

    public synchronized void uncachePage(String pageclassname) {
        SsgLogUtilities.logEntry(this, "uncachePage", pageclassname);
        SsgPsPage page = (SsgPsPage)this.m_pages.get(pageclassname);
        this.m_pages.remove(pageclassname);
        this.m_orphanPages.put(pageclassname, page);
        SsgLogUtilities.logExit(this, "uncachePage", null);
    }

    public synchronized void uncachePage(SsgPsPage page) {
        SsgLogUtilities.logEntry(this, "uncachePage", page.getClass().getName());
        Enumeration e = this.m_pages.keys();
        while (e.hasMoreElements()) {
            String classname = (String)e.nextElement();
            if (this.m_pages.get(classname) != page) continue;
            this.m_pages.remove(classname);
            break;
        }
        SsgLogUtilities.logExit(this, "uncachePage", null);
    }
}

