/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.psw.wcl.components.notebook.WNotebook;
import com.ibm.psw.wcl.components.notebook.WNotebookPage;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.form.WButton;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BasePageStyleInfo;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.adaptor.SsgPsNotebookTab;
import com.ibm.storage.console.adaptor.SsgPsPage;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

public abstract class PsNotebookPage
extends SsgPsPage {
    public static final String ACTION_OK = "button_action_ok";
    public static final String ACTION_APPLY = "button_action_apply";
    private static final String ACTION_CANCEL = "button_action_cancel";
    private Hashtable m_notebookTabs = new Hashtable();
    private WNotebook m_notebook = null;

    public void setCloseOnly() {
        WButton okButton = (WButton)this.getNotebook().getInputComponent(ACTION_OK);
        WButton applyButton = (WButton)this.getNotebook().getInputComponent(ACTION_APPLY);
        WButton cancelButton = (WButton)this.getNotebook().getInputComponent(ACTION_CANCEL);
        okButton.setVisible(false);
        applyButton.setVisible(false);
        SsgConsoleResource msgutil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.getUser().getLocale());
        cancelButton.setText(msgutil.getMessage("COMMON_BUTTON_CLOSE"));
    }

    public void setHelp() {
        SsgLogUtilities.logEntry(this, "setHelp()", null);
        SsgPsNotebookTab curtab = (SsgPsNotebookTab)this.m_notebook.getCurrentPage();
        this.setHelp(((Object)((Object)curtab)).getClass().getName());
        SsgLogUtilities.logExit(this, "setHelp()", null);
    }

    public final WNotebook getNotebook() {
        return this.m_notebook;
    }

    public void setReadonly() {
        WButton okButton = (WButton)this.getNotebook().getInputComponent(ACTION_OK);
        WButton applyButton = (WButton)this.getNotebook().getInputComponent(ACTION_APPLY);
        okButton.setEnabled(false);
        applyButton.setEnabled(false);
    }

    public void commandPerformed(CommandEvent ce) {
        SsgLogUtilities.logEntry(this, "commandPerformed", null);
        TriggerContext tc = ce.getTriggerContext();
        Object source = ce.getSource();
        SsgLogUtilities.log(this, "commandPerformed", "Source class: " + source.getClass().getName());
        if (source instanceof WNotebook) {
            String action = ce.getCommandName();
            SsgLogUtilities.log(this, "commandPerformed", "Action: " + action);
            if (action != null) {
                if (action.equals(ACTION_OK)) {
                    if (this.applyNotebook()) {
                        this.destroy();
                        if (this.getParentPage() != null) {
                            this.switchPage(this.getParentPage(), tc);
                        } else {
                            this.closeTask(this.getTaskId());
                        }
                    }
                } else if (action.equals(ACTION_APPLY)) {
                    this.applyNotebook();
                } else if (action.equals(ACTION_CANCEL)) {
                    this.destroy();
                    if (this.getParentPage() != null) {
                        this.switchPage(this.getParentPage(), tc);
                    } else {
                        this.closeTask(this.getTaskId());
                    }
                }
            }
        }
        SsgLogUtilities.logExit(this, "commandPerformed", null);
    }

    public void destroy() {
        SsgLogUtilities.logEntry(this, "destroy", null);
        super.gc_destroy();
        SsgLogUtilities.logExit(this, "destroy", null);
    }

    public SsgPsNotebookTab findTab(String tabclassname) {
        return (SsgPsNotebookTab)((Object)this.m_notebookTabs.get(tabclassname));
    }

    public void init() {
        BasePageStyleInfo pageStyle = new BasePageStyleInfo();
        pageStyle.setStyleValue("page1", "margin-left", (Object)"0px");
        pageStyle.setStyleValue("page1", "margin-top", (Object)"0px");
        this.setStyleInfo((AStyleInfo)pageStyle);
        this.createNotebook();
        super.init();
    }

    public void propertyChange(PropertyChangeEvent e) {
        SsgLogUtilities.logEntry(this, "propertyChange", null);
        String prop = e.getPropertyName();
        if (prop.equals("pageChanged")) {
            SsgPsNotebookTab tab = (SsgPsNotebookTab)this.m_notebook.getCurrentPage();
            tab.refresh();
            this.setHelp();
        }
        SsgLogUtilities.logExit(this, "propertyChange", null);
    }

    public void refresh() {
        SsgLogUtilities.logEntry(this, "refresh()", null);
        SsgPsNotebookTab curtab = (SsgPsNotebookTab)this.m_notebook.getCurrentPage();
        curtab.refresh();
        SsgLogUtilities.logExit(this, "refresh()", null);
    }

    protected final synchronized SsgPsNotebookTab getTab(String tabclassname) {
        SsgPsNotebookTab tab;
        block2: {
            tab = null;
            tab = (SsgPsNotebookTab)((Object)this.m_notebookTabs.get(tabclassname));
            if (tab != null) break block2;
            try {
                Class<?> c = Class.forName(tabclassname);
                tab = (SsgPsNotebookTab)((Object)c.newInstance());
                tab.setUser(this.getUser());
                tab.setPage(this);
                this.m_notebookTabs.put(tabclassname, tab);
                tab.init();
            }
            catch (Exception e) {
                SsgLogUtilities.throwUnexpectedError(this, "getNotebookTab(String)", "Unable to dynamically load notebbok page class \"" + tabclassname + "\".", e);
            }
        }
        return tab;
    }

    protected final void addTab(String tabclassname) {
        this.addTab(this.getTab(tabclassname));
    }

    protected final void addTab(SsgPsNotebookTab tab) {
        this.m_notebook.addPage((WNotebookPage)tab);
    }

    private final WNotebook createNotebook() {
        this.m_notebook = SsgPsUtilities.createNotebook();
        this.m_notebook.addPropertyChangeListener((PropertyChangeListener)this);
        SsgConsoleResource msgutil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.getUser().getLocale());
        this.m_notebook.addUserAction(ACTION_OK, msgutil.getMessage("COMMON_BUTTON_OK"), (ICommandListener)this, true);
        this.m_notebook.addUserAction(ACTION_APPLY, msgutil.getMessage("COMMON_BUTTON_APPLY"), (ICommandListener)this, true);
        this.m_notebook.addUserAction(ACTION_CANCEL, msgutil.getMessage("COMMON_BUTTON_CANCEL"), (ICommandListener)this, false);
        return this.m_notebook;
    }

    private synchronized boolean applyNotebook() {
        SsgLogUtilities.logEntry(this, "applyNotebook", null);
        boolean ret = true;
        int i = 0;
        while (i < this.m_notebook.getPageCount()) {
            SsgPsNotebookTab tab = (SsgPsNotebookTab)this.m_notebook.getPageAt(i);
            if (!tab.apply()) {
                this.m_notebook.setCurrentPageIndex(i);
                ret = false;
            }
            if (!ret) break;
            ++i;
        }
        SsgLogUtilities.logExit(this, "applyNotebook", String.valueOf(ret));
        return ret;
    }
}

