/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.trigger.IResult;
import com.ibm.storage.console.ConsoleContext;
import com.ibm.storage.console.adaptor.PageAdaptor;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public abstract class PsWclAdaptor
extends PageAdaptor {
    private WPage m_wclPage = null;
    private boolean m_destroyed = false;

    public final WPage getCurrentPage() {
        return this.m_wclPage;
    }

    public void destroy() {
        this.m_destroyed = true;
    }

    public void render(ConsoleContext consoleContext) {
        SsgLogUtilities.logEntrySSG(this, "render(ConsoleContext)", null);
        HttpServletRequest request = consoleContext.getHttpServletRequest();
        HttpServletResponse response = consoleContext.getHttpServletResponse();
        ServletContext scontext = consoleContext.getServletContext();
        WclFacade wclFacade = this.getUser().getAppWclFacade();
        String wclUrlBase = this.getUser().getAppWclUrlBase();
        try {
            RenderingContext rc = wclFacade.createRenderingContext(request, response, scontext);
            TriggerContext tc = wclFacade.createTriggerContext(request, scontext);
            SsgPsUtilities.setWclFacadeSkin(wclFacade, rc);
            SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 1");
            if (!request.getRequestURI().startsWith(wclUrlBase)) {
                SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 2");
                this.renderWclPage(rc);
                SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 3");
                if (this.m_wclPage != null) {
                    SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 4");
                    SsgPsUtilities.sendPageToResponse(rc, this.m_wclPage, wclFacade);
                    SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 5");
                }
            } else if (wclFacade.canHandleRequest(tc)) {
                SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 6");
                SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 7");
                IResult result = null;
                SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 8");
                result = wclFacade.handleRequest(request, response, scontext);
                SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 9");
                if (result != null) {
                    SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 12");
                    SsgPsUtilities.sendResultToResponse(tc, rc, result, wclFacade);
                }
            }
            SsgLogUtilities.logSSG(this, "render(ConsoleContext)", "Step 13");
        }
        catch (Exception ex) {
            if (!this.m_destroyed) {
                SsgLogUtilities.logUnexpectedError(this, "render", "Unexpected RuntimeException destroyed =false", (Throwable)ex);
                throw new RuntimeException();
            }
            SsgLogUtilities.logUnexpectedError(this, "render", "Unexpected RuntimeException destroyed =true", (Throwable)ex);
        }
        SsgLogUtilities.logExitSSG(this, "render(ConsoleContext)", null);
    }

    protected final void setCurrentPage(WPage page) {
        this.m_wclPage = page;
    }

    protected void renderWclPage(RenderingContext rc) {
        SsgLogUtilities.throwUnexpectedError(this, "renderWclPage(RenderingContext)", "The renderWclPage of the PsWclAdaptor should not be called.", null);
    }
}

