/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.psw.wcl.components.wizard.WWizard;
import com.ibm.psw.wcl.components.wizard.WWizardStep;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BasePageStyleInfo;
import com.ibm.storage.console.adaptor.SsgPsPage;
import com.ibm.storage.console.adaptor.SsgPsWizardStep;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;

public abstract class PsWizardPage
extends SsgPsPage {
    private Hashtable m_wizardSteps = new Hashtable();
    private WWizard m_wizard = null;

    public abstract boolean finish();

    public void setHelp() {
        SsgLogUtilities.logEntry(this, "setHelp()", null);
        SsgPsWizardStep step = (SsgPsWizardStep)this.m_wizard.getCurrentStep();
        if (step != null) {
            this.setHelp(((Object)((Object)step)).getClass().getName());
        }
        SsgLogUtilities.logExit(this, "setHelp()", null);
    }

    public final int getStepCount() {
        return this.m_wizard.getStepCount();
    }

    public void commandPerformed(CommandEvent ce) {
        SsgLogUtilities.logEntry(this, "commandPerformed", null);
        TriggerContext tc = ce.getTriggerContext();
        Object source = ce.getSource();
        SsgLogUtilities.log(this, "commandPerformed", "Source class: " + source.getClass().getName());
        String action = ce.getCommandName();
        SsgLogUtilities.log(this, "commandPerformed", "Action: " + action);
        if (action != null && action.equals("wizardCompleted")) {
            if (this.finish()) {
                this.closeTask(this.getTaskId());
            }
        } else if (action != null && action.equals("wizardCanceled")) {
            this.closeTask(this.getTaskId());
        }
        SsgLogUtilities.logExit(this, "commandPerformed", null);
    }

    public void destroy() {
        SsgLogUtilities.logEntry(this, "destroy", null);
        super.gc_destroy();
        SsgLogUtilities.logExit(this, "destroy", null);
    }

    public SsgPsWizardStep findStep(String stepclassname) {
        return (SsgPsWizardStep)((Object)this.m_wizardSteps.get(stepclassname));
    }

    public final void hideStep(String stepclassname) {
        SsgPsWizardStep step = this.findStep(stepclassname);
        int index = this.m_wizard.indexOfStep((WWizardStep)step);
        this.m_wizard.removeStepAt(index);
    }

    public void init() {
        BasePageStyleInfo pageStyle = new BasePageStyleInfo();
        pageStyle.setStyleValue("page1", "margin-left", (Object)"0px");
        pageStyle.setStyleValue("page1", "margin-top", (Object)"0px");
        this.setStyleInfo((AStyleInfo)pageStyle);
        this.createWizard();
        super.init();
    }

    public synchronized void propertyChange(PropertyChangeEvent e) {
        SsgLogUtilities.logEntry(this, "propertyChange", null);
        String prop = e.getPropertyName();
        if (prop.equals("wizardStepChanged")) {
            SsgPsWizardStep step = (SsgPsWizardStep)this.m_wizard.getCurrentStep();
            step.refresh();
            this.setHelp();
        }
        SsgLogUtilities.logExit(this, "propertyChange", null);
    }

    public final void showStep(String stepclassname, int stepindex) {
        SsgPsWizardStep step = this.findStep(stepclassname);
        this.m_wizard.insertStep((WWizardStep)step, stepindex);
    }

    protected final synchronized SsgPsWizardStep getStep(String stepclassname) {
        SsgLogUtilities.logEntry(this, "getStep", stepclassname);
        SsgPsWizardStep step = null;
        step = (SsgPsWizardStep)((Object)this.m_wizardSteps.get(stepclassname));
        if (step == null) {
            try {
                Class<?> c = Class.forName(stepclassname);
                step = (SsgPsWizardStep)((Object)c.newInstance());
                step.setUser(this.getUser());
                step.setPage(this);
                this.m_wizardSteps.put(stepclassname, step);
                step.init();
            }
            catch (Exception e) {
                SsgLogUtilities.throwUnexpectedError(this, "getWizardStep(String)", "Unable to dynamically load wizard step class \"" + stepclassname + "\".", e);
            }
        }
        SsgLogUtilities.logExit(this, "getStep", null);
        return step;
    }

    public final WWizard getWizard() {
        return this.m_wizard;
    }

    protected final void addStep(String stepclassname) {
        this.m_wizard.addStep((WWizardStep)this.getStep(stepclassname));
    }

    protected final void addStep(SsgPsWizardStep step) {
        this.m_wizard.addStep((WWizardStep)step);
    }

    protected final void removeStep(String stepclassname) {
        SsgPsWizardStep step = this.getStep(stepclassname);
        this.removeStep(step);
    }

    protected final void removeStep(SsgPsWizardStep step) {
        this.m_wizard.removeStep((WWizardStep)step);
        this.m_wizardSteps.remove(((Object)((Object)step)).getClass().getName());
        step.destroy();
    }

    private final WWizard createWizard() {
        SsgLogUtilities.logEntry(this, "createWizard", null);
        this.m_wizard = SsgPsUtilities.createWizard();
        this.m_wizard.addPropertyChangeListener((PropertyChangeListener)this);
        SsgLogUtilities.logExit(this, "createWizard", null);
        return this.m_wizard;
    }
}

