/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.markup.WHeadMarkup;
import com.ibm.storage.common.IBMErrorString;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.User;
import com.ibm.storage.console.adaptor.PsAdaptor;
import com.ibm.storage.console.gui.ConsoleMessageBox;
import com.ibm.storage.console.gui.ConsoleMessageHelpListener;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.HelpUtilities;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.awt.ComponentOrientation;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Properties;

public abstract class SsgPsPage
extends WPage
implements PropertyChangeListener,
ICommandListener {
    protected HashMap m_parameters = new HashMap();
    protected SsgConsoleResource m_msgResource = null;
    protected SsgConsoleResource m_resource = null;
    private ConsoleMessageBox m_messageBox = null;
    private PsAdaptor m_psAdaptor = null;
    private RenderingContext m_rc = null;
    private String m_currentHelp = null;
    private String m_parentPage = null;
    private String m_taskId = null;
    private User m_user = null;
    private WHeadMarkup m_helpHeader = null;
    private boolean m_showMessageHelp = false;

    public abstract void create();

    public ComponentOrientation getComponentOrientation() {
        return this.m_rc.getComponentOrientation();
    }

    public void setHelp() {
        this.setHelp(this.getClass().getName());
    }

    public void setHelp(String classname) {
        if (this.m_showMessageHelp && this.m_currentHelp != null && this.m_currentHelp.equals(classname)) {
            this.m_showMessageHelp = false;
            return;
        }
        this.m_showMessageHelp = false;
        this.m_currentHelp = classname;
        HelpUtilities.setPanelHelp(this, classname);
    }

    public void setHelpHeader(WHeadMarkup header) {
        if (this.m_helpHeader != null) {
            this.remove((WComponent)this.m_helpHeader);
        }
        this.m_helpHeader = header;
        this.add((WComponent)header);
    }

    public void setMessageHelp(String msgid) {
        HelpUtilities.setMessageHelp(this, msgid);
        this.m_showMessageHelp = true;
    }

    public void setParent(String parentpage) {
        this.m_parentPage = parentpage;
    }

    public final String getParentPage() {
        return this.m_parentPage;
    }

    public void setPsAdaptor(PsAdaptor adaptor) {
        this.m_psAdaptor = adaptor;
    }

    public void setRenderingContext(RenderingContext rc) {
        this.m_rc = rc;
    }

    public RenderingContext getRenderingContext() {
        return this.m_rc;
    }

    public void setSharedData(String sparam, Object svalue) {
        SsgLogUtilities.logEntry(this, "setSharedData", sparam);
        this.getUser().setAttribute(sparam, svalue);
        SsgLogUtilities.logExit(this, "setSharedData", null);
    }

    public void setTaskId(String taskid) {
        this.m_taskId = taskid;
    }

    public void setUser(User user) {
        this.m_user = user;
    }

    public void commandPerformed(CommandEvent ce) {
    }

    public void destroy() {
        SsgLogUtilities.logEntry(this, "destroy", null);
        this.m_psAdaptor.uncachePage(this);
        super.destroy();
        SsgLogUtilities.logExit(this, "destroy", "SsgPsPage was destroyed!");
    }

    public SsgPsPage findPage(String classname) {
        return this.m_psAdaptor.findPage(classname);
    }

    public void gc_destroy() {
        SsgLogUtilities.logEntry(this, "gc_destroy", null);
        this.m_psAdaptor.uncachePage(this);
        SsgLogUtilities.log(this, "gc_destroy", "SsgPsPage was uncached!");
        SsgLogUtilities.logExit(this, "gc_destroy", null);
    }

    public void init() {
        this.create();
    }

    public void propertyChange(PropertyChangeEvent e) {
    }

    public void refresh() {
    }

    public void showMessage(String msgkey) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(msgkey);
    }

    public void showMessage(String msgkey, Object[] inserts) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(msgkey, inserts);
    }

    public void showMessage(SsgConsoleException cex) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(cex);
    }

    public void showMessage(IBMErrorString errorobj) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(errorobj);
    }

    public void showMessage(String msgid, String msg) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(msgid, msg);
    }

    public final void switchPage(String pageclassname, TriggerContext tc) {
        SsgLogUtilities.logEntry(this, "switchPage", pageclassname);
        SsgPsPage page = this.getPage(pageclassname);
        this.m_psAdaptor.showPage(page);
        tc.setRedirectPath(page.getURL((AContext)tc));
        SsgLogUtilities.logExit(this, "switchPage", null);
    }

    public final void switchPage(SsgPsPage page, TriggerContext tc) {
        SsgLogUtilities.logEntry(this, "switchPage", page.getClass().getName());
        this.m_psAdaptor.showPage(page);
        tc.setRedirectPath(page.getURL((AContext)tc));
        SsgLogUtilities.logExit(this, "switchPage", null);
    }

    protected final PsAdaptor getAdaptor() {
        return this.m_psAdaptor;
    }

    protected final void setFlag(String sessionflag) {
        SsgLogUtilities.logEntry(this, "setFlag", sessionflag);
        this.getUser().setAttribute(sessionflag, new Boolean(true));
        SsgLogUtilities.logExit(this, "setFlag", null);
    }

    protected final boolean isFlagSet(String sessionflag) {
        return this.getUser().isSessionVariableSet(sessionflag);
    }

    protected String getMessageBundleName() {
        return Console.getAppAttributeValue("resource_message");
    }

    protected SsgPsPage getPage(String classname) {
        return this.m_psAdaptor.getPage(classname);
    }

    protected final void setParameters(HashMap params) {
        this.m_parameters.putAll(params);
    }

    protected String getResourceBundleName() {
        return Console.getAppAttributeValue("resource");
    }

    protected Object getSharedData(String sparam) {
        return this.getUser().getAttribute(sparam);
    }

    protected final String getTaskId() {
        return this.m_taskId;
    }

    protected final User getUser() {
        return this.m_user;
    }

    protected final String L(String id) {
        return this.getResource().getMessage(id);
    }

    protected final String L(String id, Object arg1) {
        return this.getResource().getMessage(id, arg1);
    }

    protected final String L(String id, Object arg1, Object arg2) {
        return this.getResource().getMessage(id, arg1, arg2);
    }

    protected final String L(String id, Object arg1, Object arg2, Object arg3) {
        return this.getResource().getMessage(id, arg1, arg2, arg3);
    }

    protected final String L(String id, Object[] args) {
        return this.getResource().getMessage(id, args);
    }

    protected final String M(String id) {
        return this.getMessageResource().getMessage(id);
    }

    protected final String M(String id, Object arg1) {
        return this.getMessageResource().getMessage(id, arg1);
    }

    protected final String M(String id, Object arg1, Object arg2) {
        return this.getMessageResource().getMessage(id, arg1, arg2);
    }

    protected final String M(String id, Object arg1, Object arg2, Object arg3) {
        return this.getMessageResource().getMessage(id, arg1, arg2, arg3);
    }

    protected final String M(String id, Object[] args) {
        return this.getMessageResource().getMessage(id, args);
    }

    protected final void closeTask(String taskid) {
        SsgLogUtilities.logEntry(this, "closeTask", taskid);
        this.getUser().closeTask(taskid);
        SsgLogUtilities.logExit(this, "closeTask", null);
    }

    protected final void launchPage(String tasktitle, String pageclassname) {
        SsgLogUtilities.logEntry(this, "launchPage", pageclassname);
        Properties properties = new Properties();
        properties.setProperty("PsAdaptor.pageClassname", pageclassname);
        this.getUser().launchTask(pageclassname, tasktitle, "com.ibm.storage.console.adaptor.PsAdaptor", properties);
        SsgLogUtilities.logExit(this, "launchPage", null);
    }

    protected final void launchTask(String taskid) {
        SsgLogUtilities.logEntry(this, "launchTask", taskid);
        this.getUser().launchTask(taskid);
        SsgLogUtilities.logExit(this, "launchTask", null);
    }

    protected final void unsetFlag(String sessionflag) {
        SsgLogUtilities.logEntry(this, "unsetFlag", sessionflag);
        this.getUser().setAttribute(sessionflag, new Boolean(false));
        SsgLogUtilities.logExit(this, "unsetFlag", null);
    }

    protected ConsoleMessageBox getMessageBox() {
        if (this.m_messageBox == null) {
            this.createMessageBox();
        }
        return this.m_messageBox;
    }

    protected String getParameter(String key) {
        return (String)this.m_parameters.get(key);
    }

    protected Object getParameterObject(String key) {
        return this.m_parameters.get(key);
    }

    protected ConsoleMessageBox createMessageBox(ICommandListener cmdlistener, String oklabel) {
        this.m_messageBox = new ConsoleMessageBox(this.getMessageBundleName(), this.getUser().getLocale(), cmdlistener, oklabel);
        this.m_messageBox.setIDLinkListener(new ConsoleMessageHelpListener(this.getUser(), this));
        return this.m_messageBox;
    }

    protected ConsoleMessageBox createMessageBox() {
        this.m_messageBox = new ConsoleMessageBox(this.getMessageBundleName(), this.getUser().getLocale());
        this.m_messageBox.setIDLinkListener(new ConsoleMessageHelpListener(this.getUser(), this));
        return this.m_messageBox;
    }

    protected void unsetSharedData(String sparam) {
        SsgLogUtilities.logEntry(this, "unsetSharedData", sparam);
        this.getUser().removeAttribute(sparam);
        SsgLogUtilities.logExit(this, "unsetSharedData", null);
    }

    private SsgConsoleResource getMessageResource() {
        if (this.m_msgResource == null) {
            this.m_msgResource = new SsgConsoleResource(this.getMessageBundleName(), this.m_user.getLocale());
        }
        return this.m_msgResource;
    }

    private SsgConsoleResource getResource() {
        if (this.m_resource == null) {
            this.m_resource = new SsgConsoleResource(this.getResourceBundleName(), this.m_user.getLocale());
        }
        return this.m_resource;
    }
}

