/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.adaptor;

import com.ibm.psw.wcl.components.wizard.WWizardStep;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.IValidator;
import com.ibm.storage.common.IBMErrorString;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.User;
import com.ibm.storage.console.adaptor.PsWizardPage;
import com.ibm.storage.console.adaptor.SsgPsPage;
import com.ibm.storage.console.gui.ConsoleMessageBox;
import com.ibm.storage.console.gui.ConsoleMessageHelpListener;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Properties;

public abstract class SsgPsWizardStep
extends WWizardStep
implements IValidator {
    protected SsgConsoleResource m_msgResource = null;
    protected SsgConsoleResource m_resource = null;
    private ConsoleMessageBox m_messageBox = null;
    private SsgPsPage m_page = null;
    private User m_user = null;

    public abstract void create();

    public void setPage(SsgPsPage page) {
        this.m_page = page;
    }

    public void setUser(User user) {
        this.m_user = user;
    }

    public void destroy() {
        SsgLogUtilities.logEntry((Object)this, "destroy", null);
        super.destroy();
        this.removeAll();
        SsgLogUtilities.logExit((Object)this, "destroy", null);
    }

    public final void hideStep(String stepclassname) {
        ((PsWizardPage)this.getPage()).hideStep(stepclassname);
    }

    public SsgPsWizardStep findStep(String stepclassname) {
        return ((PsWizardPage)this.m_page).findStep(stepclassname);
    }

    public void init() {
        this.create();
        this.addStepValidator(this);
    }

    public void refresh() {
    }

    public final void showStep(String stepclassname, int stepindex) {
        ((PsWizardPage)this.getPage()).showStep(stepclassname, stepindex);
    }

    public void showMessage(String msgkey) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(msgkey);
    }

    public void showMessage(String msgkey, Object[] inserts) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(msgkey, inserts);
    }

    public void showMessage(SsgConsoleException cex) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(cex);
    }

    public void showMessage(IBMErrorString errorobj) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(errorobj);
    }

    public void showMessage(String msgid, String msg) {
        this.m_messageBox.hide();
        this.m_messageBox.addMessage(msgid, msg);
    }

    public boolean validate() {
        return true;
    }

    public boolean validate(TriggerContext tc, WComponent comp, Object object) {
        return this.validate();
    }

    protected final void setFlag(String sessionflag) {
        SsgLogUtilities.logEntry((Object)this, "setFlag", sessionflag);
        this.getUser().setAttribute(sessionflag, new Boolean(true));
        SsgLogUtilities.logExit((Object)this, "setFlag", null);
    }

    protected final boolean isFlagSet(String sessionflag) {
        return this.getUser().isSessionVariableSet(sessionflag);
    }

    protected String getMessageBundleName() {
        return Console.getAppAttributeValue("resource_message");
    }

    protected final SsgPsPage getPage() {
        return this.m_page;
    }

    protected String getResourceBundleName() {
        return Console.getAppAttributeValue("resource");
    }

    protected final void setSharedData(String sparam, Object svalue) {
        SsgLogUtilities.logEntry((Object)this, "setSharedData", sparam);
        this.getUser().setAttribute(sparam, svalue);
        SsgLogUtilities.logExit((Object)this, "setSharedData", null);
    }

    protected final Object getSharedData(String sparam) {
        return this.getUser().getAttribute(sparam);
    }

    protected final SsgPsWizardStep getStep(String classname) {
        return ((PsWizardPage)this.m_page).getStep(classname);
    }

    protected final User getUser() {
        return this.m_user;
    }

    protected final String L(String id) {
        return this.getResource().getMessage(id);
    }

    protected final String L(String id, Object arg1) {
        return this.getResource().getMessage(id, arg1);
    }

    protected final String L(String id, Object arg1, Object arg2) {
        return this.getResource().getMessage(id, arg1, arg2);
    }

    protected final String L(String id, Object arg1, Object arg2, Object arg3) {
        return this.getResource().getMessage(id, arg1, arg2, arg3);
    }

    protected final String L(String id, Object[] args) {
        return this.getResource().getMessage(id, args);
    }

    protected final String M(String id) {
        return this.getMessageResource().getMessage(id);
    }

    protected final String M(String id, Object arg1) {
        return this.getMessageResource().getMessage(id, arg1);
    }

    protected final String M(String id, Object arg1, Object arg2) {
        return this.getMessageResource().getMessage(id, arg1, arg2);
    }

    protected final String M(String id, Object arg1, Object arg2, Object arg3) {
        return this.getMessageResource().getMessage(id, arg1, arg2, arg3);
    }

    protected final String M(String id, Object[] args) {
        return this.getMessageResource().getMessage(id, args);
    }

    protected final void closeTask(String taskid) {
        SsgLogUtilities.logEntry((Object)this, "closeTask", taskid);
        this.getUser().closeTask(taskid);
        SsgLogUtilities.logExit((Object)this, "closeTask", null);
    }

    protected final void launchPage(String tasktitle, String pageclassname) {
        SsgLogUtilities.logEntry((Object)this, "launchPage", pageclassname);
        Properties properties = new Properties();
        properties.setProperty("PsAdaptor.pageClassname", pageclassname);
        this.getUser().launchTask(pageclassname, tasktitle, "com.ibm.storage.console.adaptor.PsAdaptor", properties);
        SsgLogUtilities.logExit((Object)this, "launchPage", null);
    }

    protected final void launchTask(String taskid) {
        SsgLogUtilities.logEntry((Object)this, "launchTask", taskid);
        this.getUser().launchTask(taskid);
        SsgLogUtilities.logExit((Object)this, "launchTask", null);
    }

    protected final void unsetFlag(String sessionflag) {
        SsgLogUtilities.logEntry((Object)this, "unsetFlag", sessionflag);
        this.getUser().setAttribute(sessionflag, new Boolean(false));
        SsgLogUtilities.logExit((Object)this, "unsetFlag", null);
    }

    protected final void unsetSharedData(String sparam) {
        SsgLogUtilities.logEntry((Object)this, "unsetSharedData", sparam);
        this.getUser().removeAttribute(sparam);
        SsgLogUtilities.logExit((Object)this, "unsetSharedData", null);
    }

    protected ConsoleMessageBox getMessageBox() {
        if (this.m_messageBox == null) {
            this.createMessageBox();
        }
        return this.m_messageBox;
    }

    protected ConsoleMessageBox createMessageBox(ICommandListener cmdlistener, String oklabel) {
        this.m_messageBox = new ConsoleMessageBox(this.getMessageBundleName(), this.getUser().getLocale(), cmdlistener, oklabel);
        this.m_messageBox.setIDLinkListener(new ConsoleMessageHelpListener(this.getUser(), this.getPage()));
        return this.m_messageBox;
    }

    protected ConsoleMessageBox createMessageBox() {
        this.m_messageBox = new ConsoleMessageBox(this.getMessageBundleName(), this.getUser().getLocale());
        this.m_messageBox.setIDLinkListener(new ConsoleMessageHelpListener(this.getUser(), this.getPage()));
        return this.m_messageBox;
    }

    private SsgConsoleResource getMessageResource() {
        if (this.m_msgResource == null) {
            this.m_msgResource = new SsgConsoleResource(this.getMessageBundleName(), this.m_user.getLocale());
        }
        return this.m_msgResource;
    }

    private SsgConsoleResource getResource() {
        if (this.m_resource == null) {
            this.m_resource = new SsgConsoleResource(this.getResourceBundleName(), this.m_user.getLocale());
        }
        return this.m_resource;
    }
}

