/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMClass;
import com.ibm.cim.CIMClient;
import com.ibm.cim.CIMException;
import com.ibm.cim.CIMInstance;
import com.ibm.cim.CIMObjectPath;
import com.ibm.cim.CIMValue;
import com.ibm.psw.wcl.components.table.DefaultExtendedTableModel;
import com.ibm.psw.wcl.components.table.IExtendedTableModel;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.cim.CimClassMeta;
import com.ibm.storage.console.cim.CimPropertyMeta;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;

public class CimDetail
extends WTable {
    private CIMClient m_cimClient = null;
    private CIMMetaProvider m_metaProvider = null;
    private DefaultExtendedTableModel m_tableModel = null;
    private Locale m_locale = null;
    private Properties m_cimKeys = new Properties();
    private String m_cimClassName = null;

    public CimDetail(CIMClient cimClient, String classname, String userkeyname, String userkeyvalue, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(null, null, 8);
        SsgLogUtilities.logEntry((Object)this, "CimDetail", classname + ":" + userkeyvalue);
        this.m_cimClassName = classname;
        this.m_cimKeys.setProperty(userkeyname, userkeyvalue);
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        this.refresh(cimClient);
        SsgLogUtilities.logExit((Object)this, "CimDetail", null);
    }

    public CimDetail(CIMClient cimClient, String classname, Properties keys, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(null, null, 8);
        SsgLogUtilities.logEntry((Object)this, "CimDetail", classname);
        this.m_cimClassName = classname;
        this.m_cimKeys.putAll((Map<?, ?>)keys);
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        this.refresh(cimClient);
        SsgLogUtilities.logExit((Object)this, "CimDetail", null);
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getPropertyValue(CimPropertyMeta propMeta, CIMValue propValue) {
        SsgLogUtilities.logEntry((Object)this, "getPropertyValue", String.valueOf(propMeta.getMetaType()));
        String retstr = propMeta.getDisplayableValue(propValue);
        SsgLogUtilities.logExit((Object)this, "getPropertyValue", retstr);
        return retstr;
    }

    public void destroy() {
        SsgLogUtilities.logEntry((Object)this, "destroy", null);
        this.m_tableModel = null;
        super.destroy();
        SsgLogUtilities.logExit((Object)this, "destroy", null);
    }

    public void refresh(CIMClient cimClient) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "refresh", null);
        this.m_cimClient = cimClient;
        this.resetTableModel();
        SsgPsUtilities.setTableStyle(this);
        this.setSelectionMode(-1);
        this.setFooterVisible(false);
        this.setToolbarVisible(false);
        SsgLogUtilities.logExit((Object)this, "refresh", null);
    }

    private void resetTableModel() throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "resetTableModel", null);
        if (this.m_tableModel != null) {
            this.m_tableModel = null;
        }
        if (this.m_cimClient == null) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "resetTableModel", "The cimom connection was not setup correctly.", null);
        }
        Vector<String> columnNames = new Vector<String>();
        SsgConsoleResource msgUtil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_locale);
        columnNames.add(msgUtil.getMessage("CIMWIDGET_DETAIL_HEADER_ATTRIBUTE"));
        columnNames.add(msgUtil.getMessage("CIMWIDGET_DETAIL_HEADER_VALUE"));
        Vector dataRows = new Vector();
        try {
            CIMObjectPath clsPath = new CIMObjectPath(this.m_cimClassName, Console.getCimomManager().getNameSpace());
            CIMClass cls = this.m_cimClient.getClass(clsPath, false);
            CimClassMeta clsMeta = new CimClassMeta(cls, this.m_metaProvider.getClassByName(this.m_cimClassName));
            clsMeta.setLocale(this.m_locale);
            Vector classProperties = clsMeta.getCimProperties();
            Enumeration<?> keys = this.m_cimKeys.propertyNames();
            while (keys.hasMoreElements()) {
                String prop = (String)keys.nextElement();
                String value = this.m_cimKeys.getProperty(prop);
                clsPath.addKey(prop, new CIMValue((Object)value));
            }
            CIMInstance instance = this.m_cimClient.getInstance(clsPath, false);
            int i = 0;
            while (i < classProperties.size()) {
                CimPropertyMeta propMeta = (CimPropertyMeta)classProperties.get(i);
                if (propMeta.isPublic() && !propMeta.isForeign() && !propMeta.isDerived()) {
                    Vector<String> dataRow = new Vector<String>();
                    String propName = propMeta.getCimName();
                    String propTitle = propMeta.getDisplayName();
                    String unit = "";
                    if (propMeta.isUnitDefined() && (unit = propMeta.getUnit()) != null && unit.trim().length() > 0) {
                        propTitle = propTitle + " (" + unit + ")";
                    }
                    dataRow.add(propTitle);
                    CIMValue propValue = instance.getProperty(propName).getValue();
                    String displayValue = this.getPropertyValue(propMeta, propValue);
                    if (displayValue == null || displayValue.trim().length() == 0) {
                        displayValue = "-";
                    }
                    dataRow.add(displayValue);
                    dataRows.add(dataRow);
                }
                ++i;
            }
            this.m_tableModel = new DefaultExtendedTableModel(dataRows, columnNames);
            this.setModel((IExtendedTableModel)this.m_tableModel);
        }
        catch (CIMException cimex) {
            SsgLogUtilities.throwError((Object)this, "resetTableModel", SsgConsoleException.getConsoleException(cimex, this.m_metaProvider));
        }
        SsgLogUtilities.logExit((Object)this, "resetTableModel", null);
    }
}

