/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMClient;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.AWInputComponent;
import com.ibm.psw.wcl.core.form.IValidator;
import com.ibm.psw.wcl.core.form.WButton;
import com.ibm.psw.wcl.core.form.WCheckBox;
import com.ibm.psw.wcl.core.form.WComboBox;
import com.ibm.psw.wcl.core.form.WForm;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.psw.wcl.skins.base.BaseTextComponentStyleInfo;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.cim.CimElementMeta;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public abstract class CimDialog
extends WForm {
    protected CIMClient m_cimClient = null;
    protected CIMMetaProvider m_metaProvider = null;
    protected Hashtable m_metaElements = new Hashtable();
    protected ICommandListener m_commandListener = null;
    protected Locale m_locale = null;
    protected Vector m_fields = new Vector();
    protected WBoxLayout m_formLayout = null;
    protected WButton m_cancelButton = null;
    protected WTextComponent m_errorBox = null;

    protected CimDialog(CIMClient cimClient, ICommandListener commandlistener, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "CimDialog", null);
        this.m_cimClient = cimClient;
        this.m_commandListener = commandlistener;
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        SsgLogUtilities.logExit((Object)this, "CimDialog", null);
    }

    public String getCancelButtonName() {
        return this.getPrefixName() + "_cancel";
    }

    public String getFieldName(String fieldname) {
        return this.getPrefixName() + "_" + fieldname;
    }

    public Object getFieldValue(String fieldname) {
        SsgLogUtilities.logEntry((Object)this, "getFieldValue", fieldname);
        AWInputComponent field = (AWInputComponent)this.getFieldByName(fieldname);
        CimElementMeta elemMeta = (CimElementMeta)this.m_metaElements.get(fieldname);
        int metaType = elemMeta.getMetaType();
        switch (metaType) {
            case 1: {
                SsgLogUtilities.logExit((Object)this, "getFieldValue", String.valueOf(((WCheckBox)field).isChecked()));
                return new Boolean(((WCheckBox)field).isChecked());
            }
            case 3: {
                String value = (String)((WComboBox)field).getSelectedObject();
                SsgLogUtilities.logExit((Object)this, "getFieldValue", value);
                return elemMeta.getMapByValue(value);
            }
        }
        SsgLogUtilities.logExit((Object)this, "getFieldValue", ((WTextEntry)field).getText());
        return ((WTextEntry)field).getText();
    }

    public String getFormName() {
        return this.getPrefixName();
    }

    public String getOKButtonName() {
        return this.getPrefixName() + "_ok";
    }

    public void destroy() {
        SsgLogUtilities.logEntry((Object)this, "destroy", null);
        this.m_fields.removeAllElements();
        this.m_metaElements.clear();
        super.destroy();
        SsgLogUtilities.logExit((Object)this, "destroy", null);
    }

    public void hideErrorBox() {
        SsgLogUtilities.logEntry((Object)this, "hideErrorBox", null);
        this.m_errorBox.setText("");
        WComponent topcomp = this.m_formLayout.getChildComponent(0);
        if (topcomp == this.m_errorBox) {
            this.m_formLayout.remove(0);
        }
        SsgLogUtilities.logExit((Object)this, "hideErrorBox", null);
    }

    public void refresh() throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "refresh", null);
        this.hideErrorBox();
        int i = 0;
        while (i < this.m_fields.size()) {
            WComponent field = (WComponent)this.m_fields.elementAt(i);
            this.resetFieldValue(field);
            ++i;
        }
        SsgLogUtilities.logExit((Object)this, "refresh", null);
    }

    protected WComponent getFieldByName(String fieldname) {
        SsgLogUtilities.logEntry((Object)this, "getFieldByName", fieldname);
        fieldname = this.getFieldName(fieldname);
        int i = 0;
        if (i < this.m_fields.size()) {
            AWInputComponent field = (AWInputComponent)this.m_fields.elementAt(i);
            if (fieldname.equals(field.getName())) {
                SsgLogUtilities.logExit((Object)this, "getFieldByName", field.getName());
            }
            return field;
        }
        SsgLogUtilities.logExit((Object)this, "getFieldByName", null);
        return null;
    }

    protected String getPrefixName() {
        return "cimdialog";
    }

    protected void cacheField(WComponent field, CimElementMeta elem) {
        SsgLogUtilities.logEntry((Object)this, "cacheField", elem.getCimName());
        this.m_formLayout.add(field);
        this.m_formLayout.setAlignment(field, "left");
        this.m_fields.add(field);
        this.m_metaElements.put(elem.getCimName(), elem);
        SsgLogUtilities.logExit((Object)this, "cacheField", null);
    }

    protected WComponent createFieldComponent(CimElementMeta elemMeta) {
        SsgLogUtilities.logEntry((Object)this, "createFieldComponent", elemMeta.getDisplayName());
        int metatype = elemMeta.getMetaType();
        WCheckBox elemField = null;
        String fieldname = this.getFieldName(elemMeta.getCimName());
        switch (metatype) {
            case 1: {
                elemField = new WCheckBox(fieldname, "");
                elemField.setChecked(false);
                break;
            }
            case 3: {
                Vector values = elemMeta.getValues();
                elemField = new WComboBox(fieldname, values);
                break;
            }
            default: {
                elemField = new WTextEntry(fieldname, "");
                if (elemMeta.isMaxLenDefined()) {
                    ((WTextEntry)elemField).setMaxLength(elemMeta.getMaxLen());
                }
                ((WTextEntry)elemField).setSize(16);
            }
        }
        String label = elemMeta.getDisplayName();
        if (elemMeta.isUnitDefined()) {
            label = label + " (" + elemMeta.getUnit() + ")";
        }
        elemField.setLabel(label);
        SsgLogUtilities.logExit((Object)this, "createFieldComponent", elemField.getName());
        return elemField;
    }

    protected void createFields() throws SsgConsoleException {
    }

    protected void createForm() throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "createForm", null);
        if (this.m_cimClient == null) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "resetTableModel", "The cimom connection was not setup correctly.", null);
        }
        this.m_fields = new Vector();
        this.m_metaElements = new Hashtable();
        this.setName(this.getFormName());
        this.setMethod("post");
        this.addValidator(new DialogValidator());
        this.m_formLayout = new WBoxLayout("vertical");
        this.m_formLayout.setGap(20);
        this.add((WComponent)this.m_formLayout);
        this.m_errorBox = new WTextComponent("");
        BaseTextComponentStyleInfo errorStyle = new BaseTextComponentStyleInfo();
        if (errorStyle != null) {
            errorStyle.setStyleValue("txt", "font-weight", (Object)"bold");
            errorStyle.setStyleValue("txt", "color", (Object)"#FF0000");
        }
        this.m_errorBox.setStyleInfo((AStyleInfo)errorStyle);
        this.createFields();
        if (this.m_commandListener != null) {
            this.addCommandListener(this.m_commandListener);
            SsgConsoleResource msgUtil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_locale);
            String okstr = msgUtil.getMessage("COMMON_BUTTON_OK");
            String cancelstr = msgUtil.getMessage("COMMON_BUTTON_CANCEL");
            WBoxLayout btnLayout = new WBoxLayout("horizontal");
            btnLayout.setWidth(null);
            btnLayout.setGap(10);
            this.m_formLayout.add((WComponent)btnLayout);
            WButton okButton = new WButton(this.getOKButtonName(), okstr);
            okButton.addCommandListener(this.m_commandListener);
            okButton.setSubmit(true);
            btnLayout.add((WComponent)okButton);
            btnLayout.setAlignment((WComponent)okButton, "left");
            this.m_cancelButton = new WButton(this.getCancelButtonName(), cancelstr);
            this.m_cancelButton.addCommandListener(this.m_commandListener);
            this.m_cancelButton.setSubmit(true);
            btnLayout.add((WComponent)this.m_cancelButton);
            btnLayout.setAlignment((WComponent)this.m_cancelButton, "left");
        }
        SsgLogUtilities.logExit((Object)this, "createForm", null);
    }

    protected void resetFieldValue(WComponent field) throws SsgConsoleException {
    }

    protected void showErrorBox(String errormsg) {
        SsgLogUtilities.logEntry((Object)this, "showErrorBox", errormsg);
        this.m_errorBox.setText(errormsg);
        WComponent topcomp = this.m_formLayout.getChildComponent(0);
        if (topcomp != this.m_errorBox) {
            this.m_formLayout.add((WComponent)this.m_errorBox, 0);
        }
        SsgLogUtilities.logExit((Object)this, "showErrorBox", null);
    }

    protected void validateField(String fieldVal, CimElementMeta elemMeta) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "validateField", elemMeta.getDisplayName() + ":" + fieldVal);
        int metaType = elemMeta.getMetaType();
        if (fieldVal != null && metaType == 0) {
            int maxValue;
            int minValue;
            int numValue = 0;
            try {
                numValue = Integer.parseInt(fieldVal);
            }
            catch (NumberFormatException nfex) {
                SsgLogUtilities.throwError((Object)this, "validateField", new SsgConsoleException("CIMWIDGET_DIALOG_NOTANUMBER", elemMeta.getDisplayName()));
            }
            if (elemMeta.isMinValueDefined() && numValue < (minValue = elemMeta.getMinValue())) {
                SsgLogUtilities.throwError((Object)this, "validateField", new SsgConsoleException("CIMWIDGET_DIALOG_LESSTHANMIN", elemMeta.getDisplayName(), (Object)String.valueOf(minValue)));
            }
            if (elemMeta.isMaxValueDefined() && numValue > (maxValue = elemMeta.getMaxValue())) {
                SsgLogUtilities.throwError((Object)this, "validateField", new SsgConsoleException("CIMWIDGET_DIALOG_BIGGERTHANMAX", elemMeta.getDisplayName(), (Object)String.valueOf(maxValue)));
            }
        } else if (fieldVal != null && metaType == 2 && elemMeta.isMaxLenDefined()) {
            int maxLen = elemMeta.getMaxLen();
            int len = fieldVal.length();
            if (len > maxLen) {
                SsgLogUtilities.throwError((Object)this, "validateField", new SsgConsoleException("CIMWIDGET_DIALOG_STRINGTOOLONG", elemMeta.getDisplayName(), (Object)String.valueOf(maxLen)));
            }
        }
        SsgLogUtilities.logExit((Object)this, "validateField", "succeeded");
    }

    public class DialogValidator
    implements IValidator {
        public boolean validate(TriggerContext tc, WComponent comp, Object object) {
            SsgLogUtilities.logExit(this, "validate", comp.getID());
            try {
                if (comp instanceof WForm) {
                    String cancelVal = tc.getParameter(CimDialog.this.getCancelButtonName());
                    if (CimDialog.this.m_cancelButton != null && cancelVal != null) {
                        return true;
                    }
                    int i = 0;
                    while (i < CimDialog.this.m_fields.size()) {
                        AWInputComponent field = (AWInputComponent)CimDialog.this.m_fields.elementAt(i);
                        String fieldname = field.getName().substring(CimDialog.this.getPrefixName().length() + 1);
                        CimElementMeta elemMeta = (CimElementMeta)CimDialog.this.m_metaElements.get(fieldname);
                        int metatype = elemMeta.getMetaType();
                        if (metatype != 1 && metatype != 3) {
                            String fieldVal = tc.getParameter(CimDialog.this.getPrefixName() + "_" + fieldname);
                            field.setStatus(2, false);
                            int current_status = field.getStatus();
                            field.setStatus(2, true);
                            CimDialog.this.validateField(fieldVal, elemMeta);
                            field.setStatus(2, false);
                        }
                        ++i;
                    }
                    SsgLogUtilities.logExit(this, "validate", "true");
                    return true;
                }
            }
            catch (SsgConsoleException ce) {
                CimDialog.this.showErrorBox(ce.getMessage());
            }
            SsgLogUtilities.logExit(this, "validate", "false");
            return false;
        }
    }
}

