/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMDataType;
import com.ibm.cim.CIMElement;
import com.ibm.cim.CIMQualifier;
import com.ibm.storage.common.meta.client.MetaElement;
import com.ibm.storage.common.meta.client.ValueArrayItem;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Locale;
import java.util.Vector;

public abstract class CimElementMeta {
    public static final int METATYPE_NUMBER = 0;
    public static final int METATYPE_SWITCH = 1;
    public static final int METATYPE_LABEL = 2;
    public static final int METATYPE_SELECTION = 3;
    public static final int METATYPE_DATETIME = 4;
    protected CIMElement m_cimElement = null;
    protected Locale m_locale = Locale.getDefault();
    protected MetaElement m_metaElement = null;

    public CimElementMeta(CIMElement cimelem) {
        SsgLogUtilities.logEntry(this, "CimElementMeta", null);
        this.m_cimElement = cimelem;
        SsgLogUtilities.logExit(this, "CimElementMeta", null);
    }

    public CimElementMeta(CIMElement cimelem, MetaElement metaelem) {
        this(cimelem);
        SsgLogUtilities.logEntry(this, "CimElementMeta", null);
        if (metaelem == null) {
            SsgLogUtilities.throwUnexpectedError(this, "CimElementMeta", "The meta element is null.", null);
        }
        this.m_metaElement = metaelem;
        SsgLogUtilities.logExit(this, "CimElementMeta", null);
    }

    public CIMDataType getCimDataType() {
        return null;
    }

    public CIMElement getCimElement() {
        return this.m_cimElement;
    }

    public String getCimName() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getName();
        }
        return this.m_cimElement.getName();
    }

    public CIMQualifier getCimQualifier(String qualifiername) {
        return null;
    }

    public String getDisplayName() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getDisplayName();
        }
        CIMQualifier displayQualifier = this.getCimQualifier("displayname");
        if (displayQualifier != null) {
            return displayQualifier.getValue().toString();
        }
        return this.m_cimElement.getName();
    }

    public void setLocale(Locale locale) {
        this.m_locale = locale;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public String getMapByIndex(int index) {
        return (String)this.getValueMap().elementAt(index);
    }

    public String getMapByValue(String value) {
        int valindex;
        Vector valvec = this.getValues();
        if (valvec != null && (valindex = valvec.indexOf(value)) != -1) {
            return (String)this.getValueMap().elementAt(valindex);
        }
        return null;
    }

    public int getMaxLen() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getMaxLen();
        }
        CIMQualifier maxlenQualifier = this.getCimQualifier("maxlen");
        if (maxlenQualifier != null) {
            return Integer.parseInt(maxlenQualifier.getValue().toString());
        }
        return Integer.MAX_VALUE;
    }

    public boolean isMaxLenDefined() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getMaxLen() != -1;
        }
        CIMQualifier maxlenQualifier = this.getCimQualifier("maxlen");
        return maxlenQualifier != null;
    }

    public int getMaxValue() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getMaxValue();
        }
        CIMQualifier maxvalQualifier = this.getCimQualifier("maxvalue");
        if (maxvalQualifier != null) {
            return Integer.parseInt(maxvalQualifier.getValue().getValue().toString());
        }
        return Integer.MAX_VALUE;
    }

    public boolean isMaxValueDefined() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getMaxValue() != -1;
        }
        CIMQualifier maxvalQualifier = this.getCimQualifier("maxvalue");
        return maxvalQualifier != null;
    }

    public int getMetaType() {
        Vector vmap = this.getValueMap();
        if (vmap != null && vmap.size() > 0) {
            return 3;
        }
        if (this.m_metaElement != null) {
            switch (this.m_metaElement.getDataType()) {
                case 10: {
                    return 1;
                }
                case 9: 
                case 15: {
                    return 2;
                }
                case 13: {
                    return 4;
                }
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 11: 
                case 12: {
                    return 0;
                }
            }
            return 2;
        }
        switch (this.getCimDataType().getType()) {
            case 10: {
                return 1;
            }
            case 9: 
            case 14: {
                return 2;
            }
            case 13: {
                return 4;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 11: 
            case 12: {
                return 0;
            }
        }
        return 2;
    }

    public int getMinValue() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getMinValue();
        }
        CIMQualifier minvalQualifier = this.getCimQualifier("minvalue");
        if (minvalQualifier != null) {
            return Integer.parseInt(minvalQualifier.getValue().getValue().toString());
        }
        return 0;
    }

    public boolean isMinValueDefined() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getMinValue() != -1;
        }
        CIMQualifier minvalQualifier = this.getCimQualifier("minvalue");
        return minvalQualifier != null;
    }

    public String getUnit() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.getUnits();
        }
        CIMQualifier unitQualifier = this.getCimQualifier("units");
        if (unitQualifier != null) {
            return unitQualifier.getValue().toString();
        }
        return "";
    }

    public boolean isUnitDefined() {
        if (this.m_metaElement != null) {
            return this.m_metaElement.hasUnits();
        }
        CIMQualifier unitQualifier = this.getCimQualifier("units");
        return unitQualifier != null;
    }

    public String getValueByMap(String mapname) {
        int mapindex;
        Vector mapvec = this.getValueMap();
        if (mapvec != null && (mapindex = mapvec.indexOf(mapname)) != -1) {
            return (String)this.getValues().elementAt(mapindex);
        }
        return null;
    }

    public Vector getValueMap() {
        if (this.m_metaElement != null) {
            if (this.m_metaElement.getValueArray() == null) {
                return null;
            }
            Vector vaitems = this.m_metaElement.getValueArray().enumValueArray();
            Vector<String> valuemap = new Vector<String>();
            int i = 0;
            while (i < vaitems.size()) {
                ValueArrayItem vai = (ValueArrayItem)vaitems.get(i);
                valuemap.add(vai.getName());
                ++i;
            }
            return valuemap;
        }
        Object valuesQualifier = null;
        if (this.getCimQualifier("values") != null) {
            CIMQualifier valuemapQualifier = this.getCimQualifier("valuemap");
            if (valuemapQualifier != null) {
                return (Vector)valuemapQualifier.getValue().getValue();
            }
        } else if (this.getCimQualifier("valuemap") != null) {
            CIMQualifier valuemapQualifier = this.getCimQualifier("valuemap");
            int numofvalues = ((Vector)valuemapQualifier.getValue().getValue()).size();
            Vector<String> valuemap = new Vector<String>();
            int i = 0;
            while (i < numofvalues) {
                valuemap.add(String.valueOf(i));
                ++i;
            }
            return valuemap;
        }
        return null;
    }

    public Vector getValues() {
        if (this.m_metaElement != null) {
            if (this.m_metaElement.getValueArray() == null) {
                return null;
            }
            Vector vaitems = this.m_metaElement.getValueArray().enumValueArray();
            Vector<String> values = new Vector<String>();
            int i = 0;
            while (i < vaitems.size()) {
                ValueArrayItem vai = (ValueArrayItem)vaitems.get(i);
                values.add(vai.getDisplayName());
                ++i;
            }
            return values;
        }
        CIMQualifier valuesQualifier = null;
        valuesQualifier = this.getCimQualifier("values") != null ? this.getCimQualifier("values") : this.getCimQualifier("valuemap");
        if (valuesQualifier != null) {
            return (Vector)valuesQualifier.getValue().getValue();
        }
        return null;
    }
}

