/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMClass;
import com.ibm.cim.CIMClient;
import com.ibm.cim.CIMException;
import com.ibm.cim.CIMObjectPath;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.AWInputComponent;
import com.ibm.psw.wcl.core.form.WCheckBox;
import com.ibm.psw.wcl.core.form.WComboBox;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.cim.CimClassMeta;
import com.ibm.storage.console.cim.CimDialog;
import com.ibm.storage.console.cim.CimElementMeta;
import com.ibm.storage.console.cim.CimMethodMeta;
import com.ibm.storage.console.cim.CimParameterMeta;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Locale;
import java.util.Vector;

public class CimMethodDialog
extends CimDialog {
    private String m_cimClassName = null;
    private String m_cimMethodName = null;

    public CimMethodDialog(CIMClient cimClient, String classname, String methodname, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        this(cimClient, classname, methodname, null, metaprovider, locale);
    }

    public CimMethodDialog(CIMClient cimClient, String classname, String methodname, ICommandListener commandlistener, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(cimClient, commandlistener, metaprovider, locale);
        SsgLogUtilities.logEntry((Object)this, "CimMethodDialog", classname + ":" + methodname);
        this.m_cimClassName = classname;
        this.m_cimMethodName = methodname;
        this.createForm();
        SsgLogUtilities.logExit((Object)this, "CimMethodDialog", null);
    }

    protected String getPrefixName() {
        return "cimmethoddialog_" + this.m_cimClassName + "_" + this.m_cimMethodName;
    }

    protected void createFields() throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "createFields", null);
        try {
            CIMObjectPath clsPath = new CIMObjectPath(this.m_cimClassName, Console.getCimomManager().getNameSpace());
            CIMClass cls = this.m_cimClient.getClass(clsPath, false);
            CimClassMeta clsMeta = new CimClassMeta(cls, this.m_metaProvider.getClassByName(this.m_cimClassName));
            clsMeta.setLocale(this.m_locale);
            CimMethodMeta methodMeta = clsMeta.getCimMethod(this.m_cimMethodName);
            Vector params = methodMeta.getCimParameters();
            int i = 0;
            while (i < params.size()) {
                CimParameterMeta paramMeta = (CimParameterMeta)params.get(i);
                if (paramMeta.isIn()) {
                    WComponent paramField = this.createFieldComponent(paramMeta);
                    this.cacheField(paramField, paramMeta);
                    this.resetFieldValue((WComponent)((AWInputComponent)paramField));
                }
                ++i;
            }
        }
        catch (CIMException ce) {
            SsgLogUtilities.throwError((Object)this, "createFields", new SsgConsoleException("CIMWIDGET_METHODDIALOG_READERROR", (Exception)((Object)ce)));
        }
        SsgLogUtilities.logExit((Object)this, "createFields", null);
    }

    protected void resetFieldValue(WComponent field) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "resetFieldValue", field.getID());
        AWInputComponent paramField = (AWInputComponent)field;
        String fieldname = paramField.getName().substring(this.getPrefixName().length() + 1);
        CimParameterMeta paramMeta = (CimParameterMeta)this.m_metaElements.get(fieldname);
        int metatype = paramMeta.getMetaType();
        String defaultval = paramMeta.getDefaultValue();
        switch (metatype) {
            case 1: {
                if (defaultval != null && defaultval.equals("true")) {
                    ((WCheckBox)paramField).setChecked(true);
                    break;
                }
                ((WCheckBox)paramField).setChecked(false);
                break;
            }
            case 3: {
                String value;
                if (defaultval != null && (value = paramMeta.getValueByMap(defaultval)) != null) {
                    ((WComboBox)paramField).setSelectedObject((Object)value);
                    break;
                }
                ((WComboBox)paramField).setSelectedIndex(0);
                break;
            }
            default: {
                if (defaultval != null) {
                    ((WTextEntry)paramField).setText(defaultval);
                    break;
                }
                ((WTextEntry)paramField).setText("");
            }
        }
        if (!paramMeta.isOptional()) {
            paramField.setStatus(1);
        } else {
            paramField.setStatus(0);
        }
        SsgLogUtilities.logExit((Object)this, "resetFieldValue", null);
    }

    protected void validateField(String fieldVal, CimElementMeta elemMeta) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "validateField", elemMeta.getDisplayName() + ":" + fieldVal);
        super.validateField(fieldVal, elemMeta);
        CimParameterMeta paramMeta = (CimParameterMeta)elemMeta;
        int metaType = paramMeta.getMetaType();
        if (!(paramMeta.isOptional() || metaType == 1 || metaType == 3 || fieldVal != null && fieldVal.trim().length() != 0)) {
            throw new SsgConsoleException("CIMWIDGET_DIALOG_REQUIREDFIELD", paramMeta.getDisplayName());
        }
        SsgLogUtilities.logExit((Object)this, "validateField", null);
    }
}

