/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMClass;
import com.ibm.cim.CIMClient;
import com.ibm.cim.CIMException;
import com.ibm.cim.CIMInstance;
import com.ibm.cim.CIMObjectPath;
import com.ibm.cim.CIMValue;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.form.AWInputComponent;
import com.ibm.psw.wcl.core.form.WCheckBox;
import com.ibm.psw.wcl.core.form.WComboBox;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.cim.CimClassMeta;
import com.ibm.storage.console.cim.CimDialog;
import com.ibm.storage.console.cim.CimElementMeta;
import com.ibm.storage.console.cim.CimPropertyMeta;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Vector;

public class CimModifyDialog
extends CimDialog {
    private Hashtable m_originalValues = new Hashtable();
    private String m_cimClassName = null;
    private String m_cimUserKeyName = null;
    private String m_cimUserKeyValue = null;

    public CimModifyDialog(CIMClient cimClient, String classname, String userkeyname, String userkeyvalue, ICommandListener commandlistener, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(cimClient, commandlistener, metaprovider, locale);
        SsgLogUtilities.logEntry((Object)this, "CimModifyDialog", classname + ":" + userkeyvalue);
        this.m_cimClassName = classname;
        this.m_cimUserKeyName = userkeyname;
        this.m_cimUserKeyValue = userkeyvalue;
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        this.createForm();
        SsgLogUtilities.logExit((Object)this, "CimModifyDialog", null);
    }

    public boolean isFieldModified(String fieldname) {
        SsgLogUtilities.logEntry((Object)this, "isFieldModified", fieldname);
        Object currentValue = this.getFieldValue(fieldname);
        if (currentValue == null) {
            throw new RuntimeException("The specified field " + fieldname + "is not found!");
        }
        String originalValue = (String)this.m_originalValues.get(fieldname);
        boolean ret = !currentValue.toString().equals(originalValue);
        SsgLogUtilities.logExit((Object)this, "isFieldModified", String.valueOf(ret));
        return ret;
    }

    public String getKeyName() {
        return this.m_cimUserKeyName;
    }

    public String getKeyValue() {
        return this.m_cimUserKeyValue;
    }

    public void destroy() {
        SsgLogUtilities.logEntry((Object)this, "destroy", null);
        this.m_originalValues.clear();
        super.destroy();
        SsgLogUtilities.logExit((Object)this, "destroy", null);
    }

    protected String getPrefixName() {
        return "cimmodifydialog_" + this.m_cimClassName;
    }

    protected void createFields() throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "createFields", null);
        try {
            CIMObjectPath clsPath = new CIMObjectPath(this.m_cimClassName, Console.getCimomManager().getNameSpace());
            CIMClass cls = this.m_cimClient.getClass(clsPath, false);
            CimClassMeta clsMeta = new CimClassMeta(cls, this.m_metaProvider.getClassByName(this.m_cimClassName));
            clsMeta.setLocale(this.m_locale);
            Vector classProperties = clsMeta.getCimProperties();
            clsPath.addKey(this.m_cimUserKeyName, new CIMValue((Object)this.m_cimUserKeyValue));
            CIMInstance instance = this.m_cimClient.getInstance(clsPath, false);
            int i = 0;
            while (i < classProperties.size()) {
                CimPropertyMeta propMeta = (CimPropertyMeta)classProperties.get(i);
                if (propMeta.isWriteable()) {
                    WComponent propField = this.createFieldComponent(propMeta);
                    this.cacheField(propField, propMeta);
                    this.resetFieldValue(propField);
                }
                ++i;
            }
        }
        catch (CIMException ce) {
            SsgLogUtilities.throwError((Object)this, "createFields", new SsgConsoleException("CIMWIDGET_MODIFYDIALOG_READERROR", (Exception)((Object)ce)));
        }
        SsgLogUtilities.logExit((Object)this, "createFields", null);
    }

    protected void resetFieldValue(WComponent field) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "resetFieldValue", field.getID());
        AWInputComponent propField = (AWInputComponent)field;
        String fieldname = propField.getName().substring(this.getPrefixName().length() + 1);
        CimPropertyMeta propMeta = (CimPropertyMeta)this.m_metaElements.get(fieldname);
        CIMValue propValue = null;
        try {
            CIMObjectPath clsPath = new CIMObjectPath(this.m_cimClassName);
            clsPath.addKey(this.m_cimUserKeyName, new CIMValue((Object)this.m_cimUserKeyValue));
            CIMInstance instance = this.m_cimClient.getInstance(clsPath, false);
            propValue = instance.getProperty(propMeta.getCimName()).getValue();
        }
        catch (CIMException ce) {
            SsgLogUtilities.throwError((Object)this, "createFields", new SsgConsoleException("CIMWIDGET_MODIFYDIALOG_READERROR", (Exception)((Object)ce)));
        }
        if (propValue != null) {
            int metatype = propMeta.getMetaType();
            this.m_originalValues.put(fieldname, propValue.getValue().toString());
            switch (metatype) {
                case 1: {
                    Boolean bval = (Boolean)propValue.getValue();
                    if (bval.booleanValue()) {
                        ((WCheckBox)propField).setChecked(true);
                        break;
                    }
                    ((WCheckBox)propField).setChecked(false);
                    break;
                }
                case 3: {
                    String value = propMeta.getValueByMap(propValue.getValue().toString());
                    if (value != null) {
                        ((WComboBox)propField).setSelectedObject((Object)value);
                        break;
                    }
                    ((WComboBox)propField).setSelectedIndex(0);
                    break;
                }
                default: {
                    ((WTextEntry)propField).setText(propValue.getValue().toString());
                }
            }
        }
        if (propMeta.isRequired()) {
            propField.setStatus(1);
        } else {
            propField.setStatus(0);
        }
        SsgLogUtilities.logExit((Object)this, "resetFieldValue", null);
    }

    protected void validateField(String fieldVal, CimElementMeta elemMeta) throws SsgConsoleException {
        super.validateField(fieldVal, elemMeta);
        SsgLogUtilities.logEntry((Object)this, "validateField", elemMeta.getDisplayName() + ":" + fieldVal);
        CimPropertyMeta propMeta = (CimPropertyMeta)elemMeta;
        int metaType = propMeta.getMetaType();
        if (propMeta.isRequired() && metaType != 1 && metaType != 3 && (fieldVal == null || fieldVal.trim().length() == 0)) {
            throw new SsgConsoleException("CIMWIDGET_MODIFYDIALOG_REQUIREDFIELD", propMeta.getDisplayName());
        }
        SsgLogUtilities.logExit((Object)this, "validateField", null);
    }
}

