/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMDataType;
import com.ibm.cim.CIMDateTime;
import com.ibm.cim.CIMElement;
import com.ibm.cim.CIMProperty;
import com.ibm.cim.CIMQualifier;
import com.ibm.cim.CIMValue;
import com.ibm.storage.common.meta.client.MetaElement;
import com.ibm.storage.common.meta.client.MetaProperty;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.cim.CimElementMeta;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.util.Date;

public class CimPropertyMeta
extends CimElementMeta {
    public CimPropertyMeta(CIMProperty cimprop) {
        super((CIMElement)cimprop);
    }

    public CimPropertyMeta(CIMProperty cimprop, MetaProperty metaprop) {
        super((CIMElement)cimprop, (MetaElement)metaprop);
    }

    public CIMDataType getCimDataType() {
        return ((CIMProperty)this.m_cimElement).getType();
    }

    public boolean isCimKey() {
        if (this.m_metaElement != null) {
            return ((MetaProperty)this.m_metaElement).isCIMKey();
        }
        return ((CIMProperty)this.m_cimElement).isKey();
    }

    public CIMProperty getCimProperty() {
        return (CIMProperty)this.m_cimElement;
    }

    public CIMQualifier getCimQualifier(String qualifiername) {
        return ((CIMProperty)this.m_cimElement).getQualifier(qualifiername);
    }

    public boolean isDerived() {
        return this.getCimName().startsWith(".");
    }

    public String getDerivedPropertyName() {
        if (!this.isDerived()) {
            return null;
        }
        return this.getCimName().substring(1);
    }

    public String getDisplayableValue(CIMValue propValue) {
        SsgLogUtilities.logEntry(this, "getDisplayableValue", propValue == null ? "NULL" : String.valueOf(propValue.getValue()));
        if (propValue == null) {
            SsgLogUtilities.logExit(this, "getDisplayableValue", "");
            return "";
        }
        SsgConsoleResource msgutil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.getLocale());
        switch (this.getMetaType()) {
            case 1: {
                Boolean bval = (Boolean)propValue.getValue();
                if (bval.booleanValue()) {
                    return msgutil.getMessage("COMMON_TRUE");
                }
                return msgutil.getMessage("COMMON_FALSE");
            }
            case 3: {
                String mapname = propValue.getValue().toString();
                String mapvalue = this.getValueByMap(mapname);
                if (mapvalue != null) {
                    SsgLogUtilities.logExit(this, "getDisplayableValue", mapvalue);
                    return mapvalue;
                }
                SsgLogUtilities.logExit(this, "getDisplayableValue", "");
                return "";
            }
            case 4: {
                CIMDateTime cdt = (CIMDateTime)propValue.getValue();
                Date date = cdt.getCalendar().getTime();
                return SsgPsUtilities.getTimeString(date, this.getLocale());
            }
            case 0: {
                try {
                    double num = Double.parseDouble(propValue.getValue().toString());
                    return SsgPsUtilities.getNumberString(num, this.getLocale());
                }
                catch (NumberFormatException ex) {
                    return String.valueOf(propValue.getValue());
                }
            }
        }
        SsgLogUtilities.logExit(this, "getDisplayableValue", propValue.getValue().toString());
        return String.valueOf(propValue.getValue());
    }

    public boolean isForeign() {
        if (this.isDerived()) {
            return false;
        }
        return this.getCimName().indexOf(".") != -1;
    }

    public String getForeignClassName() {
        int index = this.getCimName().indexOf(".");
        if (index == -1) {
            return null;
        }
        return this.getCimName().substring(0, index);
    }

    public String getForeignPropertyName() {
        int index = this.getCimName().indexOf(".");
        if (index == -1) {
            return null;
        }
        return this.getCimName().substring(index + 1);
    }

    public boolean isPublic() {
        if (this.m_metaElement != null) {
            if (this.isForeign() && this.isUserKey()) {
                return false;
            }
            return ((MetaProperty)this.m_metaElement).getDisplayScope() == 0 || ((MetaProperty)this.m_metaElement).getDisplayScope() == 8 || ((MetaProperty)this.m_metaElement).getDisplayScope() == 1;
        }
        return true;
    }

    public boolean isRequired() {
        Boolean bReq;
        CIMQualifier reqQualifier = this.getCimQualifier("required");
        return reqQualifier != null && (bReq = (Boolean)reqQualifier.getValue().getValue()) == Boolean.TRUE;
    }

    public boolean isUserKey() {
        if (this.m_metaElement != null) {
            return ((MetaProperty)this.m_metaElement).getDisplayScope() == 8;
        }
        return ((CIMProperty)this.m_cimElement).isKey();
    }

    public boolean isVital() {
        if (this.m_metaElement != null) {
            if (this.isForeign() && this.isUserKey()) {
                return false;
            }
            return ((MetaProperty)this.m_metaElement).getDisplayScope() == 0 || ((MetaProperty)this.m_metaElement).getDisplayScope() == 8;
        }
        return true;
    }

    public boolean isWriteable() {
        Boolean bReq;
        if (this.m_metaElement != null) {
            return ((MetaProperty)this.m_metaElement).isWriteable();
        }
        CIMQualifier writeQualifier = this.getCimQualifier("write");
        return writeQualifier != null && (bReq = (Boolean)writeQualifier.getValue().getValue()) == Boolean.TRUE;
    }
}

