/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMClass;
import com.ibm.cim.CIMClient;
import com.ibm.cim.CIMException;
import com.ibm.cim.CIMInstance;
import com.ibm.cim.CIMObjectPath;
import com.ibm.cim.CIMProperty;
import com.ibm.cim.CIMValue;
import com.ibm.psw.wcl.components.table.DefaultExtendedTableModel;
import com.ibm.psw.wcl.components.table.DefaultTableBooleanFilter;
import com.ibm.psw.wcl.components.table.IExtendedTableModel;
import com.ibm.psw.wcl.components.table.ITableFilter;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.DefaultCell;
import com.ibm.psw.wcl.core.cell.DefaultHyperlinkCell;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.storage.common.meta.client.CIMMetaProvider;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.cim.CimClassMeta;
import com.ibm.storage.console.cim.CimPropertyMeta;
import com.ibm.storage.console.cim.CimTableCellComparator;
import com.ibm.storage.console.cim.CimTableCellInfo;
import com.ibm.storage.console.cim.CimTableCellNumericFilter;
import com.ibm.storage.console.cim.CimTableCellSelectFilter;
import com.ibm.storage.console.cim.CimTableCellStringFilter;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;

public class CimTable
extends WTable {
    public static final int CIMTABLE_TYPE_GENERIC = 0;
    public static final int CIMTABLE_TYPE_NOPAGING = 1;
    public static final int CIMTABLE_TYPE_DISPLAYONLY = 2;
    private static final int[] CIMTABLE_TYPE_FEATURES = new int[]{4031, 11, 8};
    private CIMClient m_cimClient = null;
    private CIMMetaProvider m_metaProvider = null;
    private DefaultExtendedTableModel m_tableModel = null;
    private Enumeration m_cimInstances = null;
    private ICommandListener m_keyListener = null;
    private Locale m_locale = null;
    private Properties m_foreignKeys = new Properties();
    private String m_cimClassName = null;
    private String m_cimQuery = null;
    private String m_keyName = null;
    private Vector m_classProperties = null;
    private int m_keyColumn = -1;
    private int m_type = 0;
    static /* synthetic */ Class class$com$ibm$storage$console$cim$CimTableColumnRenderer;

    public CimTable(CIMClient cimClient, String classname, ICommandListener keylistener, int type, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(null, null, CIMTABLE_TYPE_FEATURES[type]);
        SsgLogUtilities.logEntry((Object)this, "CimTable", classname);
        this.m_cimClient = cimClient;
        this.m_cimClassName = classname;
        this.m_keyListener = keylistener;
        this.m_type = type;
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        this.refresh(this.m_cimClient);
        SsgLogUtilities.logExit((Object)this, "CimTable", null);
    }

    public CimTable(CIMClient cimClient, String classname, String query, ICommandListener keylistener, int type, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(null, null, CIMTABLE_TYPE_FEATURES[type]);
        SsgLogUtilities.logEntry((Object)this, "CimTable(Query)", query);
        this.m_cimClient = cimClient;
        this.m_cimClassName = classname;
        this.m_cimQuery = query;
        this.m_keyListener = keylistener;
        this.m_type = type;
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        this.refresh(cimClient);
        SsgLogUtilities.logExit((Object)this, "CimTable(Query)", null);
    }

    public CimTable(CIMClient cimClient, String classname, Enumeration instances, ICommandListener keylistener, int type, CIMMetaProvider metaprovider, Locale locale) throws SsgConsoleException {
        super(null, null, CIMTABLE_TYPE_FEATURES[type]);
        SsgLogUtilities.logEntry((Object)this, "CimTable(Enumertaion)", null);
        this.m_cimClient = cimClient;
        this.m_cimClassName = classname;
        this.m_cimInstances = instances;
        this.m_keyListener = keylistener;
        this.m_type = type;
        this.m_metaProvider = metaprovider;
        this.m_locale = locale;
        this.refresh(cimClient, instances);
        SsgLogUtilities.logExit((Object)this, "CimTable(Enumertaion)", null);
    }

    public CimTableCellInfo getItem(int row) {
        SsgLogUtilities.logEntry((Object)this, "getKey", this.m_cimClassName + ":" + row);
        if (this.m_keyColumn == -1) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "getKey", "No key column is specified for this class: " + this.m_cimClassName, null);
        }
        CimTableCellInfo keyVal = (CimTableCellInfo)this.getCellInfo(row, this.m_keyColumn).getValue();
        SsgLogUtilities.logExit((Object)this, "getKey", keyVal.toString());
        return keyVal;
    }

    public Locale getLocale() {
        return this.m_locale;
    }

    public CimTableCellInfo getSelectedItem() {
        SsgLogUtilities.logEntry((Object)this, "getSelectedItem", null);
        int[] selectedRows = this.getSelectedRows();
        if (selectedRows.length == 0) {
            return null;
        }
        SsgLogUtilities.logExit((Object)this, "getSelectedItem", null);
        return this.getItem(selectedRows[0]);
    }

    public CimTableCellInfo getSelectedItem(TriggerContext tc) {
        SsgLogUtilities.logEntry((Object)this, "getSelectedItem(TriggerContext)", null);
        Properties selItem = new Properties();
        Enumeration pnames = tc.getParameterNames();
        while (pnames.hasMoreElements()) {
            String pname = (String)pnames.nextElement();
            if (!pname.startsWith("CimKey.")) continue;
            selItem.setProperty(pname.substring("CimKey.".length()), tc.getParameter(pname));
        }
        CimTableCellInfo keyobj = new CimTableCellInfo(tc.getParameter("CimTable.ClassName"), tc.getParameter("CimTable.UserKeyName"), tc.getParameter("CimTable.UserKeyValue"));
        keyobj.addKeys(selItem);
        int numrow = this.getRowCount();
        int i = 0;
        while (i < numrow) {
            CimTableCellInfo curitem = this.getItem(i);
            if (curitem != null && curitem.equals(keyobj)) {
                keyobj.setCimInstance(curitem.getCimInstance());
                keyobj.addProperties(curitem.getProperties());
                break;
            }
            ++i;
        }
        SsgLogUtilities.logExit((Object)this, "getSelectedItem(TriggerContext)", keyobj.toString());
        return keyobj;
    }

    public Vector getSelectedItems() {
        SsgLogUtilities.logEntry((Object)this, "getSelectedItems", null);
        Vector<CimTableCellInfo> selitems = new Vector<CimTableCellInfo>();
        int[] selectedRows = this.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            int row = selectedRows[i];
            selitems.add(this.getItem(row));
            ++i;
        }
        SsgLogUtilities.logExit((Object)this, "getSelectedItems", String.valueOf(selitems.size()));
        return selitems;
    }

    public String getSelectedKey(TriggerContext tc) {
        return tc.getParameter("CimTable.UserKeyValue");
    }

    public Vector getSelectedKeys() {
        SsgLogUtilities.logEntry((Object)this, "getSelectedKeys", null);
        Vector<String> selkeys = new Vector<String>();
        int[] selectedRows = this.getSelectedRows();
        int i = 0;
        while (i < selectedRows.length) {
            int row = selectedRows[i];
            selkeys.add(this.getItem(row).toString());
            ++i;
        }
        SsgLogUtilities.logExit((Object)this, "getSelectedKeys", String.valueOf(selkeys.size()));
        return selkeys;
    }

    public void destroy() {
        SsgLogUtilities.logEntry((Object)this, "destroy", null);
        if (this.m_classProperties != null) {
            this.m_classProperties.removeAllElements();
        }
        this.m_tableModel = null;
        this.m_foreignKeys.clear();
        super.destroy();
        SsgLogUtilities.logExit((Object)this, "destroy", null);
    }

    public void refresh(CIMClient cimClient, Enumeration instances) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "refresh", null);
        this.m_cimClient = cimClient;
        this.m_cimInstances = instances;
        this.resetTableModel();
        if (this.m_type == 2) {
            this.setSelectionMode(-1);
            this.setToolbarVisible(false);
        }
        this.resetTable();
        this.setRowsPerPage(10);
        SsgPsUtilities.setTableStyle(this);
        SsgLogUtilities.logExit((Object)this, "refresh", null);
    }

    public void refresh(CIMClient cimClient) throws SsgConsoleException {
        this.refresh(cimClient, null);
    }

    public void selectItem(CimTableCellInfo item) {
        if (item == null) {
            return;
        }
        int numrow = this.getRowCount();
        int i = 0;
        while (i < numrow) {
            CimTableCellInfo curitem = this.getItem(i);
            if (curitem != null && curitem.equals(item)) {
                this.addRowSelectionInterval(i, i);
                break;
            }
            ++i;
        }
    }

    public void selectItem(String key) {
        if (key == null) {
            return;
        }
        int numrow = this.getRowCount();
        int i = 0;
        while (i < numrow) {
            CimTableCellInfo curitem = this.getItem(i);
            if (curitem != null && curitem.toString().equals(key)) {
                this.addRowSelectionInterval(i, i);
                break;
            }
            ++i;
        }
    }

    protected CIMClient getCimClient() {
        return this.m_cimClient;
    }

    protected ITableFilter getColumnFilter(CimPropertyMeta cimPropMeta) {
        Object colfilter = null;
        switch (cimPropMeta.getMetaType()) {
            case 1: {
                colfilter = new DefaultTableBooleanFilter();
                break;
            }
            case 3: {
                colfilter = new CimTableCellSelectFilter();
                Vector values = cimPropMeta.getValues();
                ((CimTableCellSelectFilter)colfilter).setSelectionList(values);
                break;
            }
            case 0: {
                colfilter = new CimTableCellNumericFilter(this.getLocale());
                break;
            }
            default: {
                colfilter = new CimTableCellStringFilter();
            }
        }
        return colfilter;
    }

    protected Object getDerivedPropertyValue(CimPropertyMeta propMeta, CIMInstance instance) throws CIMException {
        return "";
    }

    protected Object getForeignPropertyValue(CimPropertyMeta propMeta, String foreignkey, String foreignkeyval) throws CIMException {
        SsgLogUtilities.logEntry((Object)this, "getForeignPropertyValue", String.valueOf(propMeta.getMetaType()) + ": key=" + foreignkey + ", val=" + foreignkeyval);
        CIMObjectPath clsPath = new CIMObjectPath(propMeta.getForeignClassName(), Console.getCimomManager().getNameSpace());
        String query = "select * from " + propMeta.getForeignClassName() + " where " + foreignkey + "=\"" + foreignkeyval + "\"";
        CIMValue propValue = null;
        Enumeration instances = this.m_cimClient.execQuery(clsPath, query, 0);
        if (instances != null && instances.hasMoreElements()) {
            CIMInstance instance = (CIMInstance)instances.nextElement();
            propValue = instance.getProperty(propMeta.getForeignPropertyName()).getValue();
        }
        Object retobj = this.getPropertyValue(propMeta, propValue);
        SsgLogUtilities.logExit((Object)this, "getForeignPropertyValue", retobj.toString());
        return retobj;
    }

    protected String getIconAltText(CimPropertyMeta propMeta, String propValue) {
        return null;
    }

    protected String getIconPathName(CimPropertyMeta propMeta, String propValue) {
        SsgLogUtilities.logEntry((Object)this, "getIconPathName", propMeta.getCimName() + ": " + propValue);
        String iconname = null;
        SsgLogUtilities.logExit((Object)this, "getIconPathName", iconname);
        return iconname;
    }

    protected Object getPropertyValue(CimPropertyMeta propMeta, CIMValue propValue) {
        SsgLogUtilities.logEntry((Object)this, "getPropertyValue", String.valueOf(propMeta.getMetaType()));
        Object retobj = null;
        retobj = propMeta.getMetaType() != 1 ? propMeta.getDisplayableValue(propValue) : (propValue != null ? propValue.getValue() : new Boolean(false));
        SsgLogUtilities.logExit((Object)this, "getPropertyValue", retobj.toString());
        return retobj;
    }

    private void setColumnRenderer(int column, CimPropertyMeta cimPropMeta) {
        try {
            if (cimPropMeta.isUserKey() && this.m_type != 2 && this.m_keyListener != null) {
                this.setColumnRenderer(column, class$com$ibm$storage$console$cim$CimTableColumnRenderer == null ? (class$com$ibm$storage$console$cim$CimTableColumnRenderer = CimTable.class$("com.ibm.storage.console.cim.CimTableColumnRenderer")) : class$com$ibm$storage$console$cim$CimTableColumnRenderer, (AWCell)new DefaultHyperlinkCell(this.m_keyListener), RendererInfo.HTML_ALL);
                this.setComparatorForColumn(new CimTableCellComparator(this.m_locale), column);
            } else if (cimPropMeta.getMetaType() != 1) {
                this.setColumnRenderer(column, class$com$ibm$storage$console$cim$CimTableColumnRenderer == null ? (class$com$ibm$storage$console$cim$CimTableColumnRenderer = CimTable.class$("com.ibm.storage.console.cim.CimTableColumnRenderer")) : class$com$ibm$storage$console$cim$CimTableColumnRenderer, (AWCell)new DefaultCell(), RendererInfo.HTML_ALL);
                this.setComparatorForColumn(new CimTableCellComparator(this.m_locale), column);
            }
        }
        catch (RendererException re) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "setColumnRenderer", "Could not render the cim table: " + this.m_cimClassName, (Exception)((Object)re));
        }
    }

    private void resetTable() {
        SsgLogUtilities.logEntry((Object)this, "resetTable", null);
        int col = 0;
        if (this.m_type == 2) {
            col = -1;
        }
        int i = 0;
        while (i < this.m_classProperties.size()) {
            CimPropertyMeta propMeta = (CimPropertyMeta)this.m_classProperties.get(i);
            if (propMeta.isVital()) {
                ++col;
                if (this.m_type != 2) {
                    this.setFilterForColumn(this.getColumnFilter(propMeta), col);
                }
                this.setColumnRenderer(col, propMeta);
            }
            ++i;
        }
        SsgLogUtilities.logExit((Object)this, "resetTable", null);
    }

    private void resetTableModel() throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "resetTableModel", null);
        if (this.m_tableModel != null) {
            this.m_tableModel = null;
        }
        if (this.m_classProperties != null) {
            this.m_classProperties.removeAllElements();
            this.m_classProperties = null;
        }
        this.m_foreignKeys.clear();
        if (this.m_cimClient == null) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "resetTableModel", "The cimom connection was not setup correctly.", null);
        }
        Vector<String> columnNames = new Vector<String>();
        Vector dataRows = new Vector();
        try {
            CIMObjectPath clsPath = new CIMObjectPath(this.m_cimClassName, "root/cimv2");
            CIMClass cls = this.m_cimClient.getClass(clsPath, false);
            CimClassMeta clsMeta = null;
            clsMeta = this.m_metaProvider != null ? new CimClassMeta(cls, this.m_metaProvider.getClassByName(this.m_cimClassName)) : new CimClassMeta(cls);
            clsMeta.setLocale(this.m_locale);
            this.m_classProperties = clsMeta.getCimProperties();
            int col = 0;
            int i = 0;
            while (i < this.m_classProperties.size()) {
                CimPropertyMeta propMeta = (CimPropertyMeta)this.m_classProperties.get(i);
                if (propMeta.isForeign() && propMeta.isUserKey()) {
                    this.m_foreignKeys.setProperty(propMeta.getForeignClassName(), propMeta.getForeignPropertyName());
                }
                if (propMeta.isVital()) {
                    ++col;
                    String header = propMeta.getDisplayName();
                    String unit = "";
                    if (propMeta.isUnitDefined() && (unit = propMeta.getUnit()) != null && unit.trim().length() > 0) {
                        header = header + " (" + unit + ")";
                    }
                    columnNames.add(header);
                    if (propMeta.isUserKey()) {
                        this.m_keyColumn = col;
                        this.m_keyName = propMeta.getCimName();
                    }
                }
                ++i;
            }
            Enumeration instances = null;
            instances = this.m_cimInstances == null ? (this.m_cimQuery == null ? this.m_cimClient.enumInstances(clsPath, true, false) : this.m_cimClient.execQuery(clsPath, this.m_cimQuery, 0)) : this.m_cimInstances;
            if (instances != null) {
                while (instances.hasMoreElements()) {
                    Vector<Object> dataRow = new Vector<Object>();
                    CIMInstance instance = (CIMInstance)instances.nextElement();
                    String keyValue = null;
                    if (this.m_keyName != null) {
                        CimPropertyMeta keyPropMeta = (CimPropertyMeta)this.m_classProperties.get(this.m_keyColumn);
                        if (keyPropMeta.isDerived()) {
                            keyValue = String.valueOf(this.getDerivedPropertyValue(keyPropMeta, instance));
                        } else {
                            CIMProperty keyProp = instance.getProperty(this.m_keyName);
                            keyValue = String.valueOf(keyProp.getValue().getValue());
                        }
                    }
                    int i2 = 0;
                    while (i2 < this.m_classProperties.size()) {
                        CimPropertyMeta propMeta = (CimPropertyMeta)this.m_classProperties.get(i2);
                        if (propMeta.isVital()) {
                            Object realValue = null;
                            if (propMeta.isForeign()) {
                                realValue = this.getForeignPropertyValue(propMeta, this.m_foreignKeys.getProperty(propMeta.getForeignClassName()), keyValue);
                            } else if (propMeta.isDerived()) {
                                realValue = this.getDerivedPropertyValue(propMeta, instance);
                            } else {
                                CIMValue propValue = instance.getProperty(propMeta.getCimName()).getValue();
                                realValue = this.getPropertyValue(propMeta, propValue);
                            }
                            if (realValue instanceof String) {
                                CimTableCellInfo cellinfo = new CimTableCellInfo(cls.getName(), propMeta.getCimName(), (String)realValue, propMeta.getMetaType());
                                if (propMeta.isUserKey()) {
                                    int j = 0;
                                    while (j < this.m_classProperties.size()) {
                                        CimPropertyMeta thePropMeta = (CimPropertyMeta)this.m_classProperties.get(j);
                                        if (!thePropMeta.isForeign() && !thePropMeta.isDerived()) {
                                            CIMValue thePropValue = instance.getProperty(thePropMeta.getCimName()).getValue();
                                            if (thePropMeta.isCimKey()) {
                                                cellinfo.addKey(thePropMeta.getCimName(), String.valueOf(thePropValue.getValue()));
                                            }
                                            if (thePropMeta.isPublic() && thePropValue != null) {
                                                cellinfo.addProperty(thePropMeta.getCimName(), thePropValue.getValue());
                                            }
                                        }
                                        ++j;
                                    }
                                    cellinfo.setCimInstance(instance);
                                }
                                cellinfo.setImagePath(this.getIconPathName(propMeta, (String)realValue), this.getIconAltText(propMeta, (String)realValue));
                                dataRow.add(cellinfo);
                            } else {
                                dataRow.add(realValue);
                            }
                        }
                        ++i2;
                    }
                    dataRows.add(dataRow);
                }
            }
            this.m_tableModel = new DefaultExtendedTableModel(dataRows, columnNames);
            this.setModel((IExtendedTableModel)this.m_tableModel);
        }
        catch (CIMException cimex) {
            SsgLogUtilities.throwError((Object)this, "resetTableModel", SsgConsoleException.getConsoleException(cimex, this.m_metaProvider));
        }
        SsgLogUtilities.logExit((Object)this, "resetTableModel", null);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

