/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.cell.AWCell;
import com.ibm.psw.wcl.core.cell.CellInfo;
import com.ibm.psw.wcl.core.cell.DefaultCell;
import com.ibm.psw.wcl.core.cell.DefaultHyperlinkCell;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.renderer.output.html.HTMLDocumentFragmentWrapper;
import com.ibm.psw.wcl.renderers.table.html.HTMLTableCellRenderer;
import com.ibm.storage.console.ImageUrlResource;
import com.ibm.storage.console.cim.CimTableCellInfo;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.util.Enumeration;
import java.util.Properties;
import org.w3c.dom.Node;
import org.w3c.dom.html.HTMLElement;
import org.w3c.dom.html.HTMLImageElement;

public class CimTableColumnRenderer
extends HTMLTableCellRenderer {
    public IOutput renderCell(RenderingContext rc, AWCell cell, CellInfo cellInfo) throws RendererException {
        SsgLogUtilities.logEntry((Object)this, "renderCell", cellInfo.getValue().toString());
        Object val = cellInfo.getValue();
        if (val != null) {
            CimTableCellInfo tablecell = (CimTableCellInfo)val;
            if (cell instanceof DefaultHyperlinkCell) {
                ((DefaultHyperlinkCell)cell).setText(tablecell.getValue());
                if (tablecell.getMetaType() == 0) {
                    ((DefaultHyperlinkCell)cell).setHorizontalAlignment(2);
                }
                Properties params = new Properties();
                params.put("CimTable.ClassName", tablecell.getClassName());
                params.put("CimTable.UserKeyName", tablecell.getName());
                params.put("CimTable.UserKeyValue", tablecell.getValue());
                Enumeration<?> keys = tablecell.getKeys().propertyNames();
                while (keys.hasMoreElements()) {
                    String prop = (String)keys.nextElement();
                    String value = tablecell.getKeys().getProperty(prop);
                    params.put("CimKey." + prop, value);
                }
                WHyperlink link = ((DefaultHyperlinkCell)cell).getHyperlink();
                link.setTriggerParameters(params);
                return cell.getOutput(rc);
            }
            String displaystr = tablecell.getValue();
            if (displaystr == null || displaystr.length() == 0) {
                displaystr = "-";
            }
            if (tablecell.getImagePath() == null) {
                ((DefaultCell)cell).setText(displaystr);
                if (tablecell.getMetaType() == 0) {
                    ((DefaultCell)cell).setHorizontalAlignment(2);
                }
                return cell.getOutput(rc);
            }
            HTMLDocumentFragmentWrapper doc = rc.getDocumentFactory().createHTMLDocumentFragmentWrapper();
            HTMLElement span = doc.createSPANElement();
            HTMLImageElement image = doc.createIMGElement();
            ImageUrlResource iconRes = new ImageUrlResource(tablecell.getImagePath());
            image.setSrc(iconRes.getFilePart());
            String altstr = tablecell.getImageAltText();
            if (altstr == null) {
                altstr = displaystr;
            }
            image.setAlt(altstr);
            span.appendChild(image);
            span.appendChild(doc.createTextNode("  "));
            span.appendChild(doc.createTextNode(displaystr));
            doc.appendToContentFragment((Node)span);
            return doc.createOutput(rc);
        }
        SsgLogUtilities.logExit((Object)this, "renderCell", null);
        return super.renderCell(rc, cell, cellInfo);
    }
}

