/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.cim;

import com.ibm.cim.CIMClient;
import com.ibm.cim.CIMException;
import com.ibm.cim.CIMInstance;
import com.ibm.cim.CIMObjectPath;
import com.ibm.cim.CIMValue;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.math.BigInteger;
import java.util.Enumeration;

public class CimUtilities {
    public static int getCount(CIMClient cimClient, String cimClass) throws CIMException {
        int count = 0;
        SsgLogUtilities.logEntry("CimUtilities", "getTotal(cimClient, cimClass)", null);
        count = CimUtilities.getCount(cimClient, cimClass, null);
        SsgLogUtilities.logExit("CimUtilities", "getCount(cimClient, cimClass)", String.valueOf(count));
        return count;
    }

    public static int getCount(CIMClient cimClient, String cimClass, String whereClause) throws CIMException {
        int count = 0;
        SsgLogUtilities.logEntry("CimUtilities", "getCount(cimClient, cimClass, whereClause)", null);
        Enumeration instances = null;
        CIMObjectPath cop = new CIMObjectPath(cimClass, Console.getCimomManager().getNameSpace());
        if (whereClause == null || whereClause.length() == 0) {
            SsgLogUtilities.log("CimUtilties", "getCount(cimClient, cimclass, whereClause)", "get list of data from " + cimClass + " to total.");
            instances = cimClient.enumInstances(cop, true, false);
        } else {
            String query = "select * from " + cimClass + " " + whereClause;
            SsgLogUtilities.log("CimUtilities", "getCount(cimClient, cimClass, whereClause)", "get list of data to total: Query=\"" + query + "\"");
            instances = cimClient.execQuery(cop, query, 0);
        }
        if (instances != null) {
            CIMInstance instance = null;
            while (instances.hasMoreElements()) {
                instance = (CIMInstance)instances.nextElement();
                ++count;
            }
        }
        SsgLogUtilities.logExit("CimUtilities", "getCount(cimClient, cimClass, whereClause)", String.valueOf(count));
        return count;
    }

    public static int getCount(Enumeration instances, String column, String value) throws CIMException {
        int count = 0;
        SsgLogUtilities.logEntry("CimUtilities", "getCount(Enumeration, column, value)", "instances, column=" + column + ", value=" + value + ".");
        if (instances != null) {
            CIMInstance instance = null;
            while (instances.hasMoreElements()) {
                instance = (CIMInstance)instances.nextElement();
                if (column != null) {
                    CIMValue cimval = instance.getProperty(column).getValue();
                    if (cimval == null) continue;
                    if (value != null) {
                        if (!value.equals(cimval.getValue().toString())) continue;
                        ++count;
                        continue;
                    }
                    ++count;
                    continue;
                }
                ++count;
            }
        }
        SsgLogUtilities.logExit("CimUtilities", "getCount(instances, column, value)", String.valueOf(count));
        return count;
    }

    public static BigInteger getMaximum(CIMClient cimClient, String cimClass, String column) throws CIMException {
        BigInteger max = null;
        SsgLogUtilities.logEntry("CimUtilities", "getMaximum(cimClient, cimClass, column)", "cimClient, " + cimClass + ", " + column);
        max = CimUtilities.getMaximum(cimClient, cimClass, column, "");
        if (max != null) {
            SsgLogUtilities.logExit("CimUtilities", "getMaximum()", max.toString());
        } else {
            SsgLogUtilities.logExit("CimUtilities", "getMaximum()", "null");
        }
        return max;
    }

    public static BigInteger getMaximum(CIMClient cimClient, String cimClass, String column, String whereClause) throws CIMException {
        SsgLogUtilities.logEntry("CimUtilities", "getMaximum(cimClient, cimClass, column, whereClause)", null);
        Enumeration instances = null;
        BigInteger max = null;
        BigInteger currmax = new BigInteger("-1");
        CIMObjectPath cop = new CIMObjectPath(cimClass, "root/cimv2");
        if (whereClause == null || whereClause.length() == 0) {
            SsgLogUtilities.log("CimUtilties", "getMaximum(cimClient, cimClass, column, whereClause)", "get list of columns from " + cimClass + " to find the max.");
            instances = cimClient.enumInstances(cop, true, false);
        } else {
            String query = "select " + column + " from " + cimClass + " " + whereClause;
            SsgLogUtilities.log("CimUtilities", "getMaximum(cimClient, cimClass, column, whereClause)", "get list of columns to find the max: Query=\"" + query + "\"");
            instances = cimClient.execQuery(cop, query, 0);
        }
        if (instances != null) {
            CIMInstance instance = null;
            while (instances.hasMoreElements()) {
                instance = (CIMInstance)instances.nextElement();
                CIMValue cimval = instance.getProperty(column).getValue();
                if (cimval == null) continue;
                BigInteger propval = new BigInteger(cimval.getValue().toString());
                currmax = currmax.max(propval);
            }
            if (!currmax.equals(new BigInteger("-1"))) {
                max = currmax;
            }
        }
        if (max != null) {
            SsgLogUtilities.logExit("CimUtilities", "getMaximum(cimClient, cimClass, column, whereClause)", max.toString());
        } else {
            SsgLogUtilities.logExit("CimUtilities", "getMaximum(cimClient, cimClass, column, whereClause)", "null");
        }
        return max;
    }

    public static BigInteger getSum(CIMClient cimClient, String cimClass, String column) throws CIMException {
        SsgLogUtilities.logEntry("CimUtilities", "getSum(cimClient, cimClass, column)", null);
        BigInteger sum = CimUtilities.getSum(cimClient, cimClass, column, "");
        if (sum != null) {
            SsgLogUtilities.logExit("CimUtilities", "getSum(cimClient, cimClass, column)", sum.toString());
        } else {
            SsgLogUtilities.logExit("CimUtilities", "getSum(cimClient, cimClass, column)", "null");
        }
        return sum;
    }

    public static BigInteger getSum(CIMClient cimClient, String cimClass, String column, String whereClause) throws CIMException {
        SsgLogUtilities.logEntry("CimUtilities", "getSum(cimClient, cimClass, column, whereClause)", null);
        BigInteger sum = null;
        Enumeration instances = null;
        CIMObjectPath cop = new CIMObjectPath(cimClass, "root/cimv2");
        if (whereClause == null || whereClause.length() == 0) {
            SsgLogUtilities.log("CimUtilties", "getSum(cimClient, cimclass, column, whereClause)", "get list of data from " + cimClass + " to sum.");
            instances = cimClient.enumInstances(cop, true, false);
        } else {
            String query = "select " + column + " from " + cimClass + " " + whereClause;
            SsgLogUtilities.log("CimUtilities", "getSum(cimClient, cimclass, column, whereClause)", "get list of columns to sum: Query=\"" + query + "\"");
            instances = cimClient.execQuery(cop, query, 0);
        }
        if (instances != null) {
            CIMInstance instance = null;
            while (instances.hasMoreElements()) {
                instance = (CIMInstance)instances.nextElement();
                CIMValue cimval = instance.getProperty(column).getValue();
                if (cimval == null) continue;
                sum = sum != null ? sum.add(new BigInteger(cimval.getValue().toString())) : new BigInteger(cimval.getValue().toString());
            }
        }
        if (sum != null) {
            SsgLogUtilities.logExit("CimUtilities", "getSum(cimClient, cimClass, column, whereClause)", sum.toString());
        } else {
            SsgLogUtilities.logExit("CimUtilities", "getSum(cimClient, cimClass, column, whereClause)", "null");
        }
        return sum;
    }

    public static BigInteger getSum(Enumeration instances, String column) throws CIMException {
        SsgLogUtilities.logEntry("CimUtilties", "getSum(instances, column)", "instances, column=" + column + ".");
        BigInteger sum = null;
        if (instances != null) {
            CIMInstance instance = null;
            while (instances.hasMoreElements()) {
                instance = (CIMInstance)instances.nextElement();
                CIMValue cimval = instance.getProperty(column).getValue();
                if (cimval == null) continue;
                sum = sum != null ? sum.add(new BigInteger(cimval.getValue().toString())) : new BigInteger(cimval.getValue().toString());
            }
        }
        if (sum != null) {
            SsgLogUtilities.logExit("CimUtilities", "getSum(instances, column)", sum.toString());
        } else {
            SsgLogUtilities.logExit("CimUtilities", "getSum(instances, column)", "null");
        }
        return sum;
    }
}

