/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.components.message.MessageInfo;
import com.ibm.psw.wcl.components.message.WMessageBox;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.CommandInfo;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.markup.WHyperlink;
import com.ibm.storage.common.IBMErrorString;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.util.HelpUtilities;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.util.Locale;

public class ConsoleMessageBox
extends WMessageBox {
    public static final String ACTION_OK = "msgbox_action_ok";
    public static final String ACTION_CANCEL = "msgbox_action_cancel";
    protected String m_resourceBundle = "com.ibm.storage.console.message.f2c_GuiFrameworkMessageResources_1tcpp9";
    protected ICommandListener m_cmdListener = null;
    protected Locale m_locale = null;
    protected String m_okLabel = null;

    public ConsoleMessageBox(String resbundle, Locale locale) {
        this(resbundle, locale, null, null);
    }

    public ConsoleMessageBox(String resbundle, Locale locale, ICommandListener cmdlistener, String oklabel) {
        this.m_resourceBundle = resbundle;
        this.m_locale = locale;
        this.m_okLabel = oklabel;
        this.m_cmdListener = cmdlistener;
        this.setStyleInfo(SsgPsUtilities.getMessageBoxStyle());
        ICommandListener commandListener = new ICommandListener(){

            public void commandPerformed(CommandEvent cEvent) {
            }
        };
        this.setIDLinkListener(commandListener);
    }

    public final String getReousceBundle() {
        return this.m_resourceBundle;
    }

    public MessageInfo addMessage(String msgkey) {
        return this.addMessage(msgkey, (Object[])null);
    }

    public MessageInfo addMessage(String msgkey, Object[] inserts) {
        SsgLogUtilities.logEntry((Object)this, "addMessage(String,Object[])", msgkey);
        SsgConsoleResource res = new SsgConsoleResource(this.getReousceBundle(), this.m_locale);
        String msgid = res.getMessageId(msgkey);
        if (msgid == null) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "addMessage(String,Object[])", "The message format is invalid: " + msgkey, null);
        }
        MessageInfo info = new MessageInfo(this.m_locale, res.getMessage(msgkey, inserts), this.getReousceBundle(), msgid, this.getMessageType(msgid), 0, null, this.getButtons(this.getMessageType(msgid)), true);
        HelpUtilities.setShowHelpScript(info);
        this.addMessage(info);
        SsgLogUtilities.logExit((Object)this, "addMessage(String,Object[])", null);
        return info;
    }

    public MessageInfo addMessage(SsgConsoleException cex) {
        SsgLogUtilities.logEntry((Object)this, "addMessage(SsgConsoleException)", cex.getMessage());
        String msgid = cex.getMessageId();
        if (msgid == null) {
            SsgLogUtilities.throwUnexpectedError((Object)this, "addMessage(SsgConsoleException)", "The console exception message format is invalid: " + cex.getMessageKey(), null);
        }
        MessageInfo info = new MessageInfo(this.m_locale, cex.getMessage(this.m_locale), null, msgid, this.getMessageType(msgid), 0, null, this.getButtons(this.getMessageType(msgid)), true);
        HelpUtilities.setShowHelpScript(info);
        this.addMessage(info);
        SsgLogUtilities.logExit((Object)this, "addMessage(SsgConsoleException)", null);
        return info;
    }

    public MessageInfo addMessage(IBMErrorString errorobj) {
        SsgLogUtilities.logEntry((Object)this, "addMessage(IBMErrorString)", errorobj.getID() + ": " + errorobj.getError());
        int msgtype = this.getMessageType(errorobj.getID());
        MessageInfo info = new MessageInfo(this.m_locale, errorobj.getError(), null, errorobj.getID(), msgtype, 0, null, this.getButtons(msgtype), true);
        HelpUtilities.setShowHelpScript(info);
        this.addMessage(info);
        SsgLogUtilities.logExit((Object)this, "addMessage(IBMErrorString)", null);
        return info;
    }

    public MessageInfo addMessage(String msgid, String msg) {
        SsgLogUtilities.logEntry((Object)this, "addMessage(String, String)", msgid + ": " + msg);
        MessageInfo info = new MessageInfo(this.m_locale, msg, null, msgid, this.getMessageType(msgid), 0, null, this.getButtons(this.getMessageType(msgid)), true);
        HelpUtilities.setShowHelpScript(info);
        this.addMessage(info);
        SsgLogUtilities.logExit((Object)this, "addMessage(String, String)", null);
        return info;
    }

    public WHyperlink getMessageHyperlink(MessageInfo info) {
        WHyperlink link = null;
        if (info == null) {
            return null;
        }
        try {
            link = (WHyperlink)this.getMessageBoxComponent(info.getMsgID());
        }
        catch (ClassCastException e) {
            SsgLogUtilities.logUnexpectedError((Object)this, "getMessageHyperlink", "infoID=" + info.getMsgID(), (Throwable)e);
        }
        return link;
    }

    public void hide() {
        SsgLogUtilities.logEntry("ConsoleMessageBox", "hide", null);
        this.removeAllMessages();
        SsgLogUtilities.logExit("ConsoleMessageBox", "hide", null);
    }

    protected CommandInfo[] getButtons(int msgtype) {
        CommandInfo[] buttons = null;
        if (this.m_cmdListener != null) {
            SsgConsoleResource msgutil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_locale);
            String clbtn = msgutil.getMessage("COMMON_BUTTON_CANCEL");
            String okbtn = msgutil.getMessage("COMMON_BUTTON_OK");
            if (this.m_okLabel != null) {
                okbtn = this.m_okLabel;
            }
            buttons = msgtype == 1 ? new CommandInfo[]{new CommandInfo(ACTION_CANCEL, clbtn, this.m_cmdListener)} : new CommandInfo[]{new CommandInfo(ACTION_OK, okbtn, this.m_cmdListener), new CommandInfo(ACTION_CANCEL, clbtn, this.m_cmdListener)};
        }
        return buttons;
    }

    protected int getMessageType(String msgid) {
        SsgLogUtilities.logEntry((Object)this, "getMessageType(String)", msgid);
        if (msgid.endsWith("C")) {
            SsgLogUtilities.logExit((Object)this, "getMessageType(String)", String.valueOf(1));
            return 1;
        }
        if (msgid.endsWith("E")) {
            SsgLogUtilities.logExit((Object)this, "getMessageType(String)", String.valueOf(1));
            return 1;
        }
        if (msgid.endsWith("W")) {
            SsgLogUtilities.logExit((Object)this, "getMessageType(String)", String.valueOf(2));
            return 2;
        }
        if (msgid.endsWith("I")) {
            SsgLogUtilities.logExit((Object)this, "getMessageType(String)", String.valueOf(3));
            return 3;
        }
        SsgLogUtilities.logExit((Object)this, "getMessageType(String)", String.valueOf(0));
        return 0;
    }
}

