/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.components.table.AbstractTableFilter;
import com.ibm.psw.wcl.components.table.WTable;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WContainer;
import com.ibm.psw.wcl.core.form.WComboBox;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.psw.wcl.core.layout.WGridLayout;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.util.Locale;
import java.util.Vector;

public class DefaultTableNumericFilter
extends AbstractTableFilter {
    public static final int GREATER = 0;
    public static final int GREATEREQUAL = 1;
    public static final int LESS = 2;
    public static final int LESSEQUAL = 3;
    public static final int EQUAL = 4;
    protected Locale m_locale = null;
    private String filterValue = null;
    private transient WComboBox conditionBox = null;
    private transient WTextEntry input = null;
    private int condition = 0;

    public DefaultTableNumericFilter(Locale locale) {
        this.m_locale = locale;
    }

    public WContainer getDialog(WTable table) {
        SsgConsoleResource msgUtil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_locale);
        WGridLayout layout = new WGridLayout(2, 2);
        WContainer dialog = new WContainer();
        Vector<String> conditions = new Vector<String>();
        conditions.addElement(">");
        conditions.addElement(">=");
        conditions.addElement("<");
        conditions.addElement("<=");
        conditions.addElement("=");
        this.input = new WTextEntry();
        if (this.filterValue != null) {
            this.input.setText(this.filterValue);
        }
        this.conditionBox = new WComboBox("numberFilter_conditions" + table.hashCode(), conditions);
        this.conditionBox.setSelectedIndex(this.condition);
        layout.setGap(5);
        layout.add((WComponent)new WTextComponent(msgUtil.getMessage("WIDGET_NUMERIC_FILTER_CONDITION")));
        layout.add((WComponent)new WTextComponent(msgUtil.getMessage("WIDGET_NUMERIC_FILTER_VALUE")));
        layout.add((WComponent)this.conditionBox);
        layout.add((WComponent)this.input);
        dialog.add((WComponent)layout);
        return dialog;
    }

    public void setObjectValue(Object newValue) {
        this.filterValue = (String)newValue;
    }

    public Object getObjectValue() {
        return this.filterValue;
    }

    public String getStringRepresentation() {
        return this.filterValue;
    }

    public void handleDialog(WTable table) {
        String inputstr = this.input.getText();
        Number inputnum = SsgPsUtilities.getNumber(inputstr, this.m_locale);
        if (inputnum != null) {
            this.setObjectValue(SsgPsUtilities.getNumberString(inputnum.doubleValue(), this.m_locale));
            this.condition = this.conditionBox.getSelectedIndex();
            this.setActive(true);
        } else {
            this.setObjectValue(null);
            this.setActive(false);
        }
    }

    public boolean matches(Object matchTest) {
        boolean matches = false;
        if (null != matchTest && null != this.filterValue) {
            double a = ((Number)matchTest).doubleValue();
            Number fnum = SsgPsUtilities.getNumber(this.filterValue, this.m_locale);
            if (fnum == null) {
                return false;
            }
            double b = fnum.doubleValue();
            switch (this.condition) {
                case 0: {
                    matches = a > b;
                    break;
                }
                case 1: {
                    matches = a >= b;
                    break;
                }
                case 2: {
                    matches = a < b;
                    break;
                }
                case 3: {
                    matches = a <= b;
                    break;
                }
                case 4: {
                    matches = a == b;
                }
            }
        }
        return matches;
    }
}

