/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.frame.AWFrame;
import com.ibm.psw.wcl.core.frame.WFrame;
import com.ibm.psw.wcl.core.layout.WFramesetLayout;
import com.ibm.psw.wcl.core.trigger.IFrameReloadManager;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.User;

public abstract class FramesetPage
extends WPage {
    protected static final int DEFAULT_STYLE = 0;
    protected static final int RESIZABLE = 1;
    protected static final int NOT_RESIZABLE = 0;
    protected static final int BORDER = 2;
    protected static final int NO_BORDER = 0;
    protected static final int SCROLLABLE = 4;
    protected static final int NOT_SCROLLABLE = 0;
    protected static final int RELOADABLE = 8;
    protected static final int NOT_RELOADABLE = 0;
    private IFrameReloadManager m_consoleFRM = null;
    private RenderingContext m_rc = null;
    private User m_user = null;
    private WFramesetLayout m_frameset = null;
    private WFramesetLayout m_rootFrameset = null;
    private WPage m_rootPage = null;
    private WclFacade m_facade = null;

    public FramesetPage(WclFacade facade, RenderingContext rc, User user) {
        this.m_facade = facade;
        this.m_user = user;
        this.m_rc = rc;
        this.m_frameset = new WFramesetLayout();
        this.initFrameset(rc);
    }

    public FramesetPage(WclFacade facade, RenderingContext rc, User user, String[] rows, String[] cols) {
        this.m_facade = facade;
        this.m_user = user;
        this.m_rc = rc;
        this.m_frameset = new WFramesetLayout(rows, cols);
        this.initFrameset(rc);
    }

    private FramesetPage() {
    }

    protected WFramesetLayout getFrameset() {
        return this.m_frameset;
    }

    protected WPage getRootPage() {
        return this.m_rootPage;
    }

    protected User getUser() {
        return this.m_user;
    }

    protected void addFrame(String id, int style, WFrame frame) {
        frame.setID(id);
        frame.setResizable((style & 1) > 0);
        frame.setBorderShown((style & 2) > 0);
        frame.setScrollable((style & 4) > 0);
        this.m_frameset.add((WComponent)frame);
        if ((style & 8) > 0) {
            this.m_consoleFRM.registerFrameReloadable((AWFrame)frame);
        }
    }

    private void initFrameset(RenderingContext rc) {
        this.m_consoleFRM = this.m_facade.getFrameReloadManager((AContext)rc);
        SsgConsoleResource msgutil = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.getUser().getLocale());
        this.m_rootFrameset = new WFramesetLayout();
        this.m_rootFrameset.setFrameBorder("0");
        this.m_rootPage = new WPage();
        this.m_rootPage.setTitle(msgutil.getMessage("FRAME_ROOT"));
        this.m_rootPage.add((WComponent)this.m_frameset);
        WFrame rootframe = new WFrame(this.m_rootPage);
        rootframe.setID("rootFrame");
        rootframe.setTitle(msgutil.getMessage("FRAME_ROOT"));
        rootframe.setResizable(false);
        rootframe.setBorderShown(false);
        rootframe.setScrollable(false);
        this.m_rootFrameset.addRow("*");
        this.m_rootFrameset.add((WComponent)rootframe);
        this.m_consoleFRM.registerFrameReloadable((AWFrame)rootframe);
        this.add((WComponent)this.m_rootFrameset);
    }
}

