/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.form.AWInputComponent;
import com.ibm.psw.wcl.core.form.WButton;
import com.ibm.psw.wcl.core.form.WForm;
import com.ibm.psw.wcl.core.form.WTextEntry;
import com.ibm.psw.wcl.core.layout.WBorderLayout;
import com.ibm.psw.wcl.core.layout.WBoxLayout;
import com.ibm.psw.wcl.core.layout.WTitledLayout;
import com.ibm.psw.wcl.core.markup.WImage;
import com.ibm.psw.wcl.core.markup.WTextComponent;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.storage.console.Application;
import com.ibm.storage.console.ApplicationTemplate;
import com.ibm.storage.console.FileResource;
import com.ibm.storage.console.ImageUrlResource;
import com.ibm.storage.console.RedirectManager;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.User;
import com.ibm.storage.console.gui.ConsoleMessageBox;
import com.ibm.storage.console.gui.HomeFrame;
import com.ibm.storage.console.gui.LauncherPage;
import com.ibm.storage.console.servlet.Console;
import com.ibm.storage.console.util.HelpUtilities;
import com.ibm.storage.console.util.SsgLogUtilities;
import com.ibm.storage.console.util.SsgPsUtilities;
import java.net.URL;
import java.util.Date;
import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LoginPage
extends WPage {
    protected ConsoleMessageBox m_errBox = null;
    protected WTextEntry m_passwordText = null;
    protected WTextEntry m_usernameText = null;
    protected WTitledLayout m_titleText = null;
    private Application m_application = null;
    private HomeFrame m_parent = null;
    private LauncherPage m_launcher = null;
    private Locale m_locale = Locale.getDefault();
    private String COMPNAME_LOGIN_CANCELBUTTON = "loginresetbutton";
    private String COMPNAME_LOGIN_FORM = "loginform";
    private String COMPNAME_LOGIN_LOGINBUTTON = "loginloginbutton";
    private String COMPNAME_LOGIN_PASSWORD = "loginpassword";
    private String COMPNAME_LOGIN_USERNAME = "loginusername";
    private WBoxLayout m_loginLayout = null;
    private int PASSWORD_INVALID = 16;
    private int USERNAME_INVALID = 1;
    private int m_tabIndex = 1;

    public LoginPage(HomeFrame parent, RenderingContext rc) {
        SsgLogUtilities.logEntry((Object)this, "LoginPage(RenderingContext)", null);
        this.m_parent = parent;
        this.createUi(rc);
        SsgLogUtilities.logExit((Object)this, "LoginPage(RenderingContext)", null);
    }

    public void resetLoginPage() {
        SsgLogUtilities.logEntry((Object)this, "resetLoginPage()", null);
        if (this.m_usernameText != null) {
            this.m_usernameText.setText("");
            this.m_usernameText.setStatus(1);
        }
        if (this.m_passwordText != null) {
            this.m_passwordText.setText("");
            this.m_passwordText.setStatus(1);
        }
        this.m_errBox.hide();
        SsgLogUtilities.logExit((Object)this, "resetLoginPage()", null);
    }

    protected void handleLoginButton(TriggerContext tc) throws SsgConsoleException {
        SsgLogUtilities.logEntry((Object)this, "handleLoginButton(TriggerContext)", null);
        HttpServletRequest request = (HttpServletRequest)tc.getRequest();
        String username = null;
        String password = null;
        if (this.m_usernameText != null) {
            username = this.m_usernameText.getText();
        }
        if (this.m_passwordText != null) {
            password = this.m_passwordText.getText();
        }
        int fieldErrors = 0;
        if (username == null || username.length() <= 0) {
            this.m_usernameText.setStatus(2);
            fieldErrors |= this.USERNAME_INVALID;
        } else {
            this.m_usernameText.setStatus(1);
        }
        if (password == null || password.length() <= 0) {
            this.m_passwordText.setStatus(2);
            fieldErrors |= this.PASSWORD_INVALID;
        } else {
            this.m_passwordText.setStatus(1);
        }
        if (fieldErrors == 0) {
            HttpSession sess = request.getSession(true);
            User user = null;
            try {
                user = Console.getUserManager().authenticateUser(username, password);
                if (user != null) {
                    URL url;
                    SsgLogUtilities.log((Object)this, "doPost(HttpServletRequest,HttpServletResponse)", "The user " + user.getID() + " login from the remote host " + request.getRemoteHost());
                    RedirectManager redirectMgr = Console.getRedirectManager();
                    String redirectUrl = null;
                    if (redirectMgr != null && (url = redirectMgr.getRedirectUrl(username, password)) != null) {
                        redirectUrl = url.toString();
                    }
                    if (redirectUrl == null) {
                        user.setLocale(tc.getLocale());
                        user.setHttpUserAgent(request.getHeader("User-Agent"));
                        user.setLoginTime(new Date());
                        user.bindToSession(sess);
                        sess.setMaxInactiveInterval(7200);
                        sess.setAttribute("com.ibm.storage.console.LoginUser", (Object)user);
                    }
                    this.m_launcher.createUi(redirectUrl);
                    tc.setRedirectPath(this.m_launcher.getURL((AContext)tc));
                }
                SsgLogUtilities.logUnexpectedError((Object)this, "handleLoginButton(TriggerContext)", "Could not create the user object: " + username + ", " + password, null);
                this.m_errBox.addMessage("COMMON_UNKNOWN_ERROR");
            }
            catch (SsgConsoleException ce) {
                SsgLogUtilities.logUnexpectedError((Object)this, "handleLoginButton(TriggerContext)", "User authentication failed: " + username, (Throwable)ce);
                throw ce;
            }
        } else {
            if (fieldErrors == this.USERNAME_INVALID) {
                this.m_errBox.addMessage("LOGIN_FORM_USERNAME_REQUIRED");
            }
            if (fieldErrors == this.PASSWORD_INVALID) {
                this.m_errBox.addMessage("LOGIN_FORM_PASSWORD_REQUIRED");
            }
            if (fieldErrors == (this.PASSWORD_INVALID | this.USERNAME_INVALID)) {
                this.m_errBox.addMessage("LOGIN_FORM_USERNAME_AND_PASSWORD_REQUIRED");
            }
        }
        SsgLogUtilities.logExit((Object)this, "handleLoginButton(TriggerContext)", null);
    }

    void createUi(RenderingContext rc) {
        SsgLogUtilities.logEntry((Object)this, "createUi(RenderingContext)", null);
        this.setOnLoad("top.refreshConsole();");
        this.m_locale = rc.getLocale();
        ApplicationTemplate appTemplate = new ApplicationTemplate(new FileResource("application.xml", this.m_locale, 0));
        this.m_application = appTemplate.instantiate();
        this.setTitle(this.getMessage("FRAME_LOGIN"));
        ECommandListener listener = new ECommandListener();
        AStyleInfo frameLayoutStyle = rc.getSkin().getStyleInfo(((Object)((Object)this)).getClass());
        frameLayoutStyle.setStyleValue("page1", "margin-top", (Object)"0px");
        frameLayoutStyle.setStyleValue("page1", "margin-left", (Object)"0px");
        frameLayoutStyle.setStyleValue("page1", "margin-right", (Object)"0px");
        this.setStyleInfo(frameLayoutStyle);
        WBorderLayout imageBox = new WBorderLayout();
        imageBox.setWidth(null);
        this.add((WComponent)imageBox);
        WBoxLayout imageFrameSection = new WBoxLayout("vertical");
        imageFrameSection.setWidth("150");
        imageBox.add((WComponent)imageFrameSection, "west");
        imageBox.setAlignment((WComponent)imageFrameSection, "topleft");
        WBoxLayout welcomeLayout = new WBoxLayout("vertical");
        welcomeLayout.setGap(0);
        imageFrameSection.add((WComponent)welcomeLayout);
        AStyleInfo welcomeLayoutStyle = rc.getSkin().getStyleInfo(welcomeLayout.getClass());
        welcomeLayoutStyle.setStyleValue("lyt1", "background-image", (Object)new ImageUrlResource("ssg/workarea-gradient.gif").getCssUrl());
        welcomeLayout.setStyleInfo(welcomeLayoutStyle);
        WTextComponent blankText = new WTextComponent(" ");
        welcomeLayout.add((WComponent)blankText);
        WImage lockImage = new WImage(new ImageUrlResource("ssg/FDA_lock_90.gif").getFilePart());
        lockImage.setID("lock");
        lockImage.setAltText(this.getMessage("WELCOME_IMAGE"));
        lockImage.setWidth("90");
        lockImage.setHeight("90");
        welcomeLayout.add((WComponent)lockImage);
        welcomeLayout.setAlignment((WComponent)lockImage, "center");
        WBoxLayout textContainer = new WBoxLayout();
        WTextComponent welcomeTextOne = new WTextComponent(this.getMessage("COMMON_WELCOME"));
        welcomeTextOne.setStyleInfo(SsgPsUtilities.getDescriptionTextStyle());
        textContainer.add((WComponent)welcomeTextOne);
        textContainer.setAlignment((WComponent)welcomeTextOne, "center");
        WTextComponent welcomeTextTwo = new WTextComponent(this.m_application.getTitle());
        welcomeTextTwo.setStyleInfo(SsgPsUtilities.getDescriptionTextStyle());
        textContainer.add((WComponent)welcomeTextTwo);
        textContainer.setAlignment((WComponent)welcomeTextTwo, "center");
        welcomeLayout.add((WComponent)textContainer);
        String titlestr = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_locale).getMessage("LOGIN_FORM_HEADING", this.m_application.getTitle());
        this.m_titleText = new WTitledLayout(titlestr, this.getMessage("LOGIN_FORM_DESCRIPTION"));
        String action = null;
        if (rc != null) {
            action = rc.getParameter("Login.action");
        }
        if (action != null && action.equals("logout")) {
            this.m_titleText.setDescription(this.getMessage("LOGIN_FORM_LOGOUT"));
        } else if (action != null && action.equals("sessionexpired")) {
            this.m_titleText.setDescription(this.getMessage("LOGIN_FORM_SESSION_EXPIRED"));
        } else {
            this.m_titleText.setDescription(this.getMessage("LOGIN_FORM_DESCRIPTION"));
        }
        AStyleInfo titleStyle = rc.getSkin().getStyleInfo(this.m_titleText.getClass());
        titleStyle.setStyleValue("lyt3", "white-space", (Object)"nowrap");
        titleStyle.setStyleValue("lyt6", "white-space", (Object)"nowrap");
        titleStyle.setStyleValue("lyt4", "white-space", (Object)"nowrap");
        this.m_titleText.setStyleInfo(titleStyle);
        imageBox.add((WComponent)this.m_titleText, "center");
        imageBox.setAlignment((WComponent)this.m_titleText, "topleft");
        this.m_errBox = new ConsoleMessageBox("com.ibm.storage.console.message.f2c_GuiFrameworkMessageResources_1tcpp9", this.m_locale);
        this.m_titleText.add((WComponent)this.m_errBox);
        WBoxLayout outerBox = new WBoxLayout("vertical");
        outerBox.setGap(0);
        this.m_titleText.add((WComponent)outerBox);
        WForm loginForm = new WForm(this.COMPNAME_LOGIN_FORM);
        loginForm.setMethod("post");
        outerBox.add((WComponent)loginForm);
        this.m_loginLayout = new WBoxLayout("vertical");
        this.m_loginLayout.setGap(20);
        loginForm.add((WComponent)this.m_loginLayout);
        this.m_usernameText = SsgPsUtilities.createTextEntry(this.COMPNAME_LOGIN_USERNAME, this.getMessage("LOGIN_FORM_USERNAME_LABEL"), -1, true);
        this.m_loginLayout.add((WComponent)this.m_usernameText);
        this.m_passwordText = SsgPsUtilities.createTextEntry(this.COMPNAME_LOGIN_PASSWORD, this.getMessage("LOGIN_FORM_PASSWORD_LABEL"), -1, true);
        this.m_passwordText.setPassword(true);
        this.m_loginLayout.add((WComponent)this.m_passwordText);
        WBoxLayout buttonLayout = new WBoxLayout("horizontal");
        buttonLayout.setGap(10);
        buttonLayout.setWidth(null);
        this.m_loginLayout.add((WComponent)buttonLayout);
        WButton loginButton = SsgPsUtilities.createButton(this.COMPNAME_LOGIN_LOGINBUTTON, this.getMessage("LOGIN_FORM_LOGIN_BUTTON"), true);
        loginButton.addCommandListener((ICommandListener)listener);
        buttonLayout.add((WComponent)loginButton);
        WButton cancelButton = SsgPsUtilities.createButton(this.COMPNAME_LOGIN_CANCELBUTTON, this.getMessage("LOGIN_FORM_CANCEL_BUTTON"), true);
        cancelButton.addCommandListener((ICommandListener)listener);
        buttonLayout.add((WComponent)cancelButton);
        String alertUA = this.getMessage("LOGIN_TIMEOUT_MESSAGE");
        WTextComponent timeoutAlert = SsgPsUtilities.createDescriptionComponent(alertUA);
        this.m_loginLayout.add((WComponent)timeoutAlert);
        this.giveFocus((AWInputComponent)this.m_usernameText);
        this.m_launcher = new LauncherPage(rc);
        HelpUtilities.setPanelHelp(this, ((Object)((Object)this)).getClass().getName());
        SsgLogUtilities.logExit((Object)this, "createUI(RenderingContext)", null);
    }

    private String getMessage(String msgkey) {
        return new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", this.m_locale).getMessage(msgkey);
    }

    private void handleCancelButton(TriggerContext tc) {
        SsgLogUtilities.logEntry((Object)this, "handleCancelButton(TriggerContext)", null);
        this.resetLoginPage();
        SsgLogUtilities.logExit((Object)this, "handleCancelButton(TriggerContext)", null);
    }

    private class LoginMessageHelpListener
    implements ICommandListener {
        public void commandPerformed(CommandEvent ce) {
            HelpUtilities.setMessageHelp(LoginPage.this, ce.getCommandName());
            LoginPage.this.m_parent.showHelp();
        }
    }

    private class ECommandListener
    implements ICommandListener {
        private ECommandListener() {
        }

        public void commandPerformed(CommandEvent ce) {
            SsgLogUtilities.logEntry(this, "commandPerformed(CommandEvent)", ((AWInputComponent)ce.getSource()).getName());
            HelpUtilities.setPanelHelp(LoginPage.this, ((Object)((Object)LoginPage.this)).getClass().getName());
            TriggerContext tc = ce.getTriggerContext();
            String name = ((AWInputComponent)ce.getSource()).getName();
            if (name != null) {
                LoginPage.this.m_errBox.hide();
                if (name.equals(LoginPage.this.COMPNAME_LOGIN_LOGINBUTTON)) {
                    try {
                        LoginPage.this.handleLoginButton(tc);
                    }
                    catch (SsgConsoleException e) {
                        LoginPage.this.m_errBox.addMessage(e);
                    }
                } else if (name.equals(LoginPage.this.COMPNAME_LOGIN_CANCELBUTTON)) {
                    LoginPage.this.handleCancelButton(tc);
                }
            }
            SsgLogUtilities.logExit(this, "commandPerformed(CommandEvent)", null);
        }
    }
}

