/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcc.context.IWccContext;
import com.ibm.psw.wcc.context.WccContext;
import com.ibm.psw.wcc.context.adapter.IWccCanvasContextAdapter;
import com.ibm.psw.wcc.context.adapter.IWccTaskbarContextAdapter;
import com.ibm.psw.wcc.context.adapter.WccContextAdapterFactory;
import com.ibm.psw.wcc.mediator.WccMediator;
import com.ibm.psw.wcc.mediator.event.IWccEventHandler;
import com.ibm.psw.wcc.mediator.event.WccEvent;
import com.ibm.psw.wcc.portfolio.WccPortfolio;
import com.ibm.psw.wcc.taskbar.WccTaskManager;
import com.ibm.psw.wcc.taskbar.WccTaskbar;
import com.ibm.psw.wcc.taskbar.WccTaskbarButton;
import com.ibm.psw.wcl.core.AContext;
import com.ibm.psw.wcl.core.CommandEvent;
import com.ibm.psw.wcl.core.ICommandListener;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.TriggerContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WPage;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.frame.WFrame;
import com.ibm.psw.wcl.core.layout.WTitledLayout;
import com.ibm.psw.wcl.core.markup.WHeadMarkup;
import com.ibm.psw.wcl.core.renderer.RendererInfo;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.SsgConsoleException;
import com.ibm.storage.console.SsgConsoleResource;
import com.ibm.storage.console.User;
import com.ibm.storage.console.gui.BannerPage;
import com.ibm.storage.console.gui.FramesetPage;
import com.ibm.storage.console.gui.Taskbar;
import com.ibm.storage.console.gui.WorkAreaPage;
import com.ibm.storage.console.util.HelpUtilities;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Properties;

public class MainPage
extends FramesetPage {
    public static final String HIDDEN_FRAME_NAME = "hidden_area";
    private static final String BANNER_HEIGHT = "35";
    private static final String TOOLBAR_HEIGHT = "32";
    private Taskbar m_taskbar = null;
    private WFrame m_bannerFrame = null;
    private WPage m_reloadFramePage = null;
    private WccMediator m_mediator = null;
    private WorkAreaPage m_workAreaPage = null;

    public MainPage(WclFacade wcl, RenderingContext rc, User user) throws SsgConsoleException {
        super(wcl, rc, user);
        HelpUtilities.initHelpRootPage(this.getRootPage(), this.getFrameset());
        SsgConsoleResource res = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", rc.getLocale());
        this.setTitle(user.getConsoleManager().getConsoleTitle());
        this.getFrameset().setFrameBorder("0");
        WFrame frame = null;
        this.m_reloadFramePage = new WPage("");
        this.m_reloadFramePage.setTitle(res.getMessage("FRAME_HIDDEN"));
        WFrame hiddenForm = new WFrame(this.m_reloadFramePage);
        hiddenForm.setTitle(res.getMessage("FRAME_HIDDEN"));
        this.getFrameset().addRow("0");
        this.addFrame(HIDDEN_FRAME_NAME, 0, hiddenForm);
        this.getFrameset().addRow(BANNER_HEIGHT);
        BannerPage bannerPage = new BannerPage(user);
        this.m_bannerFrame = new WFrame((WPage)bannerPage);
        this.m_bannerFrame.setTitle(bannerPage.getTitle());
        this.addFrame("consoleBannerFrame", 8, this.m_bannerFrame);
        this.m_taskbar = new Taskbar(wcl, this, user);
        this.getFrameset().addRow(this.m_taskbar.getHeight(rc));
        frame = new WFrame((WPage)this.m_taskbar);
        frame.setTitle(this.m_taskbar.getTitle());
        this.addFrame("consoleTaskbarFrame", 8, frame);
        this.m_workAreaPage = new WorkAreaPage(wcl, rc, this, new EConsoleRefreshCommandListener(), user);
        this.getFrameset().addRow("*");
        frame = new WFrame((WPage)this.m_workAreaPage);
        frame.setTitle(this.m_workAreaPage.getTitle());
        this.addFrame("consoleWorkAreaFrame", 9, frame);
        this.m_mediator = new WccMediator((WccPortfolio)this.m_workAreaPage.getPortfolio(), (WccTaskbar)this.m_taskbar, this.m_workAreaPage.getCanvas());
        rc.getSession().setAttribute("WccMediator", (Object)this.m_mediator);
        this.m_mediator.addEventHandler((IWccEventHandler)new TaskEventHandler());
        EAllTasksCallback tasklistener = new EAllTasksCallback();
        this.m_taskbar.addPropertyChangeListener(tasklistener);
        this.m_taskbar.getAllTasksButton().addCommandListener((ICommandListener)tasklistener);
        this.m_workAreaPage.getCanvas().addPropertyChangeListener("CLOSING_PROPERTY", (PropertyChangeListener)tasklistener);
        EConsoleRefreshPropertyListener refreshListener = new EConsoleRefreshPropertyListener();
        this.m_workAreaPage.getCanvas().addPropertyChangeListener((PropertyChangeListener)refreshListener);
        this.m_taskbar.addPropertyChangeListener(refreshListener);
        this.m_workAreaPage.getPortfolio().addPropertyChangeListener(refreshListener);
        StringBuffer js = new StringBuffer();
        js.append("<SCRIPT LANGUAGE=\"javascript\"> ");
        js.append("function refreshConsole() {top.rootFrame.hidden_area.location.reload(true); } ");
        js.append("</SCRIPT>");
        WHeadMarkup head = new WHeadMarkup();
        head.setMarkup(js.toString(), RendererInfo.HTML_ALL);
        this.add((WComponent)head);
        String browser = rc.getDeviceContext().getBrowserVendor();
        if (!browser.equals("Opera")) {
            this.m_workAreaPage.getCanvas().setOnLoad("top.refreshConsole();");
        }
        String logoutMessage = res.getMessage("LOGOUT_CONFIRM_MESSAGE");
        StringBuffer logOutConfirm = new StringBuffer();
        logOutConfirm.append("<SCRIPT LANGUAGE=\"javascript\">\n");
        logOutConfirm.append("function displayConfirmLogout(href)\n{\n");
        logOutConfirm.append(" var name=confirm(\"" + logoutMessage + "\");\n");
        logOutConfirm.append(" if (name==true) \n {\n");
        logOutConfirm.append("window.location=href;\n }\n}");
        logOutConfirm.append("\n</SCRIPT>");
        WHeadMarkup headConfirm = new WHeadMarkup();
        headConfirm.setMarkup(logOutConfirm.toString(), RendererInfo.HTML_ALL);
        this.add((WComponent)headConfirm);
    }

    public WccMediator getMediator() {
        return this.m_mediator;
    }

    public WPage getReloadPage() {
        return this.m_reloadFramePage;
    }

    public Taskbar getTaskbar() {
        return this.m_taskbar;
    }

    public WorkAreaPage getWorkAreaPage() {
        return this.m_workAreaPage;
    }

    public void closeTask(String taskid) {
        SsgLogUtilities.logEntry((Object)this, "closeTask", taskid);
        WccTaskbarButton taskbtn = this.m_taskbar.findButtonWithProperty("Application.taskId", taskid);
        if (taskbtn != null) {
            WccContext taskContext = (WccContext)taskbtn.getContext();
            this.getMediator().closeTask((IWccContext)taskContext);
        }
        SsgLogUtilities.logExit((Object)this, "closeTask", null);
    }

    public void hideBanner() {
        String[] rows = this.getFrameset().getRows();
        rows[1] = "0";
        this.getFrameset().setRows(rows);
    }

    public void launchTask(String taskid, String tasktitle, String adaptorclass, Properties params) {
        SsgLogUtilities.logEntry((Object)this, "launchTask", taskid + ", " + tasktitle + ", " + adaptorclass);
        WccTaskbarButton taskbtn = this.m_taskbar.findButtonWithProperty("Application.taskId", taskid);
        if (taskbtn != null) {
            taskbtn.setSelected(true);
        } else {
            WccContext taskContext = null;
            taskContext = new WccContext();
            String searchPart = "Application.taskId=" + taskid + "&" + "WCLFacade.UserID" + "=" + this.getUser().getID() + "&" + "Console.loginToken" + "=" + this.getUser().getLoginToken() + "&" + "Application.adaptor" + "=" + adaptorclass;
            taskContext.put("Application.taskId", (Object)taskid);
            taskContext.put("Application.adaptor", (Object)adaptorclass);
            taskContext.put("WCLFacade.UserID", (Object)this.getUser().getID());
            taskContext.put("Console.loginToken", (Object)this.getUser().getLoginToken());
            if (params != null) {
                Enumeration<?> props = params.propertyNames();
                while (props.hasMoreElements()) {
                    String pname = (String)props.nextElement();
                    searchPart = searchPart + "&" + "Application." + pname + "=" + params.getProperty(pname);
                    taskContext.put(pname, (Object)params.getProperty(pname));
                }
            }
            IWccCanvasContextAdapter newContext = WccContextAdapterFactory.createCanvasContextAdapter((IWccContext)taskContext);
            WccContextAdapterFactory.createPortfolioContextAdapter((IWccContext)newContext).setPortfolioItemLabel(tasktitle);
            IWccTaskbarContextAdapter taskbarContext = WccContextAdapterFactory.createTaskbarContextAdapter((IWccContext)newContext);
            taskbarContext.setIconShown(true);
            taskbarContext.setTaskbarItemLabel(tasktitle);
            LocalUrlResource resource = new LocalUrlResource("/Application?" + searchPart);
            newContext.setCanvasTaskURL(resource.getFilePart());
            newContext.setCanvasTitle(tasktitle);
            this.getMediator().launchTask((IWccContext)taskContext);
        }
        SsgLogUtilities.logExit((Object)this, "launchTask", null);
    }

    public void refresh() {
        this.getFrameset().setDirty(true);
    }

    public void showBanner() {
        String[] rows = this.getFrameset().getRows();
        rows[1] = BANNER_HEIGHT;
        this.getFrameset().setRows(rows);
    }

    private class EConsoleRefreshPropertyListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent evt) {
            MainPage.this.m_reloadFramePage.setDirty(true);
        }
    }

    private class EAllTasksCallback
    implements ICommandListener,
    PropertyChangeListener {
        private IWccContext m_previousContext = null;
        private WccContext m_taskMgrContext = null;
        private WccTaskManager m_tskMgr = null;

        public void commandPerformed(CommandEvent ce) {
            WccTaskbarButton button;
            if (ce.getCommandName().equals("endTask")) {
                button = this.m_tskMgr.getSelectedButton();
                if (button != null) {
                    IWccContext context = button.getContext();
                    MainPage.this.m_mediator.closeTask(context);
                    if (!context.equals(this.m_previousContext)) {
                        MainPage.this.m_mediator.getCanvas().setContext(this.m_previousContext);
                    }
                    ce.setRedirectPath(MainPage.this.m_mediator.getCanvas().getTaskURL());
                    this.m_previousContext = null;
                }
                if (MainPage.this.getTaskbar().getAllTasksButton().isSelected()) {
                    MainPage.this.getTaskbar().getAllTasksButton().setSelected(false);
                }
            } else if (ce.getCommandName().equals("switchTask")) {
                button = this.m_tskMgr.getSelectedButton();
                if (button != null) {
                    if (button.getContext().equals(this.m_previousContext)) {
                        MainPage.this.m_mediator.getCanvas().setContext(this.m_previousContext);
                    }
                    ce.setRedirectPath(MainPage.this.m_mediator.getCanvas().getTaskURL());
                    this.m_previousContext = null;
                }
                if (MainPage.this.getTaskbar().getAllTasksButton().isSelected()) {
                    MainPage.this.getTaskbar().getAllTasksButton().setSelected(false);
                }
            } else if (MainPage.this.getTaskbar().getAllTasksButton().isSelected()) {
                this.createAllTasksTable(ce.getTriggerContext());
            } else {
                button = this.m_tskMgr.getSelectedButton();
                if (button != null) {
                    if (button.getContext().equals(this.m_previousContext)) {
                        MainPage.this.m_mediator.getCanvas().setContext(this.m_previousContext);
                    }
                    MainPage.this.m_mediator.getCanvas().setContext(this.m_previousContext);
                    this.m_previousContext = null;
                }
                MainPage.this.getTaskbar().getAllTasksButton().setSelected(false);
            }
            Object source = ce.getSource();
            if (source instanceof WComponent) {
                ((WComponent)source).setDirty(true);
            }
        }

        public void propertyChange(PropertyChangeEvent evt) {
            Object source;
            String name = evt.getPropertyName();
            if (name.equals("CLOSING_PROPERTY")) {
                if (this.m_previousContext != null) {
                    MainPage.this.m_mediator.getCanvas().setContext(this.m_previousContext);
                    this.m_previousContext = null;
                }
            } else if (name.equals("destroyed") && (source = evt.getSource()) instanceof WccTaskbar && this.m_tskMgr != null) {
                this.m_tskMgr.getParent().getParent().destroy();
                this.m_tskMgr = null;
            }
        }

        private void createAllTasksTable(TriggerContext tc) {
            if (this.m_taskMgrContext == null || this.m_tskMgr == null) {
                int[] columns = new int[]{1};
                columns = new int[]{1, 2};
                WPage newPage = new WPage();
                this.m_tskMgr = new WccTaskManager(MainPage.this.m_mediator.getTaskbar(), columns, (ICommandListener)this);
                SsgConsoleResource res = new SsgConsoleResource("com.ibm.storage.console.message.ConsoleResources", tc.getLocale());
                newPage.setTitle(res.getMessage("TITLE_TASK_MANAGER"));
                WTitledLayout titledLayout = new WTitledLayout(res.getMessage("TITLE_TASK_MANAGER"));
                titledLayout.add((WComponent)this.m_tskMgr);
                newPage.add((WComponent)titledLayout);
                this.m_taskMgrContext = new WccContext();
                this.m_taskMgrContext.put("IWccCanvasProperties.CANVAS_TASK_URL", (Object)newPage.getURL((AContext)tc));
                this.m_taskMgrContext.put("IWccCanvasProperties.CANVAS_TITLE", (Object)res.getMessage("TITLE_TASK_MANAGER_CANVAS"));
                this.m_taskMgrContext.put("IWccTaskbarProperties.TASKBAR_ITEM_ICON_SHOWN", (Object)new Boolean(false));
            }
            this.m_previousContext = MainPage.this.m_mediator.getCanvas().getContext();
            MainPage.this.m_mediator.getCanvas().setContext((IWccContext)this.m_taskMgrContext);
        }
    }

    public class TaskEventHandler
    implements IWccEventHandler {
        public boolean handleEvent(WccEvent event) {
            if (event.getEventName().equals("TASK_CLOSED_EVENT")) {
                MainPage.this.getUser().destroyTask((String)event.getContext().get("Application.taskId"));
            }
            if (MainPage.this.getTaskbar().getAllTasksButton().isSelected()) {
                MainPage.this.getTaskbar().getAllTasksButton().setSelected(false);
            }
            return false;
        }
    }

    public class EConsoleRefreshCommandListener
    implements ICommandListener {
        public synchronized void commandPerformed(CommandEvent ce) {
            MainPage.this.m_taskbar.toggleTaButton();
            MainPage.this.m_taskbar.setDirty(true);
            MainPage.this.m_workAreaPage.toggleHelp();
            MainPage.this.m_reloadFramePage.setDirty(true);
            ce.setRedirectPath(MainPage.this.m_reloadFramePage.getURL((AContext)ce.getTriggerContext()));
        }
    }
}

