/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.storage.console.gui;

import com.ibm.psw.wcc.context.IWccContext;
import com.ibm.psw.wcc.context.WccContext;
import com.ibm.psw.wcc.context.adapter.IWccCanvasContextAdapter;
import com.ibm.psw.wcc.context.adapter.IWccPortfolioContextAdapter;
import com.ibm.psw.wcc.context.adapter.IWccTaskbarContextAdapter;
import com.ibm.psw.wcc.context.adapter.WccContextAdapterFactory;
import com.ibm.psw.wcc.portfolio.WccPortfolio;
import com.ibm.psw.wcc.portfolio.WccPortfolioNode;
import com.ibm.psw.wcc.taskbar.WccTaskbar;
import com.ibm.psw.wcc.taskbar.WccTaskbarButton;
import com.ibm.psw.wcl.components.tree.DefaultExtendedTreeModel;
import com.ibm.psw.wcl.components.tree.IExtendedTreeModel;
import com.ibm.psw.wcl.core.RenderingContext;
import com.ibm.psw.wcl.core.WComponent;
import com.ibm.psw.wcl.core.WclFacade;
import com.ibm.psw.wcl.core.frame.WFrame;
import com.ibm.psw.wcl.core.layout.WFramesetLayout;
import com.ibm.psw.wcl.core.renderer.RendererException;
import com.ibm.psw.wcl.core.renderer.output.IOutput;
import com.ibm.psw.wcl.core.skin.AStyleInfo;
import com.ibm.storage.console.ActionGroup;
import com.ibm.storage.console.Application;
import com.ibm.storage.console.LocalUrlResource;
import com.ibm.storage.console.User;
import com.ibm.storage.console.util.SsgLogUtilities;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class Portfolio
extends WccPortfolio {
    private Application m_application = null;
    private DefaultExtendedTreeModel m_recentAreaTreeModel = null;
    private DefaultExtendedTreeModel m_treeModel = null;
    private IWccContext m_welcomeContext = null;
    private User m_user = null;
    private WccPortfolioNode m_recentAreaRootNode = null;
    private WccPortfolioNode m_rootNode = null;

    public synchronized IOutput getOutput(RenderingContext rc) throws RendererException {
        SsgLogUtilities.logEntry((Object)this, "getOutput()", null);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        SsgLogUtilities.logExit((Object)this, "getOutput()", null);
        return super.getOutput(rc);
    }

    public Portfolio(WclFacade wcl, User user) {
        IWccPortfolioContextAdapter rootContext = WccContextAdapterFactory.createPortfolioContextAdapter((IWccContext)new WccContext());
        rootContext.setPortfolioItemLabel("<root>");
        this.m_rootNode = new WccPortfolioNode((IWccContext)rootContext);
        this.m_treeModel = new DefaultExtendedTreeModel((TreeNode)this.m_rootNode);
        this.m_user = user;
        this.m_application = user.getApplication();
        Vector groups = this.m_application.getActionGroups();
        int i = 0;
        while (i < groups.size()) {
            this.addActionGroup((ActionGroup)groups.get(i), this.m_rootNode);
            ++i;
        }
        this.setModel((IExtendedTreeModel)this.m_treeModel);
    }

    public WFrame getBottomAreaFrame() {
        WFramesetLayout framesetLayout = this.getPortfolioFrameset();
        WFrame bottomAreaFrame = (WFrame)framesetLayout.findComponentById("bottomAreaFrame");
        WComponent component = framesetLayout.findChildComponent("bottomAreaFrame");
        int count = framesetLayout.getChildComponentCount();
        return bottomAreaFrame;
    }

    public AStyleInfo getEntriesFrameStyle() {
        WFramesetLayout framesetLayout = this.getPortfolioFrameset();
        WFrame entriesFrame_ = (WFrame)framesetLayout.findComponentById("taskEntriesFrame");
        AStyleInfo styleInfo = entriesFrame_.getPage().getStyleInfo();
        return styleInfo;
    }

    public IWccContext getTaskContext(String taskid, WccPortfolioNode parentnode) {
        if (parentnode == null) {
            parentnode = this.m_rootNode;
        }
        int nodeCount = parentnode.getChildCount();
        int i = 0;
        while (i < nodeCount) {
            IWccContext thecontext;
            WccPortfolioNode thenode = (WccPortfolioNode)this.m_treeModel.getChild((Object)parentnode, i);
            String thetaskid = (String)thenode.getContext().get("Application.taskId");
            if (thetaskid != null && taskid.equals(thetaskid)) {
                return thenode.getContext();
            }
            if (thenode.getAllowsChildren() && (thecontext = this.getTaskContext(taskid, thenode)) != null) {
                return thecontext;
            }
            ++i;
        }
        return null;
    }

    public IWccContext getWelcomeContext() {
        return this.m_welcomeContext;
    }

    public void enableRecentTaskArea(WccTaskbar taskbar) {
        IWccPortfolioContextAdapter rc = WccContextAdapterFactory.createPortfolioContextAdapter((IWccContext)new WccContext());
        rc.setPortfolioItemLabel("<root>");
        this.m_recentAreaRootNode = new WccPortfolioNode((IWccContext)rc);
        this.m_recentAreaTreeModel = new DefaultExtendedTreeModel((TreeNode)this.m_recentAreaRootNode);
        this.setAuxiliaryModel((IExtendedTreeModel)this.m_recentAreaTreeModel);
        this.setAuxiliaryEntriesAreaShown(true);
        taskbar.addPropertyChangeListener("IWccTaskbarProperties.TASKBAR_ITEM_ADD", (PropertyChangeListener)new ERecentTasksListener());
    }

    private void addActionGroup(ActionGroup group, WccPortfolioNode parent) {
        block2: {
            block1: {
                SsgLogUtilities.logEntrySSG((Object)this, "addActionGroup(ActionGroup,WccPortfolioNode)", "group=" + group + ", parent=" + parent);
                if (!group.isLeaf()) break block1;
                if (!group.getActionItem().hasPermission(this.m_user.getRole())) break block2;
                IWccContext context = this.addPageAdaptor(group, parent);
                if (!group.getName().equals("welcome")) break block2;
                this.m_welcomeContext = context;
                break block2;
            }
            WccPortfolioNode folder = this.addFolder(group.getTitle(), parent);
            Vector subItems = group.getChildren();
            int j = 0;
            while (j < subItems.size()) {
                ActionGroup subgroup = (ActionGroup)subItems.get(j);
                this.addActionGroup(subgroup, folder);
                ++j;
            }
        }
    }

    private WccPortfolioNode addFolder(String label, WccPortfolioNode parentnode) {
        IWccCanvasContextAdapter newContext = WccContextAdapterFactory.createCanvasContextAdapter((IWccContext)new WccContext());
        WccContextAdapterFactory.createPortfolioContextAdapter((IWccContext)newContext).setPortfolioItemLabel(label);
        WccPortfolioNode node = new WccPortfolioNode((IWccContext)newContext);
        this.m_treeModel.insertNodeInto((MutableTreeNode)node, (MutableTreeNode)parentnode, this.m_treeModel.getChildCount((Object)parentnode));
        return node;
    }

    private IWccContext addPageAdaptor(ActionGroup group, WccPortfolioNode folder) {
        SsgLogUtilities.logEntrySSG((Object)this, "addPageAdaptor(ActionGroup,WccPortfolioNode)", "group=" + group + ", folder=" + folder);
        String searchPart = "Application.taskId=" + group.getName() + "&" + "WCLFacade.UserID" + "=" + this.m_user.getID() + "&" + "Console.loginToken" + "=" + this.m_user.getLoginToken();
        LocalUrlResource resource = new LocalUrlResource("/Application?" + searchPart);
        WccContext adaptorContext = new WccContext();
        adaptorContext.put("Application.taskId", (Object)group.getName());
        adaptorContext.put("WCLFacade.UserID", (Object)this.m_user.getID());
        adaptorContext.put("Console.loginToken", (Object)this.m_user.getLoginToken());
        SsgLogUtilities.logExitSSG((Object)this, "addPageAdaptor(ActionGroup,WccPortfolioNode)", null);
        return this.addUrlItem(group.getTitle(), resource.getFilePart(), folder, adaptorContext);
    }

    private IWccContext addUrlItem(String label, String url, WccPortfolioNode folder, WccContext context) {
        IWccCanvasContextAdapter newContext = WccContextAdapterFactory.createCanvasContextAdapter((IWccContext)context);
        WccContextAdapterFactory.createPortfolioContextAdapter((IWccContext)newContext).setPortfolioItemLabel(label);
        IWccTaskbarContextAdapter taskbarContext = WccContextAdapterFactory.createTaskbarContextAdapter((IWccContext)newContext);
        taskbarContext.setIconShown(true);
        taskbarContext.setTaskbarItemLabel(label);
        newContext.setCanvasTaskURL(url);
        newContext.setCanvasTitle(label);
        WccPortfolioNode newNode = new WccPortfolioNode((IWccContext)newContext);
        this.m_treeModel.insertNodeInto((MutableTreeNode)newNode, (MutableTreeNode)folder, this.m_treeModel.getChildCount((Object)folder));
        return newContext;
    }

    public class ERecentTasksListener
    implements PropertyChangeListener {
        private final int MAX_SIZE = 5;

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("IWccTaskbarProperties.TASKBAR_ITEM_ADD")) {
                IWccContext context = ((WccTaskbarButton)evt.getNewValue()).getContext();
                if (context.get("IWccContextKeys.PORTFOLIO_TASK_CONTEXT") != null) {
                    context = (IWccContext)context.get("IWccContextKeys.PORTFOLIO_TASK_CONTEXT");
                }
                int nodeCount = Portfolio.this.m_recentAreaRootNode.getChildCount();
                if (context.get("IWccPortfolioProperties.PORTFOLIO_ITEM_LABEL") != null) {
                    boolean bNodeExist = false;
                    int i = 0;
                    while (i < nodeCount) {
                        WccPortfolioNode thenode = (WccPortfolioNode)Portfolio.this.m_recentAreaTreeModel.getChild((Object)Portfolio.this.m_recentAreaRootNode, i);
                        String taskid = (String)context.get("Application.taskId");
                        String thetaskid = (String)thenode.getContext().get("Application.taskId");
                        if (taskid != null && thetaskid != null && taskid.equals(thetaskid)) {
                            bNodeExist = true;
                            break;
                        }
                        ++i;
                    }
                    if (!bNodeExist) {
                        if (nodeCount < 5) {
                            Portfolio.this.m_recentAreaTreeModel.insertNodeInto((MutableTreeNode)new WccPortfolioNode(context), (MutableTreeNode)Portfolio.this.m_recentAreaRootNode, nodeCount);
                        } else {
                            Portfolio.this.m_recentAreaTreeModel.removeNodeFromParent((MutableTreeNode)Portfolio.this.m_recentAreaRootNode.getChildAt(0));
                            Portfolio.this.m_recentAreaTreeModel.insertNodeInto((MutableTreeNode)new WccPortfolioNode(context), (MutableTreeNode)Portfolio.this.m_recentAreaRootNode, nodeCount - 1);
                        }
                    }
                }
            }
        }
    }
}

